import { ThemeProvider, styled } from "solid-styled-components";

import base from './base'
import second from './second'

import memory, { memo } from "../memory"
import schemes from 'nice-color-palettes'

const search = (path) => ({mem}) => {
  let labels = path.split(".")
  // let appearance = theme
  let appearance = base

  while (labels.length > 0) {
    let l = labels.shift()
    appearance = appearance[l]
  }

  return appearance
}

const color = (num) => ({}) => {
  const { mem, remember } = memory()
  return schemes[mem.scheme][num]
}

const scheme = styled;
const s = search;
const c = color;

export {
  ThemeProvider, scheme, s, c,
  base, second
}
