import { next as A } from "@automerge/automerge";
import { isReconcileTx } from "./plugin";
export const applyCmTransactionsToAmHandle = (handle, path, transactions) => {
    const transactionsWithChanges = transactions.filter(tr => !isReconcileTx(tr) && !tr.changes.empty);
    if (transactionsWithChanges.length === 0) {
        return;
    }
    handle.change((doc) => {
        transactionsWithChanges.forEach(tr => {
            tr.changes.iterChanges((fromA, toA, fromB, _toB, inserted) => {
                // We are cloning the path as `am.splice` calls `.unshift` on it, modifying it in place,
                // causing the path to be broken on subsequent changes
                A.splice(doc, path.slice(), fromB, toA - fromA, inserted.toString());
            });
        });
    });
    return A.getHeads(handle.docSync());
};
//# sourceMappingURL=codeMirrorToAm.js.map