import { NetworkAdapter, PeerId, PeerMetadata } from "@automerge/automerge-repo/slim";
import WebSocket from "isomorphic-ws";
import { FromClientMessage } from "./messages.js";
declare abstract class WebSocketNetworkAdapter extends NetworkAdapter {
    socket?: WebSocket;
}
export declare class BrowserWebSocketClientAdapter extends WebSocketNetworkAdapter {
    #private;
    readonly url: string;
    readonly retryInterval: number;
    remotePeerId?: PeerId;
    constructor(url: string, retryInterval?: number);
    connect(peerId: PeerId, peerMetadata?: PeerMetadata): void;
    onOpen: () => void;
    onClose: () => void;
    onMessage: (event: WebSocket.MessageEvent) => void;
    /** The websocket error handler signature is different on node and the browser.  */
    onError: (event: Event | WebSocket.ErrorEvent) => void;
    join(): void;
    disconnect(): void;
    send(message: FromClientMessage): void;
    peerCandidate(remotePeerId: PeerId, peerMetadata: PeerMetadata): void;
    receiveMessage(messageBytes: Uint8Array): void;
}
export {};
//# sourceMappingURL=BrowserWebSocketClientAdapter.d.ts.map