import WebSocket from "isomorphic-ws";
import { type WebSocketServer } from "isomorphic-ws";
import { NetworkAdapter, type PeerMetadata, type PeerId } from "@automerge/automerge-repo/slim";
import { FromServerMessage } from "./messages.js";
export declare class NodeWSServerAdapter extends NetworkAdapter {
    #private;
    private server;
    private keepAliveInterval;
    sockets: {
        [peerId: PeerId]: WebSocket;
    };
    constructor(server: WebSocketServer, keepAliveInterval?: number);
    connect(peerId: PeerId, peerMetadata?: PeerMetadata): void;
    disconnect(): void;
    send(message: FromServerMessage): void;
    receiveMessage(messageBytes: Uint8Array, socket: WebSocket): void;
}
//# sourceMappingURL=NodeWSServerAdapter.d.ts.map