import { DocHandle, Repo } from '@automerge/automerge-repo/slim';

export declare const setHash: (hash: string, pushState?: boolean) => void;
export declare const useHash: () => string;
export interface UseBootstrapOptions<T> {
    /** Key to use for the URL hash and localStorage */
    key?: string;
    /** Function returning a document handle called if lookup fails. Defaults to repo.create() */
    onNoDocument?: (repo: Repo) => DocHandle<T>;
    /** Function to call if automerge URL is invalid */
    onInvalidAutomergeUrl?(repo: Repo, error: Error): DocHandle<T>;
}
/**
 * @deprecated Use the simpler example code in the README instead.
 * This hook is used to set up a single document as the base of an app session.
 * This is a common pattern for simple multiplayer apps with shareable URLs.
 *
 * It will first check for the automergeUrl in the URL hash:
 *   //myapp/#automergeUrl=[document URL]
 * Failing that, it will check for a `automergeUrl` key in localStorage.
 * Failing that, it will call onNoDocument, expecting a handle to be returned.
 *
 * The URL and localStorage will then be updated.
 * Finally, it will return the Automerge document's URL.
 *
 * @param {string?} props.key Key to use for the URL hash and localStorage
 * @param {function?} props.fallback Function returning a document handle called if lookup fails. Defaults to repo.create()
 * @param {function?} props.onInvalidAutomergeUrl Function to call if URL is invalid; signature (error) => (repo, onCreate)
 * @returns {DocHandle} The document handle
 */
export declare const useBootstrap: <T>({ key, onNoDocument, onInvalidAutomergeUrl, }?: UseBootstrapOptions<T>) => DocHandle<T>;
//# sourceMappingURL=useBootstrap.d.ts.map