import { type Target, Text1Target, Text2Target } from "./proxies.js";
import { ValueType } from "./proxies.js";
import type { Automerge, Prop, ObjID } from "./wasm_types.js";
export type ConflictsF<T extends Target> = {
    [key: string]: ValueType<T>;
};
export type Conflicts = ConflictsF<Text1Target>;
export type UnstableConflicts = ConflictsF<Text2Target>;
export declare function stableConflictAt(context: Automerge, objectId: ObjID, prop: Prop): Conflicts | undefined;
export declare function unstableConflictAt(context: Automerge, objectId: ObjID, prop: Prop): UnstableConflicts | undefined;
