import { Counter } from "./types.js";
import { Text } from "./text.js";
import { mapProxy, listProxy } from "./proxies.js";
export function stableConflictAt(context, objectId, prop) {
    return conflictAt(context, objectId, prop, true, (context, conflictId) => {
        return new Text(context.text(conflictId));
    });
}
export function unstableConflictAt(context, objectId, prop) {
    return conflictAt(context, objectId, prop, true, (context, conflictId) => {
        return context.text(conflictId);
    });
}
function conflictAt(context, objectId, prop, textV2, handleText) {
    const values = context.getAll(objectId, prop);
    if (values.length <= 1) {
        return;
    }
    const result = {};
    for (const fullVal of values) {
        switch (fullVal[0]) {
            case "map":
                result[fullVal[1]] = mapProxy(context, fullVal[1], textV2, [prop]);
                break;
            case "list":
                result[fullVal[1]] = listProxy(context, fullVal[1], textV2, [prop]);
                break;
            case "text":
                result[fullVal[1]] = handleText(context, fullVal[1]);
                break;
            case "str":
            case "uint":
            case "int":
            case "f64":
            case "boolean":
            case "bytes":
            case "null":
                result[fullVal[2]] = fullVal[1];
                break;
            case "counter":
                result[fullVal[2]] = new Counter(fullVal[1]);
                break;
            case "timestamp":
                result[fullVal[2]] = new Date(fullVal[1]);
                break;
            default:
                throw RangeError(`datatype ${fullVal[0]} unimplemented`);
        }
    }
    return result;
}
