import { Text } from "./text.js";
import type { Automerge, ObjID, Prop } from "./wasm_types.js";
import type { AutomergeValue, MapValue, ListValue } from "./types.js";
import { type AutomergeValue as UnstableAutomergeValue, MapValue as UnstableMapValue, ListValue as UnstableListValue } from "./next_types.js";
import { RawString } from "./raw_string.js";
type TargetCommon = {
    context: Automerge;
    objectId: ObjID;
    path: Array<Prop>;
    cache: object;
    trace?: any;
};
export type Text2Target = TargetCommon & {
    textV2: true;
};
export type Text1Target = TargetCommon & {
    textV2: false;
};
export type Target = Text1Target | Text2Target;
export type ValueType<T extends Target> = T extends Text2Target ? UnstableAutomergeValue : T extends Text1Target ? AutomergeValue : never;
type MapValueType<T extends Target> = T extends Text2Target ? UnstableMapValue : T extends Text1Target ? MapValue : never;
type ListValueType<T extends Target> = T extends Text2Target ? UnstableListValue : T extends Text1Target ? ListValue : never;
export declare function mapProxy<T extends Target>(context: Automerge, objectId: ObjID, textV2: boolean, path: Prop[]): MapValueType<T>;
export declare function listProxy<T extends Target>(context: Automerge, objectId: ObjID, textV2: boolean, path: Prop[]): ListValueType<T>;
interface TextProxy extends Text {
    splice: (index: any, del: any, ...vals: any[]) => void;
}
export declare function textProxy(context: Automerge, objectId: ObjID, path: Prop[]): TextProxy;
export declare function rootProxy<T>(context: Automerge, textV2: boolean): T;
export declare function isRawString(obj: any): obj is RawString;
export declare function isText(obj: any): obj is Text;
export {};
