import { pause } from "../../src/helpers/pause.js";
import { NetworkAdapter } from "../../src/index.js";
export class DummyNetworkAdapter extends NetworkAdapter {
    #startReady;
    #sendMessage;
    constructor(opts = { startReady: true }) {
        super();
        this.#startReady = opts.startReady || false;
        this.#sendMessage = opts.sendMessage;
    }
    connect(peerId) {
        this.peerId = peerId;
        if (this.#startReady) {
            this.emit("ready", { network: this });
        }
    }
    disconnect() { }
    peerCandidate(peerId) {
        this.emit("peer-candidate", { peerId, peerMetadata: {} });
    }
    send(message) {
        this.#sendMessage?.(message);
    }
    receive(message) {
        this.emit("message", message);
    }
    static createConnectedPair({ latency = 10 } = {}) {
        const adapter1 = new DummyNetworkAdapter({
            startReady: true,
            sendMessage: (message) => pause(latency).then(() => adapter2.receive(message)),
        });
        const adapter2 = new DummyNetworkAdapter({
            startReady: true,
            sendMessage: (message) => pause(latency).then(() => adapter1.receive(message)),
        });
        return [adapter1, adapter2];
    }
}
