import {styleTags, tags as t} from "@lezer/highlight"

export const goHighlighting = styleTags({
  "func interface struct chan map const type var": t.definitionKeyword,
  "import package": t.moduleKeyword,
  "switch for go select return break continue goto fallthrough case if else defer": t.controlKeyword,
  "range": t.keyword,
  Bool: t.bool,
  String: t.string,
  Rune: t.character,
  Number: t.number,
  Nil: t.null,
  VariableName: t.variableName,
  DefName: t.definition(t.variableName),
  TypeName: t.typeName,
  LabelName: t.labelName,
  FieldName: t.propertyName,
  "FunctionDecl/DefName": t.function(t.definition(t.variableName)),
  "TypeSpec/DefName": t.definition(t.typeName),
  "CallExpr/VariableName": t.function(t.variableName),
  LineComment: t.lineComment,
  BlockComment: t.blockComment,
  LogicOp: t.logicOperator,
  ArithOp: t.arithmeticOperator,
  BitOp: t.bitwiseOperator,
  "DerefOp .": t.derefOperator,
  "UpdateOp IncDecOp": t.updateOperator,
  CompareOp: t.compareOperator,
  "= :=": t.definitionOperator,
  "<-": t.operator,
  "~ \"*\"": t.modifier,
  "; ,": t.separator,
  "... :": t.punctuation,
  "( )": t.paren,
  "[ ]": t.squareBracket,
  "{ }": t.brace,
})
