import { LRLanguage, LanguageSupport } from '@codemirror/language';

/**
A language provider for Vue templates.
*/
declare const vueLanguage: LRLanguage;
/**
Vue template support.
*/
declare function vue(config?: {
    /**
    Provide an HTML language configuration to use as a base. _Must_
    be the result of calling `html()` from `@codemirror/lang-html`,
    not just any `LanguageSupport` object.
    */
    base?: LanguageSupport;
}): LanguageSupport;

export { vue, vueLanguage };
