<!-- NOTE: README.md is generated from src/README.md -->

# @codemirror/lang-go [![NPM version](https://img.shields.io/npm/v/@codemirror/lang-go.svg)](https://www.npmjs.org/package/@codemirror/lang-go)

[ [**WEBSITE**](https://codemirror.net/) | [**ISSUES**](https://github.com/codemirror/dev/issues) | [**FORUM**](https://discuss.codemirror.net/c/next/) | [**CHANGELOG**](https://github.com/codemirror/lang-go/blob/main/CHANGELOG.md) ]

This package implements Go language support for the
[CodeMirror](https://codemirror.net/) code editor.

The [project page](https://codemirror.net/) has more information, a
number of [examples](https://codemirror.net/examples/) and the
[documentation](https://codemirror.net/docs/).

This code is released under an
[MIT license](https://github.com/codemirror/lang-go/tree/main/LICENSE).

We aim to be an inclusive, welcoming community. To make that explicit,
we have a [code of
conduct](http://contributor-covenant.org/version/1/1/0/) that applies
to communication around the project.

## API Reference

<dl>
<dt id="user-content-go">
  <code><strong><a href="#user-content-go">go</a></strong>() → <a href="https://codemirror.net/docs/ref#language.LanguageSupport">LanguageSupport</a></code></dt>

<dd><p>Go support. Includes <a href="#user-content-snippets">snippet</a> and local
variable completion.</p>
</dd>
<dt id="user-content-golanguage">
  <code><strong><a href="#user-content-golanguage">goLanguage</a></strong>: <a href="https://codemirror.net/docs/ref#language.LRLanguage">LRLanguage</a></code></dt>

<dd><p>A language provider based on the <a href="https://github.com/lezer-parser/go">Lezer Go
parser</a>, extended with
folding and indentation information.</p>
</dd>
<dt id="user-content-snippets">
  <code><strong><a href="#user-content-snippets">snippets</a></strong>: readonly <a href="https://codemirror.net/docs/ref#autocomplete.Completion">Completion</a>[]</code></dt>

<dd><p>A collection of Go-related <a href="https://codemirror.net/docs/ref/#autocomplete.snippet">snippets</a>.</p>
</dd>
<dt id="user-content-localcompletionsource">
  <code><strong><a href="#user-content-localcompletionsource">localCompletionSource</a></strong>: <a href="https://codemirror.net/docs/ref#autocomplete.CompletionSource">CompletionSource</a></code></dt>

<dd><p>Completion source that looks up locally defined names in Go code.</p>
</dd>
</dl>
