"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useDPRMultiple_exports = {};
__export(useDPRMultiple_exports, {
  nearestMultiple: () => nearestMultiple,
  useDPRMultiple: () => useDPRMultiple
});
module.exports = __toCommonJS(useDPRMultiple_exports);
var import_state = require("@tldraw/state");
var React = __toESM(require("react"));
var import_useContainer = require("./useContainer");
var import_useEditor = require("./useEditor");
function gcd(a, b) {
  return b === 0 ? a : gcd(b, a % b);
}
function nearestMultiple(float) {
  const decimal = float.toString().split(".")[1];
  if (!decimal)
    return 1;
  const denominator = Math.pow(10, decimal.length);
  const numerator = parseInt(decimal, 10);
  return denominator / gcd(numerator, denominator);
}
function useDPRMultiple() {
  const editor = (0, import_useEditor.useEditor)();
  const container = (0, import_useContainer.useContainer)();
  React.useEffect(() => {
    return (0, import_state.react)("useDPRMultiple", () => {
      const dpr = editor.instanceState.devicePixelRatio;
      container.style.setProperty("--tl-dpr-multiple", nearestMultiple(dpr).toString());
    });
  }, [editor, container]);
}
//# sourceMappingURL=useDPRMultiple.js.map
