import { EASINGS } from "./primitives/easings.mjs";
const MAX_SHAPES_PER_PAGE = 2e3;
const MAX_PAGES = 40;
const ANIMATION_SHORT_MS = 80;
const ANIMATION_MEDIUM_MS = 320;
const ZOOMS = [0.1, 0.25, 0.5, 1, 2, 4, 8];
const MIN_ZOOM = 0.1;
const MAX_ZOOM = 8;
const FOLLOW_CHASE_PROPORTION = 0.5;
const FOLLOW_CHASE_PAN_SNAP = 0.1;
const FOLLOW_CHASE_PAN_UNSNAP = 0.2;
const FOLLOW_CHASE_ZOOM_SNAP = 5e-3;
const FOLLOW_CHASE_ZOOM_UNSNAP = 0.05;
const DOUBLE_CLICK_DURATION = 450;
const MULTI_CLICK_DURATION = 200;
const COARSE_DRAG_DISTANCE = 6;
const DRAG_DISTANCE = 4;
const SVG_PADDING = 32;
const HASH_PATTERN_ZOOM_NAMES = {};
for (let zoom = 1; zoom <= Math.ceil(MAX_ZOOM); zoom++) {
  HASH_PATTERN_ZOOM_NAMES[zoom + "_dark"] = `hash_pattern_zoom_${zoom}_dark`;
  HASH_PATTERN_ZOOM_NAMES[zoom + "_light"] = `hash_pattern_zoom_${zoom}_light`;
}
const DEFAULT_ANIMATION_OPTIONS = {
  duration: 0,
  easing: EASINGS.easeInOutCubic
};
const CAMERA_SLIDE_FRICTION = 0.09;
const GRID_STEPS = [
  { min: -1, mid: 0.15, step: 64 },
  { min: 0.05, mid: 0.375, step: 16 },
  { min: 0.15, mid: 1, step: 4 },
  { min: 0.7, mid: 2.5, step: 1 }
];
const COLLABORATOR_INACTIVE_TIMEOUT = 6e4;
const COLLABORATOR_IDLE_TIMEOUT = 3e3;
const COLLABORATOR_CHECK_INTERVAL = 1200;
const INTERNAL_POINTER_IDS = {
  CAMERA_MOVE: -10
};
const CAMERA_MOVING_TIMEOUT = 64;
const CAMERA_MAX_RENDERING_INTERVAL = 620;
const HIT_TEST_MARGIN = 8;
export {
  ANIMATION_MEDIUM_MS,
  ANIMATION_SHORT_MS,
  CAMERA_MAX_RENDERING_INTERVAL,
  CAMERA_MOVING_TIMEOUT,
  CAMERA_SLIDE_FRICTION,
  COARSE_DRAG_DISTANCE,
  COLLABORATOR_CHECK_INTERVAL,
  COLLABORATOR_IDLE_TIMEOUT,
  COLLABORATOR_INACTIVE_TIMEOUT,
  DEFAULT_ANIMATION_OPTIONS,
  DOUBLE_CLICK_DURATION,
  DRAG_DISTANCE,
  FOLLOW_CHASE_PAN_SNAP,
  FOLLOW_CHASE_PAN_UNSNAP,
  FOLLOW_CHASE_PROPORTION,
  FOLLOW_CHASE_ZOOM_SNAP,
  FOLLOW_CHASE_ZOOM_UNSNAP,
  GRID_STEPS,
  HASH_PATTERN_ZOOM_NAMES,
  HIT_TEST_MARGIN,
  INTERNAL_POINTER_IDS,
  MAX_PAGES,
  MAX_SHAPES_PER_PAGE,
  MAX_ZOOM,
  MIN_ZOOM,
  MULTI_CLICK_DURATION,
  SVG_PADDING,
  ZOOMS
};
//# sourceMappingURL=constants.mjs.map
