import { useLayoutEffect } from "react";
import { useContainer } from "./useContainer.mjs";
import { useEditor } from "./useEditor.mjs";
function useFocusEvents(autoFocus) {
  const editor = useEditor();
  const container = useContainer();
  useLayoutEffect(() => {
    if (autoFocus) {
      if (!editor.instanceState.isFocused) {
        editor.updateInstanceState({ isFocused: true });
      }
      editor.getContainer().focus();
    } else {
      if (editor.instanceState.isFocused) {
        editor.updateInstanceState({ isFocused: false });
      }
    }
  }, [editor, container, autoFocus]);
}
export {
  useFocusEvents
};
//# sourceMappingURL=useFocusEvents.mjs.map
