import { Edge2d } from "./Edge2d.mjs";
import { Geometry2d } from "./Geometry2d.mjs";
class Polyline2d extends Geometry2d {
  points;
  constructor(config) {
    super({ isClosed: false, isFilled: false, ...config });
    const { points } = config;
    this.points = points;
  }
  _segments;
  get segments() {
    if (!this._segments) {
      this._segments = [];
      const { vertices } = this;
      for (let i = 0, n = vertices.length - 1; i < n; i++) {
        const start = vertices[i];
        const end = vertices[i + 1];
        this._segments.push(new Edge2d({ start, end }));
      }
      if (this.isClosed) {
        this._segments.push(new Edge2d({ start: vertices[vertices.length - 1], end: vertices[0] }));
      }
    }
    return this._segments;
  }
  _length;
  get length() {
    if (!this._length) {
      this._length = this.segments.reduce((acc, segment) => acc + segment.length, 0);
    }
    return this._length;
  }
  getVertices() {
    return this.points;
  }
  nearestPoint(A) {
    const { segments } = this;
    let nearest = this.points[0];
    let dist = Infinity;
    let p;
    let d;
    for (let i = 0; i < segments.length; i++) {
      p = segments[i].nearestPoint(A);
      d = p.dist(A);
      if (d < dist) {
        nearest = p;
        dist = d;
      }
    }
    return nearest;
  }
  hitTestLineSegment(A, B, zoom) {
    return this.segments.some((edge) => edge.hitTestLineSegment(A, B, zoom));
  }
}
export {
  Polyline2d
};
//# sourceMappingURL=Polyline2d.mjs.map
