import { createRecordType, defineMigrations } from "@tldraw/store";
import { T } from "@tldraw/validate";
import { idValidator } from "../misc/id-validator.mjs";
import { shapeIdValidator } from "../shapes/TLBaseShape.mjs";
import { CameraRecordType } from "./TLCamera.mjs";
import { TLINSTANCE_ID } from "./TLInstance.mjs";
import { pageIdValidator } from "./TLPage.mjs";
const instancePageStateValidator = T.model(
  "instance_page_state",
  T.object({
    typeName: T.literal("instance_page_state"),
    id: idValidator("instance_page_state"),
    pageId: pageIdValidator,
    selectedShapeIds: T.arrayOf(shapeIdValidator),
    hintingShapeIds: T.arrayOf(shapeIdValidator),
    erasingShapeIds: T.arrayOf(shapeIdValidator),
    hoveredShapeId: shapeIdValidator.nullable(),
    editingShapeId: shapeIdValidator.nullable(),
    croppingShapeId: shapeIdValidator.nullable(),
    focusedGroupId: shapeIdValidator.nullable(),
    meta: T.jsonValue
  })
);
const instancePageStateVersions = {
  AddCroppingId: 1,
  RemoveInstanceIdAndCameraId: 2,
  AddMeta: 3,
  RenameProperties: 4,
  RenamePropertiesAgain: 5
};
const instancePageStateMigrations = defineMigrations({
  currentVersion: instancePageStateVersions.RenamePropertiesAgain,
  migrators: {
    [instancePageStateVersions.AddCroppingId]: {
      up(instance) {
        return { ...instance, croppingShapeId: null };
      },
      down({ croppingShapeId: _croppingShapeId, ...instance }) {
        return instance;
      }
    },
    [instancePageStateVersions.RemoveInstanceIdAndCameraId]: {
      up({ instanceId: _, cameraId: __, ...instance }) {
        return instance;
      },
      down(instance) {
        return {
          ...instance,
          instanceId: TLINSTANCE_ID,
          cameraId: CameraRecordType.createId("void")
        };
      }
    },
    [instancePageStateVersions.AddMeta]: {
      up: (record) => {
        return {
          ...record,
          meta: {}
        };
      },
      down: ({ meta: _, ...record }) => {
        return {
          ...record
        };
      }
    },
    [instancePageStateVersions.RenameProperties]: {
      // this migration is cursed: it was written wrong and doesn't do anything.
      // rather than replace it, I've added another migration below that fixes it.
      up: (record) => {
        const {
          selectedShapeIds,
          hintingShapeIds,
          erasingShapeIds,
          hoveredShapeId,
          editingShapeId,
          croppingShapeId,
          focusedGroupId,
          ...rest
        } = record;
        return {
          selectedShapeIds,
          hintingShapeIds,
          erasingShapeIds,
          hoveredShapeId,
          editingShapeId,
          croppingShapeId,
          focusedGroupId,
          ...rest
        };
      },
      down: (record) => {
        const {
          selectedShapeIds,
          hintingShapeIds,
          erasingShapeIds,
          hoveredShapeId,
          editingShapeId,
          croppingShapeId,
          focusedGroupId,
          ...rest
        } = record;
        return {
          selectedShapeIds,
          hintingShapeIds,
          erasingShapeIds,
          hoveredShapeId,
          editingShapeId,
          croppingShapeId,
          focusedGroupId,
          ...rest
        };
      }
    },
    [instancePageStateVersions.RenamePropertiesAgain]: {
      up: (record) => {
        const {
          selectedIds,
          hintingIds,
          erasingIds,
          hoveredId,
          editingId,
          croppingId,
          focusLayerId,
          ...rest
        } = record;
        return {
          ...rest,
          selectedShapeIds: selectedIds,
          hintingShapeIds: hintingIds,
          erasingShapeIds: erasingIds,
          hoveredShapeId: hoveredId,
          editingShapeId: editingId,
          croppingShapeId: croppingId,
          focusedGroupId: focusLayerId
        };
      },
      down: (record) => {
        const {
          selectedShapeIds,
          hintingShapeIds,
          erasingShapeIds,
          hoveredShapeId,
          editingShapeId,
          croppingShapeId,
          focusedGroupId,
          ...rest
        } = record;
        return {
          ...rest,
          selectedIds: selectedShapeIds,
          hintingIds: hintingShapeIds,
          erasingIds: erasingShapeIds,
          hoveredId: hoveredShapeId,
          editingId: editingShapeId,
          croppingId: croppingShapeId,
          focusLayerId: focusedGroupId
        };
      }
    }
  }
});
const InstancePageStateRecordType = createRecordType(
  "instance_page_state",
  {
    migrations: instancePageStateMigrations,
    validator: instancePageStateValidator,
    scope: "session"
  }
).withDefaultProperties(
  () => ({
    editingShapeId: null,
    croppingShapeId: null,
    selectedShapeIds: [],
    hoveredShapeId: null,
    erasingShapeIds: [],
    hintingShapeIds: [],
    focusedGroupId: null,
    meta: {}
  })
);
export {
  InstancePageStateRecordType,
  instancePageStateMigrations,
  instancePageStateValidator,
  instancePageStateVersions
};
//# sourceMappingURL=TLPageState.mjs.map
