"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var straight_arrow_exports = {};
__export(straight_arrow_exports, {
  getSolidStraightArrowPath: () => getSolidStraightArrowPath,
  getStraightArrowBoundingBox: () => getStraightArrowBoundingBox,
  getStraightArrowHandlePath: () => getStraightArrowHandlePath,
  getStraightArrowInfo: () => getStraightArrowInfo
});
module.exports = __toCommonJS(straight_arrow_exports);
var import_Box2d = require("../../../../primitives/Box2d");
var import_Matrix2d = require("../../../../primitives/Matrix2d");
var import_Vec2d = require("../../../../primitives/Vec2d");
var import_intersect = require("../../../../primitives/intersect");
var import_shared = require("./shared");
function getStraightArrowInfo(editor, shape) {
  const { start, end, arrowheadStart, arrowheadEnd } = shape.props;
  const terminalsInArrowSpace = (0, import_shared.getArrowTerminalsInArrowSpace)(editor, shape);
  const a = terminalsInArrowSpace.start.clone();
  const b = terminalsInArrowSpace.end.clone();
  const c = import_Vec2d.Vec2d.Med(a, b);
  const uAB = import_Vec2d.Vec2d.Sub(b, a).uni();
  const startShapeInfo = (0, import_shared.getBoundShapeInfoForTerminal)(editor, start);
  const endShapeInfo = (0, import_shared.getBoundShapeInfoForTerminal)(editor, end);
  const arrowPageTransform = editor.getShapePageTransform(shape);
  updateArrowheadPointWithBoundShape(
    b,
    // <-- will be mutated
    terminalsInArrowSpace.start,
    arrowPageTransform,
    endShapeInfo
  );
  updateArrowheadPointWithBoundShape(
    a,
    // <-- will be mutated
    terminalsInArrowSpace.end,
    arrowPageTransform,
    startShapeInfo
  );
  let offsetA = 0;
  let offsetB = 0;
  const isSelfIntersection = startShapeInfo && endShapeInfo && startShapeInfo.shape === endShapeInfo.shape;
  if (startShapeInfo && endShapeInfo && !isSelfIntersection && !startShapeInfo.isExact && !endShapeInfo.isExact) {
    if (endShapeInfo.didIntersect && !startShapeInfo.didIntersect) {
      if (startShapeInfo.isClosed) {
        a.setTo(b.clone().add(uAB.clone().mul(import_shared.MIN_ARROW_LENGTH)));
      }
    } else if (!endShapeInfo.didIntersect) {
      if (endShapeInfo.isClosed) {
        b.setTo(a.clone().sub(uAB.clone().mul(import_shared.MIN_ARROW_LENGTH)));
      }
    }
  }
  const u = import_Vec2d.Vec2d.Sub(b, a).uni();
  const didFlip = !import_Vec2d.Vec2d.Equals(u, uAB);
  if (!isSelfIntersection) {
    if (startShapeInfo && arrowheadStart !== "none" && !startShapeInfo.isExact) {
      offsetA = import_shared.BOUND_ARROW_OFFSET + import_shared.STROKE_SIZES[shape.props.size] / 2 + ("size" in startShapeInfo.shape.props ? import_shared.STROKE_SIZES[startShapeInfo.shape.props.size] / 2 : 0);
    }
    if (endShapeInfo && arrowheadEnd !== "none" && !endShapeInfo.isExact) {
      offsetB = import_shared.BOUND_ARROW_OFFSET + import_shared.STROKE_SIZES[shape.props.size] / 2 + ("size" in endShapeInfo.shape.props ? import_shared.STROKE_SIZES[endShapeInfo.shape.props.size] / 2 : 0);
    }
  }
  const tA = a.clone().add(u.clone().mul(offsetA * (didFlip ? -1 : 1)));
  const tB = b.clone().sub(u.clone().mul(offsetB * (didFlip ? -1 : 1)));
  const distAB = import_Vec2d.Vec2d.Dist(tA, tB);
  if (distAB < import_shared.MIN_ARROW_LENGTH) {
    if (offsetA !== 0 && offsetB !== 0) {
      offsetA *= -1.5;
      offsetB *= -1.5;
    } else if (offsetA !== 0) {
      offsetA *= -2;
    } else if (offsetB !== 0) {
      offsetB *= -2;
    } else {
      if (distAB < 10) {
        if (startShapeInfo)
          offsetA = -(10 - distAB);
        else if (endShapeInfo)
          offsetB = -(10 - distAB);
      }
    }
  }
  a.add(u.clone().mul(offsetA * (didFlip ? -1 : 1)));
  b.sub(u.clone().mul(offsetB * (didFlip ? -1 : 1)));
  if (didFlip) {
    if (startShapeInfo && endShapeInfo) {
      b.setTo(import_Vec2d.Vec2d.Add(a, u.clone().mul(-import_shared.MIN_ARROW_LENGTH)));
    }
    c.setTo(import_Vec2d.Vec2d.Med(terminalsInArrowSpace.start, terminalsInArrowSpace.end));
  } else {
    c.setTo(import_Vec2d.Vec2d.Med(a, b));
  }
  const length = import_Vec2d.Vec2d.Dist(a, b);
  return {
    isStraight: true,
    start: {
      handle: terminalsInArrowSpace.start,
      point: a,
      arrowhead: shape.props.arrowheadStart
    },
    end: {
      handle: terminalsInArrowSpace.end,
      point: b,
      arrowhead: shape.props.arrowheadEnd
    },
    middle: c,
    isValid: length > 0,
    length
  };
}
function updateArrowheadPointWithBoundShape(point, opposite, arrowPageTransform, targetShapeInfo) {
  if (targetShapeInfo === void 0) {
    return;
  }
  if (targetShapeInfo.isExact) {
    return;
  }
  const pageFrom = import_Matrix2d.Matrix2d.applyToPoint(arrowPageTransform, opposite);
  const pageTo = import_Matrix2d.Matrix2d.applyToPoint(arrowPageTransform, point);
  const targetFrom = import_Matrix2d.Matrix2d.applyToPoint(import_Matrix2d.Matrix2d.Inverse(targetShapeInfo.transform), pageFrom);
  const targetTo = import_Matrix2d.Matrix2d.applyToPoint(import_Matrix2d.Matrix2d.Inverse(targetShapeInfo.transform), pageTo);
  const isClosed = targetShapeInfo.isClosed;
  const fn = isClosed ? import_intersect.intersectLineSegmentPolygon : import_intersect.intersectLineSegmentPolyline;
  const intersection = fn(targetFrom, targetTo, targetShapeInfo.outline);
  let targetInt;
  if (intersection !== null) {
    targetInt = intersection.sort((p1, p2) => import_Vec2d.Vec2d.Dist(p1, targetFrom) - import_Vec2d.Vec2d.Dist(p2, targetFrom))[0] ?? (isClosed ? void 0 : targetTo);
  }
  if (targetInt === void 0) {
    return;
  }
  const pageInt = import_Matrix2d.Matrix2d.applyToPoint(targetShapeInfo.transform, targetInt);
  const arrowInt = import_Matrix2d.Matrix2d.applyToPoint(import_Matrix2d.Matrix2d.Inverse(arrowPageTransform), pageInt);
  point.setTo(arrowInt);
  targetShapeInfo.didIntersect = true;
}
function getStraightArrowHandlePath(info) {
  return getArrowPath(info.start.handle, info.end.handle);
}
function getSolidStraightArrowPath(info) {
  return getArrowPath(info.start.point, info.end.point);
}
function getArrowPath(start, end) {
  return `M${start.x},${start.y}L${end.x},${end.y}`;
}
function getStraightArrowBoundingBox(start, end) {
  return new import_Box2d.Box2d(
    Math.min(start.x, end.x),
    Math.min(start.y, end.y),
    Math.abs(start.x - end.x),
    Math.abs(start.y - end.y)
  );
}
//# sourceMappingURL=straight-arrow.js.map
