import { jsx } from "react/jsx-runtime";
import { track } from "@tldraw/state";
import classNames from "classnames";
import { useLayoutEffect, useRef } from "react";
import { useEditor } from "../hooks/useEditor.mjs";
const PositionedOnCanvas = track(function PositionedOnCanvas2({
  x: offsetX = 0,
  y: offsetY = 0,
  rotation = 0,
  ...rest
}) {
  const editor = useEditor();
  const rContainer = useRef(null);
  useLayoutEffect(() => {
    const { x, y, z } = editor.camera;
    const elm = rContainer.current;
    if (!elm)
      return;
    if (x === void 0)
      return;
    elm.style.transform = `translate(${x}px, ${y}px) scale(${z}) rotate(${rotation}rad) translate(${offsetX}px, ${offsetY}px)`;
  }, [editor.camera, offsetX, offsetY, rotation]);
  return /* @__PURE__ */ jsx("div", { ref: rContainer, ...rest, className: classNames("tl-positioned", rest.className) });
});
export {
  PositionedOnCanvas
};
//# sourceMappingURL=PositionedOnCanvas.mjs.map
