var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp(target, key, result);
  return result;
};
import { computed } from "@tldraw/state";
import {
  defaultUserPreferences,
  userPrefersDarkUI
} from "../../config/TLUserPreferences.mjs";
class UserPreferencesManager {
  constructor(user, inferDarkMode) {
    this.user = user;
    this.inferDarkMode = inferDarkMode;
  }
  updateUserPreferences = (userPreferences) => {
    this.user.setUserPreferences({
      ...this.user.userPreferences.value,
      ...userPreferences
    });
  };
  get userPreferences() {
    return {
      id: this.id,
      name: this.name,
      locale: this.locale,
      color: this.color,
      isDarkMode: this.isDarkMode,
      animationSpeed: this.animationSpeed,
      isSnapMode: this.isSnapMode
    };
  }
  get isDarkMode() {
    return this.user.userPreferences.value.isDarkMode ?? (this.inferDarkMode ? userPrefersDarkUI() : false);
  }
  get animationSpeed() {
    return this.user.userPreferences.value.animationSpeed ?? defaultUserPreferences.animationSpeed;
  }
  get id() {
    return this.user.userPreferences.value.id;
  }
  get name() {
    return this.user.userPreferences.value.name ?? defaultUserPreferences.name;
  }
  get locale() {
    return this.user.userPreferences.value.locale ?? defaultUserPreferences.locale;
  }
  get color() {
    return this.user.userPreferences.value.color ?? defaultUserPreferences.color;
  }
  get isSnapMode() {
    return this.user.userPreferences.value.isSnapMode ?? defaultUserPreferences.isSnapMode;
  }
}
__decorateClass([
  computed
], UserPreferencesManager.prototype, "userPreferences", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "isDarkMode", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "animationSpeed", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "id", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "name", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "locale", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "color", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "isSnapMode", 1);
export {
  UserPreferencesManager
};
//# sourceMappingURL=UserPreferencesManager.mjs.map
