import { react } from "@tldraw/state";
import * as React from "react";
import { useContainer } from "./useContainer.mjs";
import { useEditor } from "./useEditor.mjs";
function gcd(a, b) {
  return b === 0 ? a : gcd(b, a % b);
}
function nearestMultiple(float) {
  const decimal = float.toString().split(".")[1];
  if (!decimal)
    return 1;
  const denominator = Math.pow(10, decimal.length);
  const numerator = parseInt(decimal, 10);
  return denominator / gcd(numerator, denominator);
}
function useDPRMultiple() {
  const editor = useEditor();
  const container = useContainer();
  React.useEffect(() => {
    return react("useDPRMultiple", () => {
      const dpr = editor.instanceState.devicePixelRatio;
      container.style.setProperty("--tl-dpr-multiple", nearestMultiple(dpr).toString());
    });
  }, [editor, container]);
}
export {
  nearestMultiple,
  useDPRMultiple
};
//# sourceMappingURL=useDPRMultiple.mjs.map
