import { jsx } from "react/jsx-runtime";
import { createContext, useContext, useMemo } from "react";
import { ShapeIndicator } from "../components/ShapeIndicator.mjs";
import {
  DefaultBackground
} from "../components/default-components/DefaultBackground.mjs";
import { DefaultBrush } from "../components/default-components/DefaultBrush.mjs";
import {
  DefaultCollaboratorHint
} from "../components/default-components/DefaultCollaboratorHint.mjs";
import { DefaultCursor } from "../components/default-components/DefaultCursor.mjs";
import {
  DefaultErrorFallback
} from "../components/default-components/DefaultErrorFallback.mjs";
import { DefaultGrid } from "../components/default-components/DefaultGrid.mjs";
import { DefaultHandle } from "../components/default-components/DefaultHandle.mjs";
import { DefaultHandles } from "../components/default-components/DefaultHandles.mjs";
import {
  DefaultHoveredShapeIndicator
} from "../components/default-components/DefaultHoveredShapeIndicator.mjs";
import {
  DefaultScribble
} from "../components/default-components/DefaultScribble.mjs";
import {
  DefaultSelectionBackground
} from "../components/default-components/DefaultSelectionBackground.mjs";
import {
  DefaultSelectionForeground
} from "../components/default-components/DefaultSelectionForeground.mjs";
import {
  DefaultShapeErrorFallback
} from "../components/default-components/DefaultShapeErrorFallback.mjs";
import {
  DefaultShapeIndicatorErrorFallback
} from "../components/default-components/DefaultShapeIndicatorErrorFallback.mjs";
import {
  DefaultSnapLine
} from "../components/default-components/DefaultSnapLine.mjs";
import { DefaultSpinner } from "../components/default-components/DefaultSpinner.mjs";
import { DefaultSvgDefs } from "../components/default-components/DefaultSvgDefs.mjs";
const EditorComponentsContext = createContext({});
function EditorComponentsProvider({ overrides, children }) {
  return /* @__PURE__ */ jsx(
    EditorComponentsContext.Provider,
    {
      value: useMemo(
        () => ({
          Background: DefaultBackground,
          SvgDefs: DefaultSvgDefs,
          Brush: DefaultBrush,
          ZoomBrush: DefaultBrush,
          CollaboratorBrush: DefaultBrush,
          Cursor: DefaultCursor,
          CollaboratorCursor: DefaultCursor,
          CollaboratorHint: DefaultCollaboratorHint,
          CollaboratorShapeIndicator: ShapeIndicator,
          Grid: DefaultGrid,
          Scribble: DefaultScribble,
          SnapLine: DefaultSnapLine,
          Handles: DefaultHandles,
          Handle: DefaultHandle,
          CollaboratorScribble: DefaultScribble,
          ErrorFallback: DefaultErrorFallback,
          ShapeErrorFallback: DefaultShapeErrorFallback,
          ShapeIndicatorErrorFallback: DefaultShapeIndicatorErrorFallback,
          Spinner: DefaultSpinner,
          SelectionBackground: DefaultSelectionBackground,
          SelectionForeground: DefaultSelectionForeground,
          HoveredShapeIndicator: DefaultHoveredShapeIndicator,
          ...overrides
        }),
        [overrides]
      ),
      children
    }
  );
}
function useEditorComponents() {
  return useContext(EditorComponentsContext);
}
export {
  EditorComponentsProvider,
  useEditorComponents
};
//# sourceMappingURL=useEditorComponents.mjs.map
