import throttle from "lodash.throttle";
import { useLayoutEffect } from "react";
import { useEditor } from "./useEditor.mjs";
function useScreenBounds() {
  const editor = useEditor();
  useLayoutEffect(() => {
    const updateBounds = throttle(
      () => {
        editor.updateViewportScreenBounds();
      },
      200,
      {
        trailing: true
      }
    );
    editor.updateViewportScreenBounds();
    const interval = setInterval(updateBounds, 1e3);
    window.addEventListener("resize", updateBounds);
    window.addEventListener("scroll", updateBounds);
    return () => {
      clearInterval(interval);
      window.removeEventListener("resize", updateBounds);
      window.removeEventListener("scroll", updateBounds);
    };
  }, [editor]);
}
export {
  useScreenBounds
};
//# sourceMappingURL=useScreenBounds.mjs.map
