"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var KeyboardShortcutsDialog_exports = {};
__export(KeyboardShortcutsDialog_exports, {
  KeyboardShortcutsDialog: () => KeyboardShortcutsDialog
});
module.exports = __toCommonJS(KeyboardShortcutsDialog_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_useKeyboardShortcutsSchema = require("../hooks/useKeyboardShortcutsSchema");
var import_useReadonly = require("../hooks/useReadonly");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var Dialog = __toESM(require("./primitives/Dialog"));
var import_Kbd = require("./primitives/Kbd");
const KeyboardShortcutsDialog = () => {
  const msg = (0, import_useTranslation.useTranslation)();
  const isReadonly = (0, import_useReadonly.useReadonly)();
  const shortcutsItems = (0, import_useKeyboardShortcutsSchema.useKeyboardShortcutsSchema)();
  function getKeyboardShortcutItem(item) {
    if (isReadonly && !item.readonlyOk)
      return null;
    switch (item.type) {
      case "group": {
        return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-shortcuts-dialog__group", children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)("h2", { className: "tlui-shortcuts-dialog__group__title", children: msg(item.id) }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-shortcuts-dialog__group__content", children: item.children.filter((item2) => item2.type === "item" && item2.actionItem.kbd).map(getKeyboardShortcutItem) })
        ] }, item.id);
      }
      case "item": {
        const { id, label, shortcutsLabel, kbd } = item.actionItem;
        return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-shortcuts-dialog__key-pair", children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-shortcuts-dialog__key-pair__key", children: msg(shortcutsLabel ?? label) }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-shortcuts-dialog__key-pair__value", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Kbd.Kbd, { children: kbd }) })
        ] }, id);
      }
    }
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Dialog.Header, { className: "tlui-shortcuts-dialog__header", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.Title, { children: msg("shortcuts-dialog.title") }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.CloseButton, {})
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.Body, { className: "tlui-shortcuts-dialog__body", children: shortcutsItems.map(getKeyboardShortcutItem) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-dialog__scrim" })
  ] });
};
//# sourceMappingURL=KeyboardShortcutsDialog.js.map
