"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useRevelantStyles_exports = {};
__export(useRevelantStyles_exports, {
  useRelevantStyles: () => useRelevantStyles
});
module.exports = __toCommonJS(useRevelantStyles_exports);
var import_editor = require("@tldraw/editor");
const selectToolStyles = [import_editor.DefaultColorStyle, import_editor.DefaultDashStyle, import_editor.DefaultFillStyle, import_editor.DefaultSizeStyle];
function useRelevantStyles() {
  const editor = (0, import_editor.useEditor)();
  return (0, import_editor.useValue)(
    "getRelevantStyles",
    () => {
      const styles = new import_editor.SharedStyleMap(editor.sharedStyles);
      const hasShape = editor.selectedShapeIds.length > 0 || !!editor.root.current.value?.shapeType;
      if (styles.size === 0 && editor.isIn("select") && editor.selectedShapeIds.length === 0) {
        for (const style of selectToolStyles) {
          styles.applyValue(style, editor.getStyleForNextShape(style));
        }
      }
      if (styles.size === 0 && !hasShape)
        return null;
      return { styles, opacity: editor.sharedOpacity };
    },
    [editor]
  );
}
//# sourceMappingURL=useRevelantStyles.js.map
