import { jsx } from "react/jsx-runtime";
import { useDefaultUiAssetUrlsWithOverrides } from "./assetUrls.mjs";
import { ActionsProvider } from "./hooks/useActions.mjs";
import { ActionsMenuSchemaProvider } from "./hooks/useActionsMenuSchema.mjs";
import { AssetUrlsProvider } from "./hooks/useAssetUrls.mjs";
import { BreakPointProvider } from "./hooks/useBreakpoint.mjs";
import { TLUiContextMenuSchemaProvider } from "./hooks/useContextMenuSchema.mjs";
import { DialogsProvider } from "./hooks/useDialogsProvider.mjs";
import { UiEventsProvider } from "./hooks/useEventsProvider.mjs";
import { HelpMenuSchemaProvider } from "./hooks/useHelpMenuSchema.mjs";
import { KeyboardShortcutsSchemaProvider } from "./hooks/useKeyboardShortcutsSchema.mjs";
import { TLUiMenuSchemaProvider } from "./hooks/useMenuSchema.mjs";
import { ToastsProvider } from "./hooks/useToastsProvider.mjs";
import { ToolbarSchemaProvider } from "./hooks/useToolbarSchema.mjs";
import { ToolsProvider } from "./hooks/useTools.mjs";
import { TranslationProvider } from "./hooks/useTranslation/useTranslation.mjs";
import { useMergedOverrides, useMergedTranslationOverrides } from "./overrides.mjs";
function TldrawUiContextProvider({
  overrides,
  assetUrls,
  onUiEvent,
  children
}) {
  return /* @__PURE__ */ jsx(AssetUrlsProvider, { assetUrls: useDefaultUiAssetUrlsWithOverrides(assetUrls), children: /* @__PURE__ */ jsx(TranslationProvider, { overrides: useMergedTranslationOverrides(overrides), children: /* @__PURE__ */ jsx(UiEventsProvider, { onEvent: onUiEvent, children: /* @__PURE__ */ jsx(ToastsProvider, { children: /* @__PURE__ */ jsx(DialogsProvider, { children: /* @__PURE__ */ jsx(BreakPointProvider, { children: /* @__PURE__ */ jsx(InternalProviders, { overrides, children }) }) }) }) }) }) });
}
function InternalProviders({
  overrides,
  children
}) {
  const mergedOverrides = useMergedOverrides(overrides);
  return /* @__PURE__ */ jsx(ActionsProvider, { overrides: mergedOverrides.actions, children: /* @__PURE__ */ jsx(ToolsProvider, { overrides: mergedOverrides.tools, children: /* @__PURE__ */ jsx(ToolbarSchemaProvider, { overrides: mergedOverrides.toolbar, children: /* @__PURE__ */ jsx(ActionsMenuSchemaProvider, { overrides: mergedOverrides.actionsMenu, children: /* @__PURE__ */ jsx(KeyboardShortcutsSchemaProvider, { overrides: mergedOverrides.keyboardShortcutsMenu, children: /* @__PURE__ */ jsx(TLUiContextMenuSchemaProvider, { overrides: mergedOverrides.contextMenu, children: /* @__PURE__ */ jsx(HelpMenuSchemaProvider, { overrides: mergedOverrides.helpMenu, children: /* @__PURE__ */ jsx(TLUiMenuSchemaProvider, { overrides: mergedOverrides.menu, children }) }) }) }) }) }) }) });
}
export {
  TldrawUiContextProvider
};
//# sourceMappingURL=TldrawUiContextProvider.mjs.map
