import { jsx } from "react/jsx-runtime";
import { memo } from "react";
import { useActions } from "../hooks/useActions.mjs";
import { useCanUndo } from "../hooks/useCanUndo.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { Button } from "./primitives/Button.mjs";
import { kbdStr } from "./primitives/shared.mjs";
const UndoButton = memo(function UndoButton2() {
  const msg = useTranslation();
  const canUndo = useCanUndo();
  const actions = useActions();
  const undo = actions["undo"];
  return /* @__PURE__ */ jsx(
    Button,
    {
      "data-testid": "main.undo",
      icon: undo.icon,
      title: `${msg(undo.label)} ${kbdStr(undo.kbd)}`,
      disabled: !canUndo,
      onClick: () => undo.onSelect("quick-actions"),
      smallIcon: true
    }
  );
});
export {
  UndoButton
};
//# sourceMappingURL=UndoButton.mjs.map
