import { StateMachine } from "./StateMachine.js";
import { assign } from "./actions/assign.js";
import { cancel } from "./actions/cancel.js";
import { emit } from "./actions/emit.js";
import { enqueueActions } from "./actions/enqueueActions.js";
import { log } from "./actions/log.js";
import { raise } from "./actions/raise.js";
import { sendTo } from "./actions/send.js";
import { spawnChild } from "./actions/spawnChild.js";
import { stopChild } from "./actions/stopChild.js";
import { GuardPredicate } from "./guards.js";
import { ActionFunction, AnyActorRef, AnyEventObject, Cast, DelayConfig, EventObject, Invert, IsNever, MachineConfig, MachineContext, MetaObject, NonReducibleUnknown, ParameterizedObject, SetupTypes, StateNodeConfig, ToChildren, ToStateValue, UnknownActorLogic, Values } from "./types.js";
type ToParameterizedObject<TParameterizedMap extends Record<string, ParameterizedObject['params'] | undefined>> = IsNever<TParameterizedMap> extends true ? never : Values<{
    [K in keyof TParameterizedMap & string]: {
        type: K;
        params: TParameterizedMap[K];
    };
}>;
type ToProvidedActor<TChildrenMap extends Record<string, string>, TActors extends Record<string, UnknownActorLogic>> = IsNever<TActors> extends true ? never : Values<{
    [K in keyof TActors & string]: {
        src: K;
        logic: TActors[K];
        id: IsNever<TChildrenMap> extends true ? string | undefined : K extends keyof Invert<TChildrenMap> ? Invert<TChildrenMap>[K] & string : string | undefined;
    };
}>;
type RequiredSetupKeys<TChildrenMap> = IsNever<keyof TChildrenMap> extends true ? never : 'actors';
export declare function setup<TContext extends MachineContext, TEvent extends AnyEventObject, // TODO: consider using a stricter `EventObject` here
TActors extends Record<string, UnknownActorLogic> = {}, TChildrenMap extends Record<string, string> = {}, TActions extends Record<string, ParameterizedObject['params'] | undefined> = {}, TGuards extends Record<string, ParameterizedObject['params'] | undefined> = {}, TDelay extends string = never, TTag extends string = string, TInput = NonReducibleUnknown, TOutput extends NonReducibleUnknown = NonReducibleUnknown, TEmitted extends EventObject = EventObject, TMeta extends MetaObject = MetaObject>({ schemas, actors, actions, guards, delays }: {
    schemas?: unknown;
    types?: SetupTypes<TContext, TEvent, TChildrenMap, TTag, TInput, TOutput, TEmitted, TMeta>;
    actors?: {
        [K in keyof TActors | Values<TChildrenMap>]: K extends keyof TActors ? TActors[K] : never;
    };
    actions?: {
        [K in keyof TActions]: ActionFunction<TContext, TEvent, TEvent, TActions[K], ToProvidedActor<TChildrenMap, TActors>, ToParameterizedObject<TActions>, ToParameterizedObject<TGuards>, TDelay, TEmitted>;
    };
    guards?: {
        [K in keyof TGuards]: GuardPredicate<TContext, TEvent, TGuards[K], ToParameterizedObject<TGuards>>;
    };
    delays?: {
        [K in TDelay]: DelayConfig<TContext, TEvent, ToParameterizedObject<TActions>['params'], TEvent>;
    };
} & {
    [K in RequiredSetupKeys<TChildrenMap>]: unknown;
}): {
    /**
     * Creates a state config that is strongly typed. This state config can be
     * used to create a machine.
     *
     * @example
     *
     * ```ts
     * const lightMachineSetup = setup({
     *   // ...
     * });
     *
     * const green = lightMachineSetup.createStateConfig({
     *   on: {
     *     timer: {
     *       actions: 'doSomething'
     *     }
     *   }
     * });
     *
     * const machine = lightMachineSetup.createMachine({
     *   initial: 'green',
     *   states: {
     *     green,
     *     yellow,
     *     red
     *   }
     * });
     * ```
     */
    createStateConfig: <TStateConfig extends StateNodeConfig<TContext, TEvent, ToProvidedActor<TChildrenMap, TActors>, ToParameterizedObject<TActions>, ToParameterizedObject<TGuards>, TDelay, TTag, unknown, TEmitted, TMeta>>(config: TStateConfig) => TStateConfig;
    /**
     * Creates a type-safe action.
     *
     * @example
     *
     * ```ts
     * const machineSetup = setup({
     *   // ...
     * });
     *
     * const action = machineSetup.createAction(({ context, event }) => {
     *   console.log(context.count, event.value);
     * });
     *
     * const incrementAction = machineSetup.createAction(
     *   assign({ count: ({ context }) => context.count + 1 })
     * );
     *
     * const machine = machineSetup.createMachine({
     *   context: { count: 0 },
     *   entry: [action, incrementAction]
     * });
     * ```
     */
    createAction: (action: ActionFunction<TContext, TEvent, TEvent, unknown, ToProvidedActor<TChildrenMap, TActors>, ToParameterizedObject<TActions>, ToParameterizedObject<TGuards>, TDelay, TEmitted>) => typeof action;
    createMachine: <const TConfig extends MachineConfig<TContext, TEvent, ToProvidedActor<TChildrenMap, TActors>, ToParameterizedObject<TActions>, ToParameterizedObject<TGuards>, TDelay, TTag, TInput, TOutput, TEmitted, TMeta>>(config: TConfig) => StateMachine<TContext, TEvent, Cast<ToChildren<ToProvidedActor<TChildrenMap, TActors>>, Record<string, AnyActorRef | undefined>>, ToProvidedActor<TChildrenMap, TActors>, ToParameterizedObject<TActions>, ToParameterizedObject<TGuards>, TDelay, ToStateValue<TConfig>, TTag, TInput, TOutput, TEmitted, TMeta, TConfig>;
    assign: typeof assign<TContext, TEvent, undefined, TEvent, ToProvidedActor<TChildrenMap, TActors>>;
    sendTo: <TTargetActor extends AnyActorRef>(...args: Parameters<typeof sendTo<TContext, TEvent, undefined, TTargetActor, TEvent, TDelay, TDelay>>) => ReturnType<typeof sendTo<TContext, TEvent, undefined, TTargetActor, TEvent, TDelay, TDelay>>;
    raise: typeof raise<TContext, TEvent, TEvent, undefined, TDelay, TDelay>;
    log: typeof log<TContext, TEvent, undefined, TEvent>;
    cancel: typeof cancel<TContext, TEvent, undefined, TEvent>;
    stopChild: typeof stopChild<TContext, TEvent, undefined, TEvent>;
    enqueueActions: typeof enqueueActions<TContext, TEvent, undefined, TEvent, ToProvidedActor<TChildrenMap, TActors>, ToParameterizedObject<TActions>, ToParameterizedObject<TGuards>, TDelay, TEmitted>;
    emit: typeof emit<TContext, TEvent, undefined, TEvent, TEmitted>;
    spawnChild: typeof spawnChild<TContext, TEvent, undefined, TEvent, ToProvidedActor<TChildrenMap, TActors>>;
};
export {};
