import { AnyDocumentId } from '@automerge/automerge-repo/slim';
import { ChangeFn, ChangeOptions, Doc } from '@automerge/automerge/slim/next';

/** A hook which returns a document identified by a URL and a function to change the document.
 *
 * @returns a tuple of the document and a function to change the document.
 * The document will be `undefined` if the document is not available in storage or from any peers
 *
 * @remarks
 * This requires a {@link RepoContext} to be provided by a parent component.
 * */
export declare function useDocument<T>(id?: AnyDocumentId): [
    Doc<T> | undefined,
    (changeFn: ChangeFn<T>, options?: ChangeOptions<T> | undefined) => void
];
//# sourceMappingURL=useDocument.d.ts.map