"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var HelpMenu_exports = {};
__export(HelpMenu_exports, {
  HelpMenu: () => HelpMenu
});
module.exports = __toCommonJS(HelpMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_react_dropdown_menu = require("@radix-ui/react-dropdown-menu");
var import_editor = require("@tldraw/editor");
var React = __toESM(require("react"));
var import_useHelpMenuSchema = require("../hooks/useHelpMenuSchema");
var import_useMenuIsOpen = require("../hooks/useMenuIsOpen");
var import_useReadonly = require("../hooks/useReadonly");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_LanguageMenu = require("./LanguageMenu");
var M = __toESM(require("./primitives/DropdownMenu"));
var import_Icon = require("./primitives/Icon");
const HelpMenu = React.memo(function HelpMenu2() {
  const container = (0, import_editor.useContainer)();
  const msg = (0, import_useTranslation.useTranslation)();
  const [isOpen, onOpenChange] = (0, import_useMenuIsOpen.useMenuIsOpen)("help menu");
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-help-menu", children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_react_dropdown_menu.Root, { dir: "ltr", open: isOpen, onOpenChange, modal: false, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_react_dropdown_menu.Trigger,
      {
        className: "tlui-button tlui-help-menu__button",
        dir: "ltr",
        title: msg("help-menu.title"),
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon: "question-mark" })
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_dropdown_menu.Portal, { container, dir: "ltr", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_react_dropdown_menu.Content,
      {
        className: "tlui-menu",
        side: "top",
        sideOffset: 8,
        align: "end",
        alignOffset: 0,
        collisionPadding: 4,
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(HelpMenuContent, {})
      }
    ) })
  ] }) });
});
function HelpMenuContent() {
  const menuSchema = (0, import_useHelpMenuSchema.useHelpMenuSchema)();
  const isReadonly = (0, import_useReadonly.useReadonly)();
  function getHelpMenuItem(item) {
    if (isReadonly && !item.readonlyOk)
      return null;
    switch (item.type) {
      case "custom": {
        if (item.id === "LANGUAGE_MENU") {
          return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_LanguageMenu.LanguageMenu, {}, "item");
        }
        break;
      }
      case "group": {
        return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Group, { size: "small", children: item.children.map(getHelpMenuItem) }, item.id);
      }
      case "submenu": {
        return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Sub, { id: `help menu ${item.id}`, children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.SubTrigger, { label: item.label }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.SubContent, { children: item.children.map(getHelpMenuItem) })
        ] }, item.id);
      }
      case "item": {
        const { id, kbd, label, onSelect, icon } = item.actionItem;
        return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          M.Item,
          {
            kbd,
            label,
            onClick: () => onSelect("help-menu"),
            iconLeft: icon
          },
          id
        );
      }
    }
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: menuSchema.map(getHelpMenuItem) });
}
//# sourceMappingURL=HelpMenu.js.map
