"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Button_exports = {};
__export(Button_exports, {
  Button: () => Button
});
module.exports = __toCommonJS(Button_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_classnames = __toESM(require("classnames"));
var React = __toESM(require("react"));
var import_useTranslation = require("../../hooks/useTranslation/useTranslation");
var import_Spinner = require("../Spinner");
var import_Icon = require("./Icon");
var import_Kbd = require("./Kbd");
const Button = React.forwardRef(function Button2({
  label,
  icon,
  invertIcon,
  iconLeft,
  smallIcon,
  kbd,
  isChecked = false,
  type = "normal",
  children,
  spinner,
  ...props
}, ref) {
  const msg = (0, import_useTranslation.useTranslation)();
  const labelStr = label ? msg(label) : "";
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    "button",
    {
      ref,
      draggable: false,
      type: "button",
      ...props,
      title: props.title ?? labelStr,
      className: (0, import_classnames.default)("tlui-button", `tlui-button__${type}`, props.className),
      children: [
        iconLeft && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon: iconLeft, className: "tlui-icon-left", small: true }),
        children,
        label && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { draggable: false, children: [
          labelStr,
          isChecked && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon: "check" })
        ] }),
        kbd && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Kbd.Kbd, { children: kbd }),
        icon && !spinner && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon, small: !!label || smallIcon, invertIcon }),
        spinner && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Spinner.Spinner, {})
      ]
    }
  );
});
//# sourceMappingURL=Button.js.map
