import { jsx } from "react/jsx-runtime";
import {
  ShapeIndicator,
  useEditor,
  useValue
} from "@tldraw/editor";
const TldrawHoveredShapeIndicator = ({ shapeId }) => {
  const editor = useEditor();
  const showHoveredShapeIndicator = useValue(
    "show hovered",
    () => {
      if (editor.isIn("select.editing_shape")) {
        return editor.hoveredShapeId !== editor.editingShapeId;
      }
      return editor.isInAny("select.idle");
    },
    [editor]
  );
  if (!showHoveredShapeIndicator)
    return null;
  return /* @__PURE__ */ jsx(ShapeIndicator, { className: "tl-user-indicator__hovered", id: shapeId });
};
export {
  TldrawHoveredShapeIndicator
};
//# sourceMappingURL=TldrawHoveredShapeIndicator.mjs.map
