import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { Content, Portal, Root, Trigger } from "@radix-ui/react-dropdown-menu";
import { useContainer } from "@tldraw/editor";
import * as React from "react";
import { useHelpMenuSchema } from "../hooks/useHelpMenuSchema.mjs";
import { useMenuIsOpen } from "../hooks/useMenuIsOpen.mjs";
import { useReadonly } from "../hooks/useReadonly.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { LanguageMenu } from "./LanguageMenu.mjs";
import * as M from "./primitives/DropdownMenu.mjs";
import { Icon } from "./primitives/Icon.mjs";
const HelpMenu = React.memo(function HelpMenu2() {
  const container = useContainer();
  const msg = useTranslation();
  const [isOpen, onOpenChange] = useMenuIsOpen("help menu");
  return /* @__PURE__ */ jsx("div", { className: "tlui-help-menu", children: /* @__PURE__ */ jsxs(Root, { dir: "ltr", open: isOpen, onOpenChange, modal: false, children: [
    /* @__PURE__ */ jsx(
      Trigger,
      {
        className: "tlui-button tlui-help-menu__button",
        dir: "ltr",
        title: msg("help-menu.title"),
        children: /* @__PURE__ */ jsx(Icon, { icon: "question-mark" })
      }
    ),
    /* @__PURE__ */ jsx(Portal, { container, dir: "ltr", children: /* @__PURE__ */ jsx(
      Content,
      {
        className: "tlui-menu",
        side: "top",
        sideOffset: 8,
        align: "end",
        alignOffset: 0,
        collisionPadding: 4,
        children: /* @__PURE__ */ jsx(HelpMenuContent, {})
      }
    ) })
  ] }) });
});
function HelpMenuContent() {
  const menuSchema = useHelpMenuSchema();
  const isReadonly = useReadonly();
  function getHelpMenuItem(item) {
    if (isReadonly && !item.readonlyOk)
      return null;
    switch (item.type) {
      case "custom": {
        if (item.id === "LANGUAGE_MENU") {
          return /* @__PURE__ */ jsx(LanguageMenu, {}, "item");
        }
        break;
      }
      case "group": {
        return /* @__PURE__ */ jsx(M.Group, { size: "small", children: item.children.map(getHelpMenuItem) }, item.id);
      }
      case "submenu": {
        return /* @__PURE__ */ jsxs(M.Sub, { id: `help menu ${item.id}`, children: [
          /* @__PURE__ */ jsx(M.SubTrigger, { label: item.label }),
          /* @__PURE__ */ jsx(M.SubContent, { children: item.children.map(getHelpMenuItem) })
        ] }, item.id);
      }
      case "item": {
        const { id, kbd, label, onSelect, icon } = item.actionItem;
        return /* @__PURE__ */ jsx(
          M.Item,
          {
            kbd,
            label,
            onClick: () => onSelect("help-menu"),
            iconLeft: icon
          },
          id
        );
      }
    }
  }
  return /* @__PURE__ */ jsx(Fragment, { children: menuSchema.map(getHelpMenuItem) });
}
export {
  HelpMenu
};
//# sourceMappingURL=HelpMenu.mjs.map
