import {
  useEditor,
  useValue
} from "@tldraw/editor";
function useOnlyFlippableShape() {
  const editor = useEditor();
  return useValue(
    "onlyFlippableShape",
    () => {
      const { selectedShapes } = editor;
      return selectedShapes.length === 1 && selectedShapes.every(
        (shape) => editor.isShapeOfType(shape, "group") || editor.isShapeOfType(shape, "arrow") || editor.isShapeOfType(shape, "line") || editor.isShapeOfType(shape, "draw")
      );
    },
    [editor]
  );
}
export {
  useOnlyFlippableShape
};
//# sourceMappingURL=useOnlyFlippableShape.mjs.map
