import { useEffect } from "react";
import { useDrag } from "react-dnd";
import { getEmptyImage } from "react-dnd-html5-backend";
import { useTreeApi } from "../context";
import { actions as dnd } from "../state/dnd-slice";
export function useDragHook(node) {
    const tree = useTreeApi();
    const ids = tree.selectedIds;
    const [_, ref, preview] = useDrag(() => ({
        canDrag: () => node.isDraggable,
        type: "NODE",
        item: () => {
            // This is fired once at the begging of a drag operation
            const dragIds = tree.isSelected(node.id) ? Array.from(ids) : [node.id];
            tree.dispatch(dnd.dragStart(node.id, dragIds));
            return { id: node.id, dragIds };
        },
        end: () => {
            tree.hideCursor();
            tree.dispatch(dnd.dragEnd());
        },
    }), [ids, node]);
    useEffect(() => {
        preview(getEmptyImage());
    }, [preview]);
    return ref;
}
