import { createStore } from "redux";
import { rootReducer } from "../state/root-reducer";
import { TreeApi } from "./tree-api";
function setupApi(props) {
    const store = createStore(rootReducer);
    return new TreeApi(store, props, { current: null }, { current: null });
}
test("tree.canDrop()", () => {
    expect(setupApi({ disableDrop: true }).canDrop()).toBe(false);
    expect(setupApi({ disableDrop: () => false }).canDrop()).toBe(true);
    expect(setupApi({ disableDrop: false }).canDrop()).toBe(true);
});
