import {
  ViewPlugin
} from "./chunk-XE3PYSOW.js";
import {
  Annotation,
  ChangeSet
} from "./chunk-VGW6U5S5.js";
import "./chunk-F3JB2NZT.js";
import "./chunk-NX75WQT6.js";
import {
  next_slim_exports
} from "./chunk-SVC3MPPD.js";
import "./chunk-5WWUZCGV.js";

// node_modules/.deno/@automerge+automerge-codemirror@0.0.11/node_modules/@automerge/automerge-codemirror/dist/codeMirrorToAm.js
var applyCmTransactionsToAmHandle = (handle, path, transactions) => {
  const transactionsWithChanges = transactions.filter((tr) => !isReconcileTx(tr) && !tr.changes.empty);
  if (transactionsWithChanges.length === 0) {
    return;
  }
  handle.change((doc) => {
    transactionsWithChanges.forEach((tr) => {
      tr.changes.iterChanges((fromA, toA, fromB, _toB, inserted) => {
        next_slim_exports.splice(doc, path.slice(), fromB, toA - fromA, inserted.toString());
      });
    });
  });
  return next_slim_exports.getHeads(handle.docSync());
};

// node_modules/.deno/@automerge+automerge-codemirror@0.0.11/node_modules/@automerge/automerge-codemirror/dist/amToCodemirror.js
var applyAmPatchesToCm = (view, target, patches) => {
  let selection = view.state.selection;
  for (const patch of patches) {
    const changeSpec = handlePatch(patch, target, view.state);
    if (changeSpec != null) {
      const changeSet = ChangeSet.of(changeSpec, view.state.doc.length, "\n");
      selection = selection.map(changeSet, 1);
      view.dispatch({
        changes: changeSet,
        annotations: reconcileAnnotationType.of({})
      });
    }
  }
  view.dispatch({
    selection,
    annotations: reconcileAnnotationType.of({})
  });
};
function handlePatch(patch, target, state) {
  if (patch.action === "insert") {
    return handleInsert(target, patch);
  } else if (patch.action === "splice") {
    return handleSplice(target, patch);
  } else if (patch.action === "del") {
    return handleDel(target, patch);
  } else if (patch.action === "put") {
    return handlePut(target, patch, state);
  } else {
    return null;
  }
}
function handleInsert(target, patch) {
  const index = charPath(target, patch.path);
  if (index == null) {
    return [];
  }
  const text = patch.values.map((v) => v ? v.toString() : "").join("");
  return [{ from: index, to: index, insert: text }];
}
function handleSplice(target, patch) {
  const index = charPath(target, patch.path);
  if (index == null) {
    return [];
  }
  return [{ from: index, insert: patch.value }];
}
function handleDel(target, patch) {
  const index = charPath(target, patch.path);
  if (index == null) {
    return [];
  }
  const length = patch.length || 1;
  return [{ from: index, to: index + length }];
}
function handlePut(target, patch, state) {
  const index = charPath(target, [...patch.path, 0]);
  if (index == null) {
    return [];
  }
  const length = state.doc.length;
  if (typeof patch.value !== "string") {
    return [];
  }
  return [{ from: 0, to: length, insert: patch.value }];
}
function charPath(textPath, candidatePath) {
  if (candidatePath.length !== textPath.length + 1)
    return null;
  for (let i = 0; i < textPath.length; i++) {
    if (textPath[i] !== candidatePath[i])
      return null;
  }
  const index = candidatePath[candidatePath.length - 1];
  if (typeof index === "number")
    return index;
  return null;
}

// node_modules/.deno/@automerge+automerge-codemirror@0.0.11/node_modules/@automerge/automerge-codemirror/dist/plugin.js
var reconcileAnnotationType = Annotation.define();
var isReconcileTx = (tr) => !!tr.annotation(reconcileAnnotationType);
var automergeSyncPlugin = ({ handle, path }) => {
  if (!handle.isReady) {
    throw new Error("ensure the handle is ready before initializing the automergeSyncPlugin");
  }
  return ViewPlugin.fromClass(class {
    view;
    reconciledHeads = next_slim_exports.getHeads(handle.docSync());
    isProcessingCmTransaction = false;
    constructor(view) {
      this.view = view;
      this.onChange = this.onChange.bind(this);
      handle.on("change", this.onChange);
    }
    update(update) {
      this.isProcessingCmTransaction = true;
      const newHeads = applyCmTransactionsToAmHandle(handle, path, update.transactions);
      if (newHeads) {
        this.reconciledHeads = newHeads;
      }
      this.isProcessingCmTransaction = false;
    }
    onChange = () => {
      if (this.isProcessingCmTransaction) {
        return;
      }
      const currentHeads = next_slim_exports.getHeads(handle.docSync());
      if (next_slim_exports.equals(currentHeads, this.reconciledHeads)) {
        return;
      }
      const patches = next_slim_exports.diff(handle.docSync(), this.reconciledHeads, currentHeads);
      applyAmPatchesToCm(this.view, path, patches);
      this.reconciledHeads = currentHeads;
    };
    destroy() {
      handle.off("change", this.onChange);
    }
  });
};
export {
  automergeSyncPlugin
};
//# sourceMappingURL=@automerge_automerge-codemirror.js.map
