/**
 *
 * A `NetworkAdapter` which uses [BroadcastChannel](https://developer.mozilla.org/en-US/docs/Web/API/BroadcastChannel)
 * to communicate with other peers in the same browser tab. This is a bit of a
 * hack because `NetworkAdapter`s are supposed to be used as point to
 * point communication channels. To get around this the {@link BroadcastChannelNetworkAdapter}
 * broadcasts messages to all peers and then filters out messages not intended
 * for the current peer. This is quite inefficient as messages get duplicated
 * for every peer in the tab, but as it's all local communication anyway
 * it's not too bad. If efficiency is becoming an issue you can switch to
 * `automerge-repo-network-messagechannel`.
 *
 * @module
 *
 */
import { NetworkAdapter, type Message, type PeerId, type PeerMetadata } from "@automerge/automerge-repo/slim";
export type BroadcastChannelNetworkAdapterOptions = {
    channelName: string;
};
export declare class BroadcastChannelNetworkAdapter extends NetworkAdapter {
    #private;
    constructor(options?: BroadcastChannelNetworkAdapterOptions);
    connect(peerId: PeerId, peerMetadata?: PeerMetadata): void;
    send(message: Message): void;
    disconnect(): void;
}
//# sourceMappingURL=index.d.ts.map