/**
 * This module provides a storage adapter for IndexedDB.
 *
 * @packageDocumentation
 */
import { Chunk, StorageAdapterInterface } from "@automerge/automerge-repo/slim";
export declare class IndexedDBStorageAdapter implements StorageAdapterInterface {
    private database;
    private store;
    private dbPromise;
    /** Create a new {@link IndexedDBStorageAdapter}.
     * @param database - The name of the database to use. Defaults to "automerge".
     * @param store - The name of the object store to use. Defaults to "documents".
     */
    constructor(database?: string, store?: string);
    private createDatabasePromise;
    load(keyArray: string[]): Promise<Uint8Array | undefined>;
    save(keyArray: string[], binary: Uint8Array): Promise<void>;
    remove(keyArray: string[]): Promise<void>;
    loadRange(keyPrefix: string[]): Promise<Chunk[]>;
    removeRange(keyPrefix: string[]): Promise<void>;
}
//# sourceMappingURL=index.d.ts.map