import type { Automerge, Heads, ObjID, Patch } from "./wasm_types.js";
import { Doc, PatchCallback } from "./types.js";
export interface InternalState<T> {
    handle: Automerge;
    heads: Heads | undefined;
    freeze: boolean;
    mostRecentPatch: {
        before: Heads | undefined;
        after: Heads | undefined;
        patches: Patch[];
    };
    patchCallback?: PatchCallback<T>;
    textV2: boolean;
}
export declare function _state<T>(doc: Doc<T>, checkroot?: boolean): InternalState<T>;
export declare function _clear_cache<T>(doc: Doc<T>): void;
export declare function _trace<T>(doc: Doc<T>): string | undefined;
export declare function _obj<T>(doc: Doc<T>): ObjID | null;
export declare function _is_proxy<T>(doc: Doc<T>): boolean;
