/* c8 ignore start */
import { EventEmitter } from "eventemitter3";
export class WeakMessagePortRef extends EventEmitter {
    weakRef;
    isDisconnected = false;
    constructor(port) {
        super();
        this.weakRef = new WeakRef(port);
        port.addEventListener("message", event => {
            this.emit("message", event);
        });
    }
    postMessage(message, transfer) {
        const port = this.weakRef.deref();
        if (!port) {
            this.disconnnect();
            return;
        }
        try {
            port.postMessage(message, transfer);
        }
        catch (err) {
            this.disconnnect();
        }
    }
    start() {
        const port = this.weakRef.deref();
        if (!port) {
            this.disconnnect();
            return;
        }
        try {
            port.start();
        }
        catch (err) {
            this.disconnnect();
        }
    }
    disconnnect() {
        if (!this.isDisconnected) {
            this.emit("close");
            this.isDisconnected = true;
        }
    }
    isAlive() {
        if (this.isDisconnected) {
            return false;
        }
        if (!this.weakRef.deref()) {
            this.disconnnect();
            return false;
        }
        return true;
    }
}
/* c8 ignore end */
