/**
 * A `NetworkAdapter` which uses [`MessageChannel`](https://developer.mozilla.org/en-US/docs/Web/API/MessageChannel)
 * to communicate with other peers. This is useful for communicating between
 * browser tabs and web workers (including shared workers).
 *
 * @module
 */
import { type RepoMessage, NetworkAdapter, type PeerId, PeerMetadata } from "@automerge/automerge-repo/slim";
import { MessagePortRef } from "./MessagePortRef.js";
export declare class MessageChannelNetworkAdapter extends NetworkAdapter {
    #private;
    channels: {};
    /** @hidden */
    messagePortRef: MessagePortRef;
    constructor(messagePort: MessagePort, config?: MessageChannelNetworkAdapterConfig);
    connect(peerId: PeerId, peerMetadata?: PeerMetadata): void;
    send(message: RepoMessage): void;
    announceConnection(peerId: PeerId, peerMetadata: PeerMetadata): void;
    disconnect(): void;
}
export interface MessageChannelNetworkAdapterConfig {
    /**
     * This is an optional parameter to use a weak ref to reference the message port that is passed to
     * the adapter. This option is useful when using a message channel with a shared worker. If you
     * use a network adapter with `useWeakRef = true` in the shared worker and in the main thread
     * network adapters with strong refs the network adapter will be automatically garbage collected
     * if you close a page. The garbage collection doesn't happen immediately; there might be some
     * time in between when the page is closed and when the port is garbage collected
     */
    useWeakRef?: boolean;
}
//# sourceMappingURL=index.d.ts.map