import { EventEmitter } from "eventemitter3";
export class StrongMessagePortRef extends EventEmitter {
    port;
    constructor(port) {
        port.addEventListener("message", event => {
            this.emit("message", event);
        });
        super();
        this.port = port;
    }
    postMessage(message, transfer) {
        this.port.postMessage(message, transfer);
    }
    start() {
        this.port.start();
    }
    isAlive() {
        /* c8 ignore next */
        return true;
    }
}
