import hr, { createContext as dr, useContext as yr, useRef as Vt, useState as yt, useEffect as ge, useCallback as pr, useMemo as Nt } from "react";
const br = dr(null);
function Ne() {
  const e = yr(br);
  if (!e) throw new Error("Repo was not found on RepoContext.");
  return e;
}
function Tn(e) {
  const t = Ne(), r = e ? t.find(e) : null, n = Vt(r);
  r !== n.current && (n.current = r);
  const [, s] = yt(0), o = () => s((c) => c + 1);
  ge(() => !e || !r ? void 0 : (n.current = r, r.doc().then(() => {
    o();
  }).catch((a) => console.error(a)), r.on("change", o), r.on("delete", o), () => {
    r.removeListener("change", o), r.removeListener("delete", o);
  }), [e, r]);
  const i = pr(
    (c, a) => {
      r && r.change(c, a);
    },
    [r]
  );
  return [r?.docSync(), i];
}
const ye = Symbol.for("_am_meta"), Ee = Symbol.for("_am_trace"), _e = Symbol.for("_am_objectId"), pt = Symbol.for("_am_isProxy"), Ht = Symbol.for("_am_clearCache"), gr = Symbol.for("_am_uint"), xr = Symbol.for("_am_int"), wr = Symbol.for("_am_f64"), $t = Symbol.for("_am_counter"), mr = Symbol.for("_am_text");
class pe {
  constructor(t) {
    if (typeof t == "string")
      this.elems = [...t];
    else if (Array.isArray(t))
      this.elems = t;
    else if (t === void 0)
      this.elems = [];
    else
      throw new TypeError(`Unsupported initial value for Text: ${t}`);
    Reflect.defineProperty(this, mr, { value: !0 });
  }
  get length() {
    return this.elems.length;
  }
  //eslint-disable-next-line @typescript-eslint/no-explicit-any
  get(t) {
    return this.elems[t];
  }
  /**
   * Iterates over the text elements character by character, including any
   * inline objects.
   */
  [Symbol.iterator]() {
    const t = this.elems;
    let r = -1;
    return {
      next() {
        return r += 1, r < t.length ? { done: !1, value: t[r] } : { done: !0 };
      }
    };
  }
  /**
   * Returns the content of the Text object as a simple string, ignoring any
   * non-character elements.
   */
  toString() {
    if (!this.str) {
      this.str = "";
      for (const t of this.elems)
        typeof t == "string" ? this.str += t : this.str += "￼";
    }
    return this.str;
  }
  /**
   * Returns the content of the Text object as a sequence of strings,
   * interleaved with non-character elements.
   *
   * For example, the value `['a', 'b', {x: 3}, 'c', 'd']` has spans:
   * `=> ['ab', {x: 3}, 'cd']`
   */
  toSpans() {
    if (!this.spans) {
      this.spans = [];
      let t = "";
      for (const r of this.elems)
        typeof r == "string" ? t += r : (t.length > 0 && (this.spans.push(t), t = ""), this.spans.push(r));
      t.length > 0 && this.spans.push(t);
    }
    return this.spans;
  }
  /**
   * Returns the content of the Text object as a simple string, so that the
   * JSON serialization of an Automerge document represents text nicely.
   */
  toJSON() {
    return this.toString();
  }
  /**
   * Updates the list item at position `index` to a new value `value`.
   */
  set(t, r) {
    if (this[ye])
      throw new RangeError("object cannot be modified outside of a change block");
    this.elems[t] = r;
  }
  /**
   * Inserts new list items `values` starting at position `index`.
   */
  insertAt(t, ...r) {
    if (this[ye])
      throw new RangeError("object cannot be modified outside of a change block");
    r.every((n) => typeof n == "string") ? this.elems.splice(t, 0, ...r.join("")) : this.elems.splice(t, 0, ...r);
  }
  /**
   * Deletes `numDelete` list items starting at position `index`.
   * if `numDelete` is not given, one item is deleted.
   */
  deleteAt(t, r = 1) {
    if (this[ye])
      throw new RangeError("object cannot be modified outside of a change block");
    this.elems.splice(t, r);
  }
  map(t) {
    this.elems.map(t);
  }
  lastIndexOf(t, r) {
    this.elems.lastIndexOf(t, r);
  }
  concat(t) {
    return new pe(this.elems.concat(t.elems));
  }
  every(t) {
    return this.elems.every(t);
  }
  filter(t) {
    return new pe(this.elems.filter(t));
  }
  find(t) {
    return this.elems.find(t);
  }
  findIndex(t) {
    return this.elems.findIndex(t);
  }
  forEach(t) {
    this.elems.forEach(t);
  }
  includes(t) {
    return this.elems.includes(t);
  }
  indexOf(t) {
    return this.elems.indexOf(t);
  }
  join(t) {
    return this.elems.join(t);
  }
  reduce(t) {
    this.elems.reduce(t);
  }
  reduceRight(t) {
    this.elems.reduceRight(t);
  }
  slice(t, r) {
    return new pe(this.elems.slice(t, r));
  }
  some(t) {
    return this.elems.some(t);
  }
  toLocaleString() {
    this.toString();
  }
}
class vr {
  constructor(t) {
    this.value = t || 0, Reflect.defineProperty(this, $t, { value: !0 });
  }
  /**
   * A peculiar JavaScript language feature from its early days: if the object
   * `x` has a `valueOf()` method that returns a number, you can use numerical
   * operators on the object `x` directly, such as `x + 1` or `x < 4`.
   * This method is also called when coercing a value to a string by
   * concatenating it with another string, as in `x + ''`.
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/valueOf
   */
  valueOf() {
    return this.value;
  }
  /**
   * Returns the counter value as a decimal string. If `x` is a counter object,
   * this method is called e.g. when you do `['value: ', x].join('')` or when
   * you use string interpolation: `value: ${x}`.
   */
  toString() {
    return this.valueOf().toString();
  }
  /**
   * Returns the counter value, so that a JSON serialization of an Automerge
   * document represents the counter simply as an integer.
   */
  toJSON() {
    return this.value;
  }
  /**
   * Increases the value of the counter by `delta`. If `delta` is not given,
   * increases the value of the counter by 1.
   *
   * Will throw an error if used outside of a change callback.
   */
  increment(t) {
    throw new Error("Counters should not be incremented outside of a change callback");
  }
  /**
   * Decreases the value of the counter by `delta`. If `delta` is not given,
   * decreases the value of the counter by 1.
   *
   * Will throw an error if used outside of a change callback.
   */
  decrement(t) {
    throw new Error("Counters should not be decremented outside of a change callback");
  }
}
class Sr extends vr {
  constructor(t, r, n, s, o) {
    super(t), this.context = r, this.path = n, this.objectId = s, this.key = o;
  }
  /**
   * Increases the value of the counter by `delta`. If `delta` is not given,
   * increases the value of the counter by 1.
   */
  increment(t) {
    return t = typeof t == "number" ? t : 1, this.context.increment(this.objectId, this.key, t), this.value += t, this.value;
  }
  /**
   * Decreases the value of the counter by `delta`. If `delta` is not given,
   * decreases the value of the counter by 1.
   */
  decrement(t) {
    return this.increment(typeof t == "number" ? -t : -1);
  }
}
function Ar(e, t, r, n, s) {
  return new Sr(e, t, r, n, s);
}
class Cr {
  constructor(t) {
    this.val = t;
  }
  /**
   * Returns the content of the RawString object as a simple string
   */
  toString() {
    return this.val;
  }
  toJSON() {
    return this.val;
  }
}
function ae(e) {
  if (typeof e == "string" && /^[0-9]+$/.test(e) && (e = parseInt(e, 10)), typeof e != "number")
    return e;
  if (e < 0 || isNaN(e) || e === 1 / 0 || e === -1 / 0)
    throw new RangeError("A list index must be positive, but you passed " + e);
  return e;
}
function re(e, t) {
  const { context: r, objectId: n, path: s, textV2: o } = e, i = r.getWithType(n, t);
  if (i === null)
    return;
  const c = i[0], a = i[1];
  switch (c) {
    case void 0:
      return;
    case "map":
      return $e(r, a, o, [...s, t]);
    case "list":
      return ze(r, a, o, [...s, t]);
    case "text":
      return o ? r.text(a) : Oe(r, a, [
        ...s,
        t
      ]);
    case "str":
      return a;
    case "uint":
      return a;
    case "int":
      return a;
    case "f64":
      return a;
    case "boolean":
      return a;
    case "null":
      return null;
    case "bytes":
      return a;
    case "timestamp":
      return a;
    case "counter":
      return Ar(a, r, s, n, t);
    default:
      throw RangeError(`datatype ${c} unimplemented`);
  }
}
function Te(e, t, r, n) {
  const s = typeof e;
  switch (s) {
    case "object":
      if (e == null)
        return [null, "null"];
      if (e[gr])
        return [e.value, "uint"];
      if (e[xr])
        return [e.value, "int"];
      if (e[wr])
        return [e.value, "f64"];
      if (e[$t])
        return [e.value, "counter"];
      if (e instanceof Date)
        return [e.getTime(), "timestamp"];
      if (e instanceof Cr)
        return [e.toString(), "str"];
      if (e instanceof pe)
        return [e, "text"];
      if (e instanceof Uint8Array)
        return [e, "bytes"];
      if (e instanceof Array)
        return [e, "list"];
      if (Object.prototype.toString.call(e) === "[object Object]")
        return [e, "map"];
      throw He(e, n) ? new RangeError("Cannot create a reference to an existing document object") : new RangeError(`Cannot assign unknown object: ${e}`);
    case "boolean":
      return [e, "boolean"];
    case "number":
      return Number.isInteger(e) ? [e, "int"] : [e, "f64"];
    case "string":
      return t ? [e, "text"] : [e, "str"];
    case "undefined":
      throw new RangeError([
        `Cannot assign undefined value at ${Et(r)}, `,
        "because `undefined` is not a valid JSON data type. ",
        "You might consider setting the property's value to `null`, ",
        "or using `delete` to remove it altogether."
      ].join(""));
    default:
      throw new RangeError([
        `Cannot assign ${s} value at ${Et(r)}. `,
        "All JSON primitive datatypes (object, array, string, number, boolean, null) ",
        `are supported in an Automerge document; ${s} values are not. `
      ].join(""));
  }
}
function He(e, t) {
  var r, n;
  return e instanceof Date ? !1 : !!(e && ((n = (r = e[ye]) === null || r === void 0 ? void 0 : r.handle) === null || n === void 0 ? void 0 : n.__wbg_ptr) === t.__wbg_ptr);
}
const Er = {
  get(e, t) {
    const { context: r, objectId: n, cache: s } = e;
    return t === Symbol.toStringTag ? e[Symbol.toStringTag] : t === _e ? n : t === pt ? !0 : t === Ee ? e.trace : t === ye ? { handle: r, textV2: e.textV2 } : (s[t] || (s[t] = re(e, t)), s[t]);
  },
  set(e, t, r) {
    const { context: n, objectId: s, path: o, textV2: i } = e;
    if (e.cache = {}, He(r, n))
      throw new RangeError("Cannot create a reference to an existing document object");
    if (t === Ee)
      return e.trace = r, !0;
    if (t === Ht)
      return !0;
    const [c, a] = Te(r, i, [...o, t], n);
    switch (a) {
      case "list": {
        const p = n.putObject(s, t, []), d = ze(n, p, i, [...o, t]);
        for (let h = 0; h < c.length; h++)
          d[h] = c[h];
        break;
      }
      case "text": {
        if (i)
          De(c), n.putObject(s, t, c);
        else {
          gt(c);
          const p = n.putObject(s, t, "");
          Oe(n, p, [...o, t]).splice(0, 0, ...c);
        }
        break;
      }
      case "map": {
        const p = n.putObject(s, t, {}), d = $e(n, p, i, [...o, t]);
        for (const h in c)
          d[h] = c[h];
        break;
      }
      default:
        n.put(s, t, c, a);
    }
    return !0;
  },
  deleteProperty(e, t) {
    const { context: r, objectId: n } = e;
    return e.cache = {}, r.delete(n, t), !0;
  },
  has(e, t) {
    return this.get(e, t) !== void 0;
  },
  getOwnPropertyDescriptor(e, t) {
    const r = this.get(e, t);
    if (typeof r < "u")
      return {
        configurable: !0,
        enumerable: !0,
        value: r
      };
  },
  ownKeys(e) {
    const { context: t, objectId: r } = e, n = t.keys(r);
    return [...new Set(n)];
  }
}, zt = {
  get(e, t) {
    const { context: r, objectId: n } = e;
    return t = ae(t), t === Symbol.hasInstance ? (s) => Array.isArray(s) : t === Symbol.toStringTag ? e[Symbol.toStringTag] : t === _e ? n : t === pt ? !0 : t === Ee ? e.trace : t === ye ? { handle: r } : t === "length" ? r.length(n) : typeof t == "number" ? re(e, t) : bt(e)[t];
  },
  set(e, t, r) {
    const { context: n, objectId: s, path: o, textV2: i } = e;
    if (t = ae(t), He(r, n))
      throw new RangeError("Cannot create a reference to an existing document object");
    if (t === Ht)
      return !0;
    if (t === Ee)
      return e.trace = r, !0;
    if (typeof t == "string")
      throw new RangeError("list index must be a number");
    const [c, a] = Te(r, i, [...o, t], n);
    switch (a) {
      case "list": {
        let p;
        t >= n.length(s) ? p = n.insertObject(s, t, []) : p = n.putObject(s, t, []), ze(n, p, i, [...o, t]).splice(0, 0, ...c);
        break;
      }
      case "text": {
        if (i)
          De(c), t >= n.length(s) ? n.insertObject(s, t, c) : n.putObject(s, t, c);
        else {
          let p;
          gt(c), t >= n.length(s) ? p = n.insertObject(s, t, "") : p = n.putObject(s, t, ""), Oe(n, p, [...o, t]).splice(0, 0, ...c);
        }
        break;
      }
      case "map": {
        let p;
        t >= n.length(s) ? p = n.insertObject(s, t, {}) : p = n.putObject(s, t, {});
        const d = $e(n, p, i, [...o, t]);
        for (const h in c)
          d[h] = c[h];
        break;
      }
      default:
        t >= n.length(s) ? n.insert(s, t, c, a) : n.put(s, t, c, a);
    }
    return !0;
  },
  deleteProperty(e, t) {
    const { context: r, objectId: n } = e;
    t = ae(t);
    const s = r.get(n, t);
    if (s != null && s[0] == "counter")
      throw new TypeError("Unsupported operation: deleting a counter from a list");
    return r.delete(n, t), !0;
  },
  has(e, t) {
    const { context: r, objectId: n } = e;
    return t = ae(t), typeof t == "number" ? t < r.length(n) : t === "length";
  },
  getOwnPropertyDescriptor(e, t) {
    const { context: r, objectId: n } = e;
    return t === "length" ? { writable: !0, value: r.length(n) } : t === _e ? { configurable: !1, enumerable: !1, value: n } : (t = ae(t), { configurable: !0, enumerable: !0, value: re(e, t) });
  },
  getPrototypeOf(e) {
    return Object.getPrototypeOf(e);
  },
  ownKeys() {
    const e = [];
    return e.push("length"), e;
  }
}, _r = Object.assign({}, zt, {
  get(e, t) {
    const { context: r, objectId: n } = e;
    return t = ae(t), t === Symbol.hasInstance ? (s) => Array.isArray(s) : t === Symbol.toStringTag ? e[Symbol.toStringTag] : t === _e ? n : t === pt ? !0 : t === Ee ? e.trace : t === ye ? { handle: r } : t === "length" ? r.length(n) : typeof t == "number" ? re(e, t) : Or(e)[t] || bt(e)[t];
  },
  getPrototypeOf() {
    return Object.getPrototypeOf(new pe());
  }
});
function $e(e, t, r, n) {
  const s = {
    context: e,
    objectId: t,
    path: n || [],
    cache: {},
    textV2: r
  }, o = {};
  return Object.assign(o, s), new Proxy(o, Er);
}
function ze(e, t, r, n) {
  const s = {
    context: e,
    objectId: t,
    path: n || [],
    cache: {},
    textV2: r
  }, o = [];
  return Object.assign(o, s), new Proxy(o, zt);
}
function Oe(e, t, r) {
  const n = {
    context: e,
    objectId: t,
    path: r || [],
    cache: {},
    textV2: !1
  }, s = {};
  return Object.assign(s, n), new Proxy(s, _r);
}
function bt(e) {
  const { context: t, objectId: r, path: n, textV2: s } = e;
  return {
    deleteAt(i, c) {
      return typeof c == "number" ? t.splice(r, i, c) : t.delete(r, i), this;
    },
    fill(i, c, a) {
      const [p, d] = Te(i, s, [...n, c], t), h = t.length(r);
      c = ae(c || 0), a = ae(a || h);
      for (let g = c; g < Math.min(a, h); g++)
        if (d === "list" || d === "map")
          t.putObject(r, g, p);
        else if (d === "text")
          if (s)
            De(p), t.putObject(r, g, p);
          else {
            gt(p);
            const u = t.putObject(r, g, ""), b = Oe(t, u, [...n, g]);
            for (let x = 0; x < p.length; x++)
              b[x] = p.get(x);
          }
        else
          t.put(r, g, p, d);
      return this;
    },
    indexOf(i, c = 0) {
      const a = t.length(r);
      for (let p = c; p < a; p++) {
        const d = t.getWithType(r, p);
        if (d && (d[1] === i[_e] || d[1] === i))
          return p;
      }
      return -1;
    },
    insertAt(i, ...c) {
      return this.splice(i, 0, ...c), this;
    },
    pop() {
      const i = t.length(r);
      if (i == 0)
        return;
      const c = re(e, i - 1);
      return t.delete(r, i - 1), c;
    },
    push(...i) {
      const c = t.length(r);
      return this.splice(c, 0, ...i), t.length(r);
    },
    shift() {
      if (t.length(r) == 0)
        return;
      const i = re(e, 0);
      return t.delete(r, 0), i;
    },
    splice(i, c, ...a) {
      i = ae(i), typeof c != "number" && (c = t.length(r) - i), c = ae(c);
      for (const h of a)
        if (He(h, t))
          throw new RangeError("Cannot create a reference to an existing document object");
      const p = [];
      for (let h = 0; h < c; h++) {
        const g = re(e, i);
        g !== void 0 && p.push(g), t.delete(r, i);
      }
      const d = a.map((h, g) => {
        try {
          return Te(h, s, [...n], t);
        } catch (u) {
          throw u instanceof RangeError ? new RangeError(`${u.message} (at index ${g} in the input)`) : u;
        }
      });
      for (const [h, g] of d) {
        switch (g) {
          case "list": {
            const u = t.insertObject(r, i, []);
            ze(t, u, s, [...n, i]).splice(0, 0, ...h);
            break;
          }
          case "text": {
            if (s)
              De(h), t.insertObject(r, i, h);
            else {
              const u = t.insertObject(r, i, "");
              Oe(t, u, [...n, i]).splice(0, 0, ...h);
            }
            break;
          }
          case "map": {
            const u = t.insertObject(r, i, {}), b = $e(t, u, s, [...n, i]);
            for (const x in h)
              b[x] = h[x];
            break;
          }
          default:
            t.insert(r, i, h, g);
        }
        i += 1;
      }
      return p;
    },
    unshift(...i) {
      return this.splice(0, 0, ...i), t.length(r);
    },
    entries() {
      let i = 0;
      return {
        next: () => {
          const a = re(e, i);
          return a === void 0 ? { value: void 0, done: !0 } : { value: [i++, a], done: !1 };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    },
    keys() {
      let i = 0;
      const c = t.length(r);
      return {
        next: () => i < c ? { value: i++, done: !1 } : { value: void 0, done: !0 },
        [Symbol.iterator]() {
          return this;
        }
      };
    },
    values() {
      let i = 0;
      return {
        next: () => {
          const a = re(e, i++);
          return a === void 0 ? { value: void 0, done: !0 } : { value: a, done: !1 };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    },
    toArray() {
      const i = [];
      let c;
      do
        c = re(e, i.length), c !== void 0 && i.push(c);
      while (c !== void 0);
      return i;
    },
    map(i) {
      return this.toArray().map(i);
    },
    toString() {
      return this.toArray().toString();
    },
    toLocaleString() {
      return this.toArray().toLocaleString();
    },
    forEach(i) {
      return this.toArray().forEach(i);
    },
    // todo: real concat function is different
    concat(i) {
      return this.toArray().concat(i);
    },
    every(i) {
      return this.toArray().every(i);
    },
    filter(i) {
      return this.toArray().filter(i);
    },
    find(i) {
      let c = 0;
      for (const a of this) {
        if (i(a, c))
          return a;
        c += 1;
      }
    },
    findIndex(i) {
      let c = 0;
      for (const a of this) {
        if (i(a, c))
          return c;
        c += 1;
      }
      return -1;
    },
    includes(i) {
      return this.find((c) => c === i) !== void 0;
    },
    join(i) {
      return this.toArray().join(i);
    },
    reduce(i, c) {
      return this.toArray().reduce(i, c);
    },
    reduceRight(i, c) {
      return this.toArray().reduceRight(i, c);
    },
    lastIndexOf(i, c = 1 / 0) {
      return this.toArray().lastIndexOf(i, c);
    },
    slice(i, c) {
      return this.toArray().slice(i, c);
    },
    some(i) {
      let c = 0;
      for (const a of this) {
        if (i(a, c))
          return !0;
        c += 1;
      }
      return !1;
    },
    [Symbol.iterator]: function* () {
      let i = 0, c = re(e, i);
      for (; c !== void 0; )
        yield c, i += 1, c = re(e, i);
    }
  };
}
function Or(e) {
  const { context: t, objectId: r } = e;
  return {
    set(s, o) {
      return this[s] = o;
    },
    get(s) {
      return this[s];
    },
    toString() {
      return t.text(r).replace(/￼/g, "");
    },
    toSpans() {
      const s = [];
      let o = "";
      const i = t.length(r);
      for (let c = 0; c < i; c++) {
        const a = this[c];
        typeof a == "string" ? o += a : (o.length > 0 && (s.push(o), o = ""), s.push(a));
      }
      return o.length > 0 && s.push(o), s;
    },
    toJSON() {
      return this.toString();
    },
    indexOf(s, o = 0) {
      return t.text(r).indexOf(s, o);
    },
    insertAt(s, ...o) {
      o.every((i) => typeof i == "string") ? t.splice(r, s, 0, o.join("")) : bt(e).insertAt(s, ...o);
    }
  };
}
function gt(e) {
  if (!(e instanceof pe))
    throw new Error("value was not a Text instance");
}
function De(e) {
  if (typeof e != "string")
    throw new Error("value was not a string");
}
function Et(e) {
  const t = e.map((r) => {
    if (typeof r == "number")
      return r.toString();
    if (typeof r == "string")
      return r.replace(/~/g, "~0").replace(/\//g, "~1");
  });
  return e.length === 0 ? "" : "/" + t.join("/");
}
const Ir = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
function Kt(e) {
  return typeof e == "string" && Ir.test(e);
}
const Z = [];
for (let e = 0; e < 256; ++e)
  Z.push((e + 256).toString(16).slice(1));
function Ur(e, t = 0) {
  return Z[e[t + 0]] + Z[e[t + 1]] + Z[e[t + 2]] + Z[e[t + 3]] + "-" + Z[e[t + 4]] + Z[e[t + 5]] + "-" + Z[e[t + 6]] + Z[e[t + 7]] + "-" + Z[e[t + 8]] + Z[e[t + 9]] + "-" + Z[e[t + 10]] + Z[e[t + 11]] + Z[e[t + 12]] + Z[e[t + 13]] + Z[e[t + 14]] + Z[e[t + 15]];
}
function Fr(e, t = 0) {
  const r = Ur(e, t);
  if (!Kt(r))
    throw TypeError("Stringified UUID is invalid");
  return r;
}
let Wt;
const Jt = new Array(128).fill(void 0);
Jt.push(void 0, null, !0, !1);
Jt.length;
const Ge = typeof TextEncoder < "u" ? new TextEncoder("utf-8") : { encode: () => {
  throw Error("TextEncoder not available");
} };
Ge.encodeInto;
const jr = typeof TextDecoder < "u" ? new TextDecoder("utf-8", { ignoreBOM: !0, fatal: !0 }) : { decode: () => {
  throw Error("TextDecoder not available");
} };
typeof TextDecoder < "u" && jr.decode();
typeof FinalizationRegistry > "u" || new FinalizationRegistry((e) => Wt.__wbg_automerge_free(e >>> 0));
typeof FinalizationRegistry > "u" || new FinalizationRegistry((e) => Wt.__wbg_syncstate_free(e >>> 0));
var kr = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
function Ke(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
var st = { exports: {} }, Xe, _t;
function Rr() {
  if (_t) return Xe;
  _t = 1;
  var e = 1e3, t = e * 60, r = t * 60, n = r * 24, s = n * 7, o = n * 365.25;
  Xe = function(d, h) {
    h = h || {};
    var g = typeof d;
    if (g === "string" && d.length > 0)
      return i(d);
    if (g === "number" && isFinite(d))
      return h.long ? a(d) : c(d);
    throw new Error(
      "val is not a non-empty string or a valid number. val=" + JSON.stringify(d)
    );
  };
  function i(d) {
    if (d = String(d), !(d.length > 100)) {
      var h = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        d
      );
      if (h) {
        var g = parseFloat(h[1]), u = (h[2] || "ms").toLowerCase();
        switch (u) {
          case "years":
          case "year":
          case "yrs":
          case "yr":
          case "y":
            return g * o;
          case "weeks":
          case "week":
          case "w":
            return g * s;
          case "days":
          case "day":
          case "d":
            return g * n;
          case "hours":
          case "hour":
          case "hrs":
          case "hr":
          case "h":
            return g * r;
          case "minutes":
          case "minute":
          case "mins":
          case "min":
          case "m":
            return g * t;
          case "seconds":
          case "second":
          case "secs":
          case "sec":
          case "s":
            return g * e;
          case "milliseconds":
          case "millisecond":
          case "msecs":
          case "msec":
          case "ms":
            return g;
          default:
            return;
        }
      }
    }
  }
  function c(d) {
    var h = Math.abs(d);
    return h >= n ? Math.round(d / n) + "d" : h >= r ? Math.round(d / r) + "h" : h >= t ? Math.round(d / t) + "m" : h >= e ? Math.round(d / e) + "s" : d + "ms";
  }
  function a(d) {
    var h = Math.abs(d);
    return h >= n ? p(d, h, n, "day") : h >= r ? p(d, h, r, "hour") : h >= t ? p(d, h, t, "minute") : h >= e ? p(d, h, e, "second") : d + " ms";
  }
  function p(d, h, g, u) {
    var b = h >= g * 1.5;
    return Math.round(d / g) + " " + u + (b ? "s" : "");
  }
  return Xe;
}
function Mr(e) {
  r.debug = r, r.default = r, r.coerce = a, r.disable = o, r.enable = s, r.enabled = i, r.humanize = Rr(), r.destroy = p, Object.keys(e).forEach((d) => {
    r[d] = e[d];
  }), r.names = [], r.skips = [], r.formatters = {};
  function t(d) {
    let h = 0;
    for (let g = 0; g < d.length; g++)
      h = (h << 5) - h + d.charCodeAt(g), h |= 0;
    return r.colors[Math.abs(h) % r.colors.length];
  }
  r.selectColor = t;
  function r(d) {
    let h, g = null, u, b;
    function x(...A) {
      if (!x.enabled)
        return;
      const I = x, U = Number(/* @__PURE__ */ new Date()), S = U - (h || U);
      I.diff = S, I.prev = h, I.curr = U, h = U, A[0] = r.coerce(A[0]), typeof A[0] != "string" && A.unshift("%O");
      let B = 0;
      A[0] = A[0].replace(/%([a-zA-Z%])/g, (F, N) => {
        if (F === "%%")
          return "%";
        B++;
        const L = r.formatters[N];
        if (typeof L == "function") {
          const $ = A[B];
          F = L.call(I, $), A.splice(B, 1), B--;
        }
        return F;
      }), r.formatArgs.call(I, A), (I.log || r.log).apply(I, A);
    }
    return x.namespace = d, x.useColors = r.useColors(), x.color = r.selectColor(d), x.extend = n, x.destroy = r.destroy, Object.defineProperty(x, "enabled", {
      enumerable: !0,
      configurable: !1,
      get: () => g !== null ? g : (u !== r.namespaces && (u = r.namespaces, b = r.enabled(d)), b),
      set: (A) => {
        g = A;
      }
    }), typeof r.init == "function" && r.init(x), x;
  }
  function n(d, h) {
    const g = r(this.namespace + (typeof h > "u" ? ":" : h) + d);
    return g.log = this.log, g;
  }
  function s(d) {
    r.save(d), r.namespaces = d, r.names = [], r.skips = [];
    let h;
    const g = (typeof d == "string" ? d : "").split(/[\s,]+/), u = g.length;
    for (h = 0; h < u; h++)
      g[h] && (d = g[h].replace(/\*/g, ".*?"), d[0] === "-" ? r.skips.push(new RegExp("^" + d.slice(1) + "$")) : r.names.push(new RegExp("^" + d + "$")));
  }
  function o() {
    const d = [
      ...r.names.map(c),
      ...r.skips.map(c).map((h) => "-" + h)
    ].join(",");
    return r.enable(""), d;
  }
  function i(d) {
    if (d[d.length - 1] === "*")
      return !0;
    let h, g;
    for (h = 0, g = r.skips.length; h < g; h++)
      if (r.skips[h].test(d))
        return !1;
    for (h = 0, g = r.names.length; h < g; h++)
      if (r.names[h].test(d))
        return !0;
    return !1;
  }
  function c(d) {
    return d.toString().substring(2, d.toString().length - 2).replace(/\.\*\?$/, "*");
  }
  function a(d) {
    return d instanceof Error ? d.stack || d.message : d;
  }
  function p() {
    console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
  }
  return r.enable(r.load()), r;
}
var Br = Mr;
(function(e, t) {
  t.formatArgs = n, t.save = s, t.load = o, t.useColors = r, t.storage = i(), t.destroy = /* @__PURE__ */ (() => {
    let a = !1;
    return () => {
      a || (a = !0, console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."));
    };
  })(), t.colors = [
    "#0000CC",
    "#0000FF",
    "#0033CC",
    "#0033FF",
    "#0066CC",
    "#0066FF",
    "#0099CC",
    "#0099FF",
    "#00CC00",
    "#00CC33",
    "#00CC66",
    "#00CC99",
    "#00CCCC",
    "#00CCFF",
    "#3300CC",
    "#3300FF",
    "#3333CC",
    "#3333FF",
    "#3366CC",
    "#3366FF",
    "#3399CC",
    "#3399FF",
    "#33CC00",
    "#33CC33",
    "#33CC66",
    "#33CC99",
    "#33CCCC",
    "#33CCFF",
    "#6600CC",
    "#6600FF",
    "#6633CC",
    "#6633FF",
    "#66CC00",
    "#66CC33",
    "#9900CC",
    "#9900FF",
    "#9933CC",
    "#9933FF",
    "#99CC00",
    "#99CC33",
    "#CC0000",
    "#CC0033",
    "#CC0066",
    "#CC0099",
    "#CC00CC",
    "#CC00FF",
    "#CC3300",
    "#CC3333",
    "#CC3366",
    "#CC3399",
    "#CC33CC",
    "#CC33FF",
    "#CC6600",
    "#CC6633",
    "#CC9900",
    "#CC9933",
    "#CCCC00",
    "#CCCC33",
    "#FF0000",
    "#FF0033",
    "#FF0066",
    "#FF0099",
    "#FF00CC",
    "#FF00FF",
    "#FF3300",
    "#FF3333",
    "#FF3366",
    "#FF3399",
    "#FF33CC",
    "#FF33FF",
    "#FF6600",
    "#FF6633",
    "#FF9900",
    "#FF9933",
    "#FFCC00",
    "#FFCC33"
  ];
  function r() {
    return typeof window < "u" && window.process && (window.process.type === "renderer" || window.process.__nwjs) ? !0 : typeof navigator < "u" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/) ? !1 : typeof document < "u" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
    typeof window < "u" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
    // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
    typeof navigator < "u" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
    typeof navigator < "u" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
  }
  function n(a) {
    if (a[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + a[0] + (this.useColors ? "%c " : " ") + "+" + e.exports.humanize(this.diff), !this.useColors)
      return;
    const p = "color: " + this.color;
    a.splice(1, 0, p, "color: inherit");
    let d = 0, h = 0;
    a[0].replace(/%[a-zA-Z%]/g, (g) => {
      g !== "%%" && (d++, g === "%c" && (h = d));
    }), a.splice(h, 0, p);
  }
  t.log = console.debug || console.log || (() => {
  });
  function s(a) {
    try {
      a ? t.storage.setItem("debug", a) : t.storage.removeItem("debug");
    } catch {
    }
  }
  function o() {
    let a;
    try {
      a = t.storage.getItem("debug");
    } catch {
    }
    return !a && typeof process < "u" && "env" in process && (a = process.env.DEBUG), a;
  }
  function i() {
    try {
      return localStorage;
    } catch {
    }
  }
  e.exports = Br(t);
  const { formatters: c } = e.exports;
  c.j = function(a) {
    try {
      return JSON.stringify(a);
    } catch (p) {
      return "[UnexpectedJSONParseError]: " + p.message;
    }
  };
})(st, st.exports);
var Tr = st.exports;
const Dr = /* @__PURE__ */ Ke(Tr);
var Gt = { exports: {} };
(function(e) {
  var t = Object.prototype.hasOwnProperty, r = "~";
  function n() {
  }
  Object.create && (n.prototype = /* @__PURE__ */ Object.create(null), new n().__proto__ || (r = !1));
  function s(a, p, d) {
    this.fn = a, this.context = p, this.once = d || !1;
  }
  function o(a, p, d, h, g) {
    if (typeof d != "function")
      throw new TypeError("The listener must be a function");
    var u = new s(d, h || a, g), b = r ? r + p : p;
    return a._events[b] ? a._events[b].fn ? a._events[b] = [a._events[b], u] : a._events[b].push(u) : (a._events[b] = u, a._eventsCount++), a;
  }
  function i(a, p) {
    --a._eventsCount === 0 ? a._events = new n() : delete a._events[p];
  }
  function c() {
    this._events = new n(), this._eventsCount = 0;
  }
  c.prototype.eventNames = function() {
    var p = [], d, h;
    if (this._eventsCount === 0) return p;
    for (h in d = this._events)
      t.call(d, h) && p.push(r ? h.slice(1) : h);
    return Object.getOwnPropertySymbols ? p.concat(Object.getOwnPropertySymbols(d)) : p;
  }, c.prototype.listeners = function(p) {
    var d = r ? r + p : p, h = this._events[d];
    if (!h) return [];
    if (h.fn) return [h.fn];
    for (var g = 0, u = h.length, b = new Array(u); g < u; g++)
      b[g] = h[g].fn;
    return b;
  }, c.prototype.listenerCount = function(p) {
    var d = r ? r + p : p, h = this._events[d];
    return h ? h.fn ? 1 : h.length : 0;
  }, c.prototype.emit = function(p, d, h, g, u, b) {
    var x = r ? r + p : p;
    if (!this._events[x]) return !1;
    var A = this._events[x], I = arguments.length, U, S;
    if (A.fn) {
      switch (A.once && this.removeListener(p, A.fn, void 0, !0), I) {
        case 1:
          return A.fn.call(A.context), !0;
        case 2:
          return A.fn.call(A.context, d), !0;
        case 3:
          return A.fn.call(A.context, d, h), !0;
        case 4:
          return A.fn.call(A.context, d, h, g), !0;
        case 5:
          return A.fn.call(A.context, d, h, g, u), !0;
        case 6:
          return A.fn.call(A.context, d, h, g, u, b), !0;
      }
      for (S = 1, U = new Array(I - 1); S < I; S++)
        U[S - 1] = arguments[S];
      A.fn.apply(A.context, U);
    } else {
      var B = A.length, R;
      for (S = 0; S < B; S++)
        switch (A[S].once && this.removeListener(p, A[S].fn, void 0, !0), I) {
          case 1:
            A[S].fn.call(A[S].context);
            break;
          case 2:
            A[S].fn.call(A[S].context, d);
            break;
          case 3:
            A[S].fn.call(A[S].context, d, h);
            break;
          case 4:
            A[S].fn.call(A[S].context, d, h, g);
            break;
          default:
            if (!U) for (R = 1, U = new Array(I - 1); R < I; R++)
              U[R - 1] = arguments[R];
            A[S].fn.apply(A[S].context, U);
        }
    }
    return !0;
  }, c.prototype.on = function(p, d, h) {
    return o(this, p, d, h, !1);
  }, c.prototype.once = function(p, d, h) {
    return o(this, p, d, h, !0);
  }, c.prototype.removeListener = function(p, d, h, g) {
    var u = r ? r + p : p;
    if (!this._events[u]) return this;
    if (!d)
      return i(this, u), this;
    var b = this._events[u];
    if (b.fn)
      b.fn === d && (!g || b.once) && (!h || b.context === h) && i(this, u);
    else {
      for (var x = 0, A = [], I = b.length; x < I; x++)
        (b[x].fn !== d || g && !b[x].once || h && b[x].context !== h) && A.push(b[x]);
      A.length ? this._events[u] = A.length === 1 ? A[0] : A : i(this, u);
    }
    return this;
  }, c.prototype.removeAllListeners = function(p) {
    var d;
    return p ? (d = r ? r + p : p, this._events[d] && i(this, d)) : (this._events = new n(), this._eventsCount = 0), this;
  }, c.prototype.off = c.prototype.removeListener, c.prototype.addListener = c.prototype.on, c.prefixed = r, c.EventEmitter = c, e.exports = c;
})(Gt);
var Lr = Gt.exports;
const Pr = /* @__PURE__ */ Ke(Lr);
var Se = {}, he = {}, q = {};
Object.defineProperty(q, "__esModule", { value: !0 });
q.output = q.exists = q.hash = q.bytes = q.bool = q.number = q.isBytes = void 0;
function Le(e) {
  if (!Number.isSafeInteger(e) || e < 0)
    throw new Error(`positive integer expected, not ${e}`);
}
q.number = Le;
function Xt(e) {
  if (typeof e != "boolean")
    throw new Error(`boolean expected, not ${e}`);
}
q.bool = Xt;
function qt(e) {
  return e instanceof Uint8Array || e != null && typeof e == "object" && e.constructor.name === "Uint8Array";
}
q.isBytes = qt;
function xt(e, ...t) {
  if (!qt(e))
    throw new Error("Uint8Array expected");
  if (t.length > 0 && !t.includes(e.length))
    throw new Error(`Uint8Array expected of length ${t}, not of length=${e.length}`);
}
q.bytes = xt;
function Zt(e) {
  if (typeof e != "function" || typeof e.create != "function")
    throw new Error("Hash should be wrapped by utils.wrapConstructor");
  Le(e.outputLen), Le(e.blockLen);
}
q.hash = Zt;
function Yt(e, t = !0) {
  if (e.destroyed)
    throw new Error("Hash instance has been destroyed");
  if (t && e.finished)
    throw new Error("Hash#digest() has already been called");
}
q.exists = Yt;
function Qt(e, t) {
  xt(e);
  const r = t.outputLen;
  if (e.length < r)
    throw new Error(`digestInto() expects output buffer of length at least ${r}`);
}
q.output = Qt;
const Vr = { number: Le, bool: Xt, bytes: xt, hash: Zt, exists: Yt, output: Qt };
q.default = Vr;
var wt = {}, We = {};
Object.defineProperty(We, "__esModule", { value: !0 });
We.crypto = void 0;
We.crypto = typeof globalThis == "object" && "crypto" in globalThis ? globalThis.crypto : void 0;
(function(e) {
  /*! noble-hashes - MIT License (c) 2022 Paul Miller (paulmillr.com) */
  Object.defineProperty(e, "__esModule", { value: !0 }), e.randomBytes = e.wrapXOFConstructorWithOpts = e.wrapConstructorWithOpts = e.wrapConstructor = e.checkOpts = e.Hash = e.concatBytes = e.toBytes = e.utf8ToBytes = e.asyncLoop = e.nextTick = e.hexToBytes = e.bytesToHex = e.byteSwap32 = e.byteSwapIfBE = e.byteSwap = e.isLE = e.rotl = e.rotr = e.createView = e.u32 = e.u8 = e.isBytes = void 0;
  const t = We, r = q;
  function n(E) {
    return E instanceof Uint8Array || E != null && typeof E == "object" && E.constructor.name === "Uint8Array";
  }
  e.isBytes = n;
  const s = (E) => new Uint8Array(E.buffer, E.byteOffset, E.byteLength);
  e.u8 = s;
  const o = (E) => new Uint32Array(E.buffer, E.byteOffset, Math.floor(E.byteLength / 4));
  e.u32 = o;
  const i = (E) => new DataView(E.buffer, E.byteOffset, E.byteLength);
  e.createView = i;
  const c = (E, l) => E << 32 - l | E >>> l;
  e.rotr = c;
  const a = (E, l) => E << l | E >>> 32 - l >>> 0;
  e.rotl = a, e.isLE = new Uint8Array(new Uint32Array([287454020]).buffer)[0] === 68;
  const p = (E) => E << 24 & 4278190080 | E << 8 & 16711680 | E >>> 8 & 65280 | E >>> 24 & 255;
  e.byteSwap = p, e.byteSwapIfBE = e.isLE ? (E) => E : (E) => (0, e.byteSwap)(E);
  function d(E) {
    for (let l = 0; l < E.length; l++)
      E[l] = (0, e.byteSwap)(E[l]);
  }
  e.byteSwap32 = d;
  const h = /* @__PURE__ */ Array.from({ length: 256 }, (E, l) => l.toString(16).padStart(2, "0"));
  function g(E) {
    (0, r.bytes)(E);
    let l = "";
    for (let _ = 0; _ < E.length; _++)
      l += h[E[_]];
    return l;
  }
  e.bytesToHex = g;
  const u = { _0: 48, _9: 57, _A: 65, _F: 70, _a: 97, _f: 102 };
  function b(E) {
    if (E >= u._0 && E <= u._9)
      return E - u._0;
    if (E >= u._A && E <= u._F)
      return E - (u._A - 10);
    if (E >= u._a && E <= u._f)
      return E - (u._a - 10);
  }
  function x(E) {
    if (typeof E != "string")
      throw new Error("hex string expected, got " + typeof E);
    const l = E.length, _ = l / 2;
    if (l % 2)
      throw new Error("padded hex string expected, got unpadded hex of length " + l);
    const m = new Uint8Array(_);
    for (let C = 0, v = 0; C < _; C++, v += 2) {
      const j = b(E.charCodeAt(v)), k = b(E.charCodeAt(v + 1));
      if (j === void 0 || k === void 0) {
        const M = E[v] + E[v + 1];
        throw new Error('hex string expected, got non-hex character "' + M + '" at index ' + v);
      }
      m[C] = j * 16 + k;
    }
    return m;
  }
  e.hexToBytes = x;
  const A = async () => {
  };
  e.nextTick = A;
  async function I(E, l, _) {
    let m = Date.now();
    for (let C = 0; C < E; C++) {
      _(C);
      const v = Date.now() - m;
      v >= 0 && v < l || (await (0, e.nextTick)(), m += v);
    }
  }
  e.asyncLoop = I;
  function U(E) {
    if (typeof E != "string")
      throw new Error(`utf8ToBytes expected string, got ${typeof E}`);
    return new Uint8Array(new TextEncoder().encode(E));
  }
  e.utf8ToBytes = U;
  function S(E) {
    return typeof E == "string" && (E = U(E)), (0, r.bytes)(E), E;
  }
  e.toBytes = S;
  function B(...E) {
    let l = 0;
    for (let m = 0; m < E.length; m++) {
      const C = E[m];
      (0, r.bytes)(C), l += C.length;
    }
    const _ = new Uint8Array(l);
    for (let m = 0, C = 0; m < E.length; m++) {
      const v = E[m];
      _.set(v, C), C += v.length;
    }
    return _;
  }
  e.concatBytes = B;
  class R {
    // Safe version that clones internal state
    clone() {
      return this._cloneInto();
    }
  }
  e.Hash = R;
  const F = {}.toString;
  function N(E, l) {
    if (l !== void 0 && F.call(l) !== "[object Object]")
      throw new Error("Options should be object or undefined");
    return Object.assign(E, l);
  }
  e.checkOpts = N;
  function L(E) {
    const l = (m) => E().update(S(m)).digest(), _ = E();
    return l.outputLen = _.outputLen, l.blockLen = _.blockLen, l.create = () => E(), l;
  }
  e.wrapConstructor = L;
  function $(E) {
    const l = (m, C) => E(C).update(S(m)).digest(), _ = E({});
    return l.outputLen = _.outputLen, l.blockLen = _.blockLen, l.create = (m) => E(m), l;
  }
  e.wrapConstructorWithOpts = $;
  function H(E) {
    const l = (m, C) => E(C).update(S(m)).digest(), _ = E({});
    return l.outputLen = _.outputLen, l.blockLen = _.blockLen, l.create = (m) => E(m), l;
  }
  e.wrapXOFConstructorWithOpts = H;
  function ie(E = 32) {
    if (t.crypto && typeof t.crypto.getRandomValues == "function")
      return t.crypto.getRandomValues(new Uint8Array(E));
    throw new Error("crypto.getRandomValues must be defined");
  }
  e.randomBytes = ie;
})(wt);
Object.defineProperty(he, "__esModule", { value: !0 });
he.HashMD = he.Maj = he.Chi = void 0;
const qe = q, Ae = wt;
function Nr(e, t, r, n) {
  if (typeof e.setBigUint64 == "function")
    return e.setBigUint64(t, r, n);
  const s = BigInt(32), o = BigInt(4294967295), i = Number(r >> s & o), c = Number(r & o), a = n ? 4 : 0, p = n ? 0 : 4;
  e.setUint32(t + a, i, n), e.setUint32(t + p, c, n);
}
const Hr = (e, t, r) => e & t ^ ~e & r;
he.Chi = Hr;
const $r = (e, t, r) => e & t ^ e & r ^ t & r;
he.Maj = $r;
class zr extends Ae.Hash {
  constructor(t, r, n, s) {
    super(), this.blockLen = t, this.outputLen = r, this.padOffset = n, this.isLE = s, this.finished = !1, this.length = 0, this.pos = 0, this.destroyed = !1, this.buffer = new Uint8Array(t), this.view = (0, Ae.createView)(this.buffer);
  }
  update(t) {
    (0, qe.exists)(this);
    const { view: r, buffer: n, blockLen: s } = this;
    t = (0, Ae.toBytes)(t);
    const o = t.length;
    for (let i = 0; i < o; ) {
      const c = Math.min(s - this.pos, o - i);
      if (c === s) {
        const a = (0, Ae.createView)(t);
        for (; s <= o - i; i += s)
          this.process(a, i);
        continue;
      }
      n.set(t.subarray(i, i + c), this.pos), this.pos += c, i += c, this.pos === s && (this.process(r, 0), this.pos = 0);
    }
    return this.length += t.length, this.roundClean(), this;
  }
  digestInto(t) {
    (0, qe.exists)(this), (0, qe.output)(t, this), this.finished = !0;
    const { buffer: r, view: n, blockLen: s, isLE: o } = this;
    let { pos: i } = this;
    r[i++] = 128, this.buffer.subarray(i).fill(0), this.padOffset > s - i && (this.process(n, 0), i = 0);
    for (let h = i; h < s; h++)
      r[h] = 0;
    Nr(n, s - 8, BigInt(this.length * 8), o), this.process(n, 0);
    const c = (0, Ae.createView)(t), a = this.outputLen;
    if (a % 4)
      throw new Error("_sha2: outputLen should be aligned to 32bit");
    const p = a / 4, d = this.get();
    if (p > d.length)
      throw new Error("_sha2: outputLen bigger than state");
    for (let h = 0; h < p; h++)
      c.setUint32(4 * h, d[h], o);
  }
  digest() {
    const { buffer: t, outputLen: r } = this;
    this.digestInto(t);
    const n = t.slice(0, r);
    return this.destroy(), n;
  }
  _cloneInto(t) {
    t || (t = new this.constructor()), t.set(...this.get());
    const { blockLen: r, buffer: n, length: s, finished: o, destroyed: i, pos: c } = this;
    return t.length = s, t.pos = c, t.finished = o, t.destroyed = i, s % r && t.buffer.set(n), t;
  }
}
he.HashMD = zr;
Object.defineProperty(Se, "__esModule", { value: !0 });
Se.sha224 = Se.sha256 = void 0;
const Ze = he, te = wt, Kr = /* @__PURE__ */ new Uint32Array([
  1116352408,
  1899447441,
  3049323471,
  3921009573,
  961987163,
  1508970993,
  2453635748,
  2870763221,
  3624381080,
  310598401,
  607225278,
  1426881987,
  1925078388,
  2162078206,
  2614888103,
  3248222580,
  3835390401,
  4022224774,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  2554220882,
  2821834349,
  2952996808,
  3210313671,
  3336571891,
  3584528711,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  2177026350,
  2456956037,
  2730485921,
  2820302411,
  3259730800,
  3345764771,
  3516065817,
  3600352804,
  4094571909,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  2227730452,
  2361852424,
  2428436474,
  2756734187,
  3204031479,
  3329325298
]), ce = /* @__PURE__ */ new Uint32Array([
  1779033703,
  3144134277,
  1013904242,
  2773480762,
  1359893119,
  2600822924,
  528734635,
  1541459225
]), le = /* @__PURE__ */ new Uint32Array(64);
class er extends Ze.HashMD {
  constructor() {
    super(64, 32, 8, !1), this.A = ce[0] | 0, this.B = ce[1] | 0, this.C = ce[2] | 0, this.D = ce[3] | 0, this.E = ce[4] | 0, this.F = ce[5] | 0, this.G = ce[6] | 0, this.H = ce[7] | 0;
  }
  get() {
    const { A: t, B: r, C: n, D: s, E: o, F: i, G: c, H: a } = this;
    return [t, r, n, s, o, i, c, a];
  }
  // prettier-ignore
  set(t, r, n, s, o, i, c, a) {
    this.A = t | 0, this.B = r | 0, this.C = n | 0, this.D = s | 0, this.E = o | 0, this.F = i | 0, this.G = c | 0, this.H = a | 0;
  }
  process(t, r) {
    for (let h = 0; h < 16; h++, r += 4)
      le[h] = t.getUint32(r, !1);
    for (let h = 16; h < 64; h++) {
      const g = le[h - 15], u = le[h - 2], b = (0, te.rotr)(g, 7) ^ (0, te.rotr)(g, 18) ^ g >>> 3, x = (0, te.rotr)(u, 17) ^ (0, te.rotr)(u, 19) ^ u >>> 10;
      le[h] = x + le[h - 7] + b + le[h - 16] | 0;
    }
    let { A: n, B: s, C: o, D: i, E: c, F: a, G: p, H: d } = this;
    for (let h = 0; h < 64; h++) {
      const g = (0, te.rotr)(c, 6) ^ (0, te.rotr)(c, 11) ^ (0, te.rotr)(c, 25), u = d + g + (0, Ze.Chi)(c, a, p) + Kr[h] + le[h] | 0, x = ((0, te.rotr)(n, 2) ^ (0, te.rotr)(n, 13) ^ (0, te.rotr)(n, 22)) + (0, Ze.Maj)(n, s, o) | 0;
      d = p, p = a, a = c, c = i + u | 0, i = o, o = s, s = n, n = u + x | 0;
    }
    n = n + this.A | 0, s = s + this.B | 0, o = o + this.C | 0, i = i + this.D | 0, c = c + this.E | 0, a = a + this.F | 0, p = p + this.G | 0, d = d + this.H | 0, this.set(n, s, o, i, c, a, p, d);
  }
  roundClean() {
    le.fill(0);
  }
  destroy() {
    this.set(0, 0, 0, 0, 0, 0, 0, 0), this.buffer.fill(0);
  }
}
class Wr extends er {
  constructor() {
    super(), this.A = -1056596264, this.B = 914150663, this.C = 812702999, this.D = -150054599, this.E = -4191439, this.F = 1750603025, this.G = 1694076839, this.H = -1090891868, this.outputLen = 28;
  }
}
Se.sha256 = (0, te.wrapConstructor)(() => new er());
Se.sha224 = (0, te.wrapConstructor)(() => new Wr());
function Jr(e) {
  if (e.length >= 255)
    throw new TypeError("Alphabet too long");
  for (var t = new Uint8Array(256), r = 0; r < t.length; r++)
    t[r] = 255;
  for (var n = 0; n < e.length; n++) {
    var s = e.charAt(n), o = s.charCodeAt(0);
    if (t[o] !== 255)
      throw new TypeError(s + " is ambiguous");
    t[o] = n;
  }
  var i = e.length, c = e.charAt(0), a = Math.log(i) / Math.log(256), p = Math.log(256) / Math.log(i);
  function d(u) {
    if (u instanceof Uint8Array || (ArrayBuffer.isView(u) ? u = new Uint8Array(u.buffer, u.byteOffset, u.byteLength) : Array.isArray(u) && (u = Uint8Array.from(u))), !(u instanceof Uint8Array))
      throw new TypeError("Expected Uint8Array");
    if (u.length === 0)
      return "";
    for (var b = 0, x = 0, A = 0, I = u.length; A !== I && u[A] === 0; )
      A++, b++;
    for (var U = (I - A) * p + 1 >>> 0, S = new Uint8Array(U); A !== I; ) {
      for (var B = u[A], R = 0, F = U - 1; (B !== 0 || R < x) && F !== -1; F--, R++)
        B += 256 * S[F] >>> 0, S[F] = B % i >>> 0, B = B / i >>> 0;
      if (B !== 0)
        throw new Error("Non-zero carry");
      x = R, A++;
    }
    for (var N = U - x; N !== U && S[N] === 0; )
      N++;
    for (var L = c.repeat(b); N < U; ++N)
      L += e.charAt(S[N]);
    return L;
  }
  function h(u) {
    if (typeof u != "string")
      throw new TypeError("Expected String");
    if (u.length === 0)
      return new Uint8Array();
    for (var b = 0, x = 0, A = 0; u[b] === c; )
      x++, b++;
    for (var I = (u.length - b) * a + 1 >>> 0, U = new Uint8Array(I); u[b]; ) {
      var S = t[u.charCodeAt(b)];
      if (S === 255)
        return;
      for (var B = 0, R = I - 1; (S !== 0 || B < A) && R !== -1; R--, B++)
        S += i * U[R] >>> 0, U[R] = S % 256 >>> 0, S = S / 256 >>> 0;
      if (S !== 0)
        throw new Error("Non-zero carry");
      A = B, b++;
    }
    for (var F = I - A; F !== I && U[F] === 0; )
      F++;
    for (var N = new Uint8Array(x + (I - F)), L = x; F !== I; )
      N[L++] = U[F++];
    return N;
  }
  function g(u) {
    var b = h(u);
    if (b)
      return b;
    throw new Error("Non-base" + i + " character");
  }
  return {
    encode: d,
    decodeUnsafe: h,
    decode: g
  };
}
var Gr = Jr;
const Xr = Gr, qr = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
var Zr = Xr(qr), Ye = Zr, Yr = function(e) {
  function t(o) {
    var i = Uint8Array.from(o), c = e(i), a = i.length + 4, p = new Uint8Array(a);
    return p.set(i, 0), p.set(c.subarray(0, 4), i.length), Ye.encode(p, a);
  }
  function r(o) {
    var i = o.slice(0, -4), c = o.slice(-4), a = e(i);
    if (!(c[0] ^ a[0] | c[1] ^ a[1] | c[2] ^ a[2] | c[3] ^ a[3]))
      return i;
  }
  function n(o) {
    var i = Ye.decodeUnsafe(o);
    if (i)
      return r(i);
  }
  function s(o) {
    var i = Ye.decode(o), c = r(i);
    if (!c) throw new Error("Invalid checksum");
    return c;
  }
  return {
    encode: t,
    decode: s,
    decodeUnsafe: n
  };
}, { sha256: Ot } = Se, Qr = Yr;
function en(e) {
  return Ot(Ot(e));
}
var tn = Qr(en);
const rn = /* @__PURE__ */ Ke(tn), tr = "automerge:", rr = (e) => {
  const t = new RegExp(`^${tr}(\\w+)$`), [, r] = e.match(t) || [], n = r, s = nr(n);
  if (!s)
    throw new Error("Invalid document URL: " + e);
  return {
    /** unencoded DocumentId */
    binaryDocumentId: s,
    /** encoded DocumentId */
    documentId: n
  };
}, nn = (e) => {
  if (!e || !e.startsWith(tr))
    return !1;
  const t = e;
  try {
    const { documentId: r } = rr(t);
    return sn(r);
  } catch {
    return !1;
  }
}, sn = (e) => {
  const t = nr(e);
  if (t === void 0)
    return !1;
  const r = Fr(t);
  return Kt(r);
}, nr = (e) => rn.decodeUnsafe(e);
let it;
try {
  it = new TextDecoder();
} catch {
}
let O, be, w = 0;
const on = 105, fn = 57342, an = 57343, It = 57337, Ut = 6, we = {};
let D = {}, K, Pe, Ve = 0, Ie = 0, G, ne, W = [], ot = [], Q, Y, Ce, Ft = {
  useRecords: !1,
  mapsAsObjects: !0
}, Ue = !1, sr = 2;
try {
  new Function("");
} catch {
  sr = 1 / 0;
}
class Fe {
  constructor(t) {
    if (t && ((t.keyMap || t._keyMap) && !t.useRecords && (t.useRecords = !1, t.mapsAsObjects = !0), t.useRecords === !1 && t.mapsAsObjects === void 0 && (t.mapsAsObjects = !0), t.getStructures && (t.getShared = t.getStructures), t.getShared && !t.structures && ((t.structures = []).uninitialized = !0), t.keyMap)) {
      this.mapKey = /* @__PURE__ */ new Map();
      for (let [r, n] of Object.entries(t.keyMap)) this.mapKey.set(n, r);
    }
    Object.assign(this, t);
  }
  /*
  decodeKey(key) {
  	return this.keyMap
  		? Object.keys(this.keyMap)[Object.values(this.keyMap).indexOf(key)] || key
  		: key
  }
  */
  decodeKey(t) {
    return this.keyMap && this.mapKey.get(t) || t;
  }
  encodeKey(t) {
    return this.keyMap && this.keyMap.hasOwnProperty(t) ? this.keyMap[t] : t;
  }
  encodeKeys(t) {
    if (!this._keyMap) return t;
    let r = /* @__PURE__ */ new Map();
    for (let [n, s] of Object.entries(t)) r.set(this._keyMap.hasOwnProperty(n) ? this._keyMap[n] : n, s);
    return r;
  }
  decodeKeys(t) {
    if (!this._keyMap || t.constructor.name != "Map") return t;
    if (!this._mapKey) {
      this._mapKey = /* @__PURE__ */ new Map();
      for (let [n, s] of Object.entries(this._keyMap)) this._mapKey.set(s, n);
    }
    let r = {};
    return t.forEach((n, s) => r[se(this._mapKey.has(s) ? this._mapKey.get(s) : s)] = n), r;
  }
  mapDecode(t, r) {
    let n = this.decode(t);
    if (this._keyMap)
      switch (n.constructor.name) {
        case "Array":
          return n.map((s) => this.decodeKeys(s));
      }
    return n;
  }
  decode(t, r) {
    if (O)
      return ar(() => (lt(), this ? this.decode(t, r) : Fe.prototype.decode.call(Ft, t, r)));
    be = r > -1 ? r : t.length, w = 0, Ie = 0, Pe = null, G = null, O = t;
    try {
      Y = t.dataView || (t.dataView = new DataView(t.buffer, t.byteOffset, t.byteLength));
    } catch (n) {
      throw O = null, t instanceof Uint8Array ? n : new Error("Source must be a Uint8Array or Buffer but was a " + (t && typeof t == "object" ? t.constructor.name : typeof t));
    }
    if (this instanceof Fe) {
      if (D = this, Q = this.sharedValues && (this.pack ? new Array(this.maxPrivatePackedValues || 16).concat(this.sharedValues) : this.sharedValues), this.structures)
        return K = this.structures, ke();
      (!K || K.length > 0) && (K = []);
    } else
      D = Ft, (!K || K.length > 0) && (K = []), Q = null;
    return ke();
  }
  decodeMultiple(t, r) {
    let n, s = 0;
    try {
      let o = t.length;
      Ue = !0;
      let i = this ? this.decode(t, o) : St.decode(t, o);
      if (r) {
        if (r(i) === !1)
          return;
        for (; w < o; )
          if (s = w, r(ke()) === !1)
            return;
      } else {
        for (n = [i]; w < o; )
          s = w, n.push(ke());
        return n;
      }
    } catch (o) {
      throw o.lastPosition = s, o.values = n, o;
    } finally {
      Ue = !1, lt();
    }
  }
}
function ke() {
  try {
    let e = P();
    if (G) {
      if (w >= G.postBundlePosition) {
        let t = new Error("Unexpected bundle position");
        throw t.incomplete = !0, t;
      }
      w = G.postBundlePosition, G = null;
    }
    if (w == be)
      K = null, O = null, ne && (ne = null);
    else if (w > be) {
      let t = new Error("Unexpected end of CBOR data");
      throw t.incomplete = !0, t;
    } else if (!Ue)
      throw new Error("Data read, but end of buffer not reached");
    return e;
  } catch (e) {
    throw lt(), (e instanceof RangeError || e.message.startsWith("Unexpected end of buffer")) && (e.incomplete = !0), e;
  }
}
function P() {
  let e = O[w++], t = e >> 5;
  if (e = e & 31, e > 23)
    switch (e) {
      case 24:
        e = O[w++];
        break;
      case 25:
        if (t == 7)
          return hn();
        e = Y.getUint16(w), w += 2;
        break;
      case 26:
        if (t == 7) {
          let r = Y.getFloat32(w);
          if (D.useFloat32 > 2) {
            let n = vt[(O[w] & 127) << 1 | O[w + 1] >> 7];
            return w += 4, (n * r + (r > 0 ? 0.5 : -0.5) >> 0) / n;
          }
          return w += 4, r;
        }
        e = Y.getUint32(w), w += 4;
        break;
      case 27:
        if (t == 7) {
          let r = Y.getFloat64(w);
          return w += 8, r;
        }
        if (t > 1) {
          if (Y.getUint32(w) > 0)
            throw new Error("JavaScript does not support arrays, maps, or strings with length over 4294967295");
          e = Y.getUint32(w + 4);
        } else D.int64AsNumber ? (e = Y.getUint32(w) * 4294967296, e += Y.getUint32(w + 4)) : e = Y.getBigUint64(w);
        w += 8;
        break;
      case 31:
        switch (t) {
          case 2:
          case 3:
            throw new Error("Indefinite length not supported for byte or text strings");
          case 4:
            let r = [], n, s = 0;
            for (; (n = P()) != we; )
              r[s++] = n;
            return t == 4 ? r : t == 3 ? r.join("") : Buffer.concat(r);
          case 5:
            let o;
            if (D.mapsAsObjects) {
              let i = {};
              if (D.keyMap) for (; (o = P()) != we; ) i[se(D.decodeKey(o))] = P();
              else for (; (o = P()) != we; ) i[se(o)] = P();
              return i;
            } else {
              Ce && (D.mapsAsObjects = !0, Ce = !1);
              let i = /* @__PURE__ */ new Map();
              if (D.keyMap) for (; (o = P()) != we; ) i.set(D.decodeKey(o), P());
              else for (; (o = P()) != we; ) i.set(o, P());
              return i;
            }
          case 7:
            return we;
          default:
            throw new Error("Invalid major type for indefinite length " + t);
        }
      default:
        throw new Error("Unknown token " + e);
    }
  switch (t) {
    case 0:
      return e;
    case 1:
      return ~e;
    case 2:
      return un(e);
    case 3:
      if (Ie >= w)
        return Pe.slice(w - Ve, (w += e) - Ve);
      if (Ie == 0 && be < 140 && e < 32) {
        let s = e < 16 ? ir(e) : ln(e);
        if (s != null)
          return s;
      }
      return cn(e);
    case 4:
      let r = new Array(e);
      for (let s = 0; s < e; s++) r[s] = P();
      return r;
    case 5:
      if (D.mapsAsObjects) {
        let s = {};
        if (D.keyMap) for (let o = 0; o < e; o++) s[se(D.decodeKey(P()))] = P();
        else for (let o = 0; o < e; o++) s[se(P())] = P();
        return s;
      } else {
        Ce && (D.mapsAsObjects = !0, Ce = !1);
        let s = /* @__PURE__ */ new Map();
        if (D.keyMap) for (let o = 0; o < e; o++) s.set(D.decodeKey(P()), P());
        else for (let o = 0; o < e; o++) s.set(P(), P());
        return s;
      }
    case 6:
      if (e >= It) {
        let s = K[e & 8191];
        if (s)
          return s.read || (s.read = ft(s)), s.read();
        if (e < 65536) {
          if (e == an) {
            let o = ve(), i = P(), c = P();
            ct(i, c);
            let a = {};
            if (D.keyMap) for (let p = 2; p < o; p++) {
              let d = D.decodeKey(c[p - 2]);
              a[se(d)] = P();
            }
            else for (let p = 2; p < o; p++) {
              let d = c[p - 2];
              a[se(d)] = P();
            }
            return a;
          } else if (e == fn) {
            let o = ve(), i = P();
            for (let c = 2; c < o; c++)
              ct(i++, P());
            return P();
          } else if (e == It)
            return xn();
          if (D.getShared && (mt(), s = K[e & 8191], s))
            return s.read || (s.read = ft(s)), s.read();
        }
      }
      let n = W[e];
      if (n)
        return n.handlesRead ? n(P) : n(P());
      {
        let s = P();
        for (let o = 0; o < ot.length; o++) {
          let i = ot[o](e, s);
          if (i !== void 0)
            return i;
        }
        return new xe(s, e);
      }
    case 7:
      switch (e) {
        case 20:
          return !1;
        case 21:
          return !0;
        case 22:
          return null;
        case 23:
          return;
        case 31:
        default:
          let s = (Q || de())[e];
          if (s !== void 0)
            return s;
          throw new Error("Unknown token " + e);
      }
    default:
      if (isNaN(e)) {
        let s = new Error("Unexpected end of CBOR data");
        throw s.incomplete = !0, s;
      }
      throw new Error("Unknown CBOR token " + e);
  }
}
const jt = /^[a-zA-Z_$][a-zA-Z\d_$]*$/;
function ft(e) {
  function t() {
    let r = O[w++];
    if (r = r & 31, r > 23)
      switch (r) {
        case 24:
          r = O[w++];
          break;
        case 25:
          r = Y.getUint16(w), w += 2;
          break;
        case 26:
          r = Y.getUint32(w), w += 4;
          break;
        default:
          throw new Error("Expected array header, but got " + O[w - 1]);
      }
    let n = this.compiledReader;
    for (; n; ) {
      if (n.propertyCount === r)
        return n(P);
      n = n.next;
    }
    if (this.slowReads++ >= sr) {
      let o = this.length == r ? this : this.slice(0, r);
      return n = D.keyMap ? new Function("r", "return {" + o.map((i) => D.decodeKey(i)).map((i) => jt.test(i) ? se(i) + ":r()" : "[" + JSON.stringify(i) + "]:r()").join(",") + "}") : new Function("r", "return {" + o.map((i) => jt.test(i) ? se(i) + ":r()" : "[" + JSON.stringify(i) + "]:r()").join(",") + "}"), this.compiledReader && (n.next = this.compiledReader), n.propertyCount = r, this.compiledReader = n, n(P);
    }
    let s = {};
    if (D.keyMap) for (let o = 0; o < r; o++) s[se(D.decodeKey(this[o]))] = P();
    else for (let o = 0; o < r; o++)
      s[se(this[o])] = P();
    return s;
  }
  return e.slowReads = 0, t;
}
function se(e) {
  if (typeof e == "string") return e === "__proto__" ? "__proto_" : e;
  if (typeof e == "number" || typeof e == "boolean" || typeof e == "bigint") return e.toString();
  if (e == null) return e + "";
  throw new Error("Invalid property name type " + typeof e);
}
let cn = at;
function at(e) {
  let t;
  if (e < 16 && (t = ir(e)))
    return t;
  if (e > 64 && it)
    return it.decode(O.subarray(w, w += e));
  const r = w + e, n = [];
  for (t = ""; w < r; ) {
    const s = O[w++];
    if (!(s & 128))
      n.push(s);
    else if ((s & 224) === 192) {
      const o = O[w++] & 63;
      n.push((s & 31) << 6 | o);
    } else if ((s & 240) === 224) {
      const o = O[w++] & 63, i = O[w++] & 63;
      n.push((s & 31) << 12 | o << 6 | i);
    } else if ((s & 248) === 240) {
      const o = O[w++] & 63, i = O[w++] & 63, c = O[w++] & 63;
      let a = (s & 7) << 18 | o << 12 | i << 6 | c;
      a > 65535 && (a -= 65536, n.push(a >>> 10 & 1023 | 55296), a = 56320 | a & 1023), n.push(a);
    } else
      n.push(s);
    n.length >= 4096 && (t += X.apply(String, n), n.length = 0);
  }
  return n.length > 0 && (t += X.apply(String, n)), t;
}
let X = String.fromCharCode;
function ln(e) {
  let t = w, r = new Array(e);
  for (let n = 0; n < e; n++) {
    const s = O[w++];
    if ((s & 128) > 0) {
      w = t;
      return;
    }
    r[n] = s;
  }
  return X.apply(String, r);
}
function ir(e) {
  if (e < 4)
    if (e < 2) {
      if (e === 0)
        return "";
      {
        let t = O[w++];
        if ((t & 128) > 1) {
          w -= 1;
          return;
        }
        return X(t);
      }
    } else {
      let t = O[w++], r = O[w++];
      if ((t & 128) > 0 || (r & 128) > 0) {
        w -= 2;
        return;
      }
      if (e < 3)
        return X(t, r);
      let n = O[w++];
      if ((n & 128) > 0) {
        w -= 3;
        return;
      }
      return X(t, r, n);
    }
  else {
    let t = O[w++], r = O[w++], n = O[w++], s = O[w++];
    if ((t & 128) > 0 || (r & 128) > 0 || (n & 128) > 0 || (s & 128) > 0) {
      w -= 4;
      return;
    }
    if (e < 6) {
      if (e === 4)
        return X(t, r, n, s);
      {
        let o = O[w++];
        if ((o & 128) > 0) {
          w -= 5;
          return;
        }
        return X(t, r, n, s, o);
      }
    } else if (e < 8) {
      let o = O[w++], i = O[w++];
      if ((o & 128) > 0 || (i & 128) > 0) {
        w -= 6;
        return;
      }
      if (e < 7)
        return X(t, r, n, s, o, i);
      let c = O[w++];
      if ((c & 128) > 0) {
        w -= 7;
        return;
      }
      return X(t, r, n, s, o, i, c);
    } else {
      let o = O[w++], i = O[w++], c = O[w++], a = O[w++];
      if ((o & 128) > 0 || (i & 128) > 0 || (c & 128) > 0 || (a & 128) > 0) {
        w -= 8;
        return;
      }
      if (e < 10) {
        if (e === 8)
          return X(t, r, n, s, o, i, c, a);
        {
          let p = O[w++];
          if ((p & 128) > 0) {
            w -= 9;
            return;
          }
          return X(t, r, n, s, o, i, c, a, p);
        }
      } else if (e < 12) {
        let p = O[w++], d = O[w++];
        if ((p & 128) > 0 || (d & 128) > 0) {
          w -= 10;
          return;
        }
        if (e < 11)
          return X(t, r, n, s, o, i, c, a, p, d);
        let h = O[w++];
        if ((h & 128) > 0) {
          w -= 11;
          return;
        }
        return X(t, r, n, s, o, i, c, a, p, d, h);
      } else {
        let p = O[w++], d = O[w++], h = O[w++], g = O[w++];
        if ((p & 128) > 0 || (d & 128) > 0 || (h & 128) > 0 || (g & 128) > 0) {
          w -= 12;
          return;
        }
        if (e < 14) {
          if (e === 12)
            return X(t, r, n, s, o, i, c, a, p, d, h, g);
          {
            let u = O[w++];
            if ((u & 128) > 0) {
              w -= 13;
              return;
            }
            return X(t, r, n, s, o, i, c, a, p, d, h, g, u);
          }
        } else {
          let u = O[w++], b = O[w++];
          if ((u & 128) > 0 || (b & 128) > 0) {
            w -= 14;
            return;
          }
          if (e < 15)
            return X(t, r, n, s, o, i, c, a, p, d, h, g, u, b);
          let x = O[w++];
          if ((x & 128) > 0) {
            w -= 15;
            return;
          }
          return X(t, r, n, s, o, i, c, a, p, d, h, g, u, b, x);
        }
      }
    }
  }
}
function un(e) {
  return D.copyBuffers ? (
    // specifically use the copying slice (not the node one)
    Uint8Array.prototype.slice.call(O, w, w += e)
  ) : O.subarray(w, w += e);
}
let or = new Float32Array(1), Re = new Uint8Array(or.buffer, 0, 4);
function hn() {
  let e = O[w++], t = O[w++], r = (e & 127) >> 2;
  if (r === 31)
    return t || e & 3 ? NaN : e & 128 ? -1 / 0 : 1 / 0;
  if (r === 0) {
    let n = ((e & 3) << 8 | t) / 16777216;
    return e & 128 ? -n : n;
  }
  return Re[3] = e & 128 | // sign bit
  (r >> 1) + 56, Re[2] = (e & 7) << 5 | // last exponent bit and first two mantissa bits
  t >> 3, Re[1] = t << 5, Re[0] = 0, or[0];
}
new Array(4096);
class xe {
  constructor(t, r) {
    this.value = t, this.tag = r;
  }
}
W[0] = (e) => new Date(e);
W[1] = (e) => new Date(Math.round(e * 1e3));
W[2] = (e) => {
  let t = BigInt(0);
  for (let r = 0, n = e.byteLength; r < n; r++)
    t = BigInt(e[r]) + t << BigInt(8);
  return t;
};
W[3] = (e) => BigInt(-1) - W[2](e);
W[4] = (e) => +(e[1] + "e" + e[0]);
W[5] = (e) => e[1] * Math.exp(e[0] * Math.log(2));
const ct = (e, t) => {
  e = e - 57344;
  let r = K[e];
  r && r.isShared && ((K.restoreStructures || (K.restoreStructures = []))[e] = r), K[e] = t, t.read = ft(t);
};
W[on] = (e) => {
  let t = e.length, r = e[1];
  ct(e[0], r);
  let n = {};
  for (let s = 2; s < t; s++) {
    let o = r[s - 2];
    n[se(o)] = e[s];
  }
  return n;
};
W[14] = (e) => G ? G[0].slice(G.position0, G.position0 += e) : new xe(e, 14);
W[15] = (e) => G ? G[1].slice(G.position1, G.position1 += e) : new xe(e, 15);
let dn = { Error, RegExp };
W[27] = (e) => (dn[e[0]] || Error)(e[1], e[2]);
const fr = (e) => {
  if (O[w++] != 132) {
    let r = new Error("Packed values structure must be followed by a 4 element array");
    throw O.length < w && (r.incomplete = !0), r;
  }
  let t = e();
  if (!t || !t.length) {
    let r = new Error("Packed values structure must be followed by a 4 element array");
    throw r.incomplete = !0, r;
  }
  return Q = Q ? t.concat(Q.slice(t.length)) : t, Q.prefixes = e(), Q.suffixes = e(), e();
};
fr.handlesRead = !0;
W[51] = fr;
W[Ut] = (e) => {
  if (!Q)
    if (D.getShared)
      mt();
    else
      return new xe(e, Ut);
  if (typeof e == "number")
    return Q[16 + (e >= 0 ? 2 * e : -2 * e - 1)];
  let t = new Error("No support for non-integer packed references yet");
  throw e === void 0 && (t.incomplete = !0), t;
};
W[28] = (e) => {
  ne || (ne = /* @__PURE__ */ new Map(), ne.id = 0);
  let t = ne.id++, r = w, n = O[w], s;
  n >> 5 == 4 ? s = [] : s = {};
  let o = { target: s };
  ne.set(t, o);
  let i = e();
  return o.used ? (Object.getPrototypeOf(s) !== Object.getPrototypeOf(i) && (w = r, s = i, ne.set(t, { target: s }), i = e()), Object.assign(s, i)) : (o.target = i, i);
};
W[28].handlesRead = !0;
W[29] = (e) => {
  let t = ne.get(e);
  return t.used = !0, t.target;
};
W[258] = (e) => new Set(e);
(W[259] = (e) => (D.mapsAsObjects && (D.mapsAsObjects = !1, Ce = !0), e())).handlesRead = !0;
function me(e, t) {
  return typeof e == "string" ? e + t : e instanceof Array ? e.concat(t) : Object.assign({}, e, t);
}
function de() {
  if (!Q)
    if (D.getShared)
      mt();
    else
      throw new Error("No packed values available");
  return Q;
}
const yn = 1399353956;
ot.push((e, t) => {
  if (e >= 225 && e <= 255)
    return me(de().prefixes[e - 224], t);
  if (e >= 28704 && e <= 32767)
    return me(de().prefixes[e - 28672], t);
  if (e >= 1879052288 && e <= 2147483647)
    return me(de().prefixes[e - 1879048192], t);
  if (e >= 216 && e <= 223)
    return me(t, de().suffixes[e - 216]);
  if (e >= 27647 && e <= 28671)
    return me(t, de().suffixes[e - 27639]);
  if (e >= 1811940352 && e <= 1879048191)
    return me(t, de().suffixes[e - 1811939328]);
  if (e == yn)
    return {
      packedValues: Q,
      structures: K.slice(0),
      version: t
    };
  if (e == 55799)
    return t;
});
const pn = new Uint8Array(new Uint16Array([1]).buffer)[0] == 1, kt = [
  Uint8Array,
  Uint8ClampedArray,
  Uint16Array,
  Uint32Array,
  typeof BigUint64Array > "u" ? { name: "BigUint64Array" } : BigUint64Array,
  Int8Array,
  Int16Array,
  Int32Array,
  typeof BigInt64Array > "u" ? { name: "BigInt64Array" } : BigInt64Array,
  Float32Array,
  Float64Array
], bn = [64, 68, 69, 70, 71, 72, 77, 78, 79, 85, 86];
for (let e = 0; e < kt.length; e++)
  gn(kt[e], bn[e]);
function gn(e, t) {
  let r = "get" + e.name.slice(0, -5), n;
  typeof e == "function" ? n = e.BYTES_PER_ELEMENT : e = null;
  for (let s = 0; s < 2; s++) {
    if (!s && n == 1)
      continue;
    let o = n == 2 ? 1 : n == 4 ? 2 : n == 8 ? 3 : 0;
    W[s ? t : t - 4] = n == 1 || s == pn ? (i) => {
      if (!e)
        throw new Error("Could not find typed array for code " + t);
      return !D.copyBuffers && (n === 1 || n === 2 && !(i.byteOffset & 1) || n === 4 && !(i.byteOffset & 3) || n === 8 && !(i.byteOffset & 7)) ? new e(i.buffer, i.byteOffset, i.byteLength >> o) : new e(Uint8Array.prototype.slice.call(i, 0).buffer);
    } : (i) => {
      if (!e)
        throw new Error("Could not find typed array for code " + t);
      let c = new DataView(i.buffer, i.byteOffset, i.byteLength), a = i.length >> o, p = new e(a), d = c[r];
      for (let h = 0; h < a; h++)
        p[h] = d.call(c, h << o, s);
      return p;
    };
  }
}
function xn() {
  let e = ve(), t = w + P();
  for (let n = 2; n < e; n++) {
    let s = ve();
    w += s;
  }
  let r = w;
  return w = t, G = [at(ve()), at(ve())], G.position0 = 0, G.position1 = 0, G.postBundlePosition = w, w = r, P();
}
function ve() {
  let e = O[w++] & 31;
  if (e > 23)
    switch (e) {
      case 24:
        e = O[w++];
        break;
      case 25:
        e = Y.getUint16(w), w += 2;
        break;
      case 26:
        e = Y.getUint32(w), w += 4;
        break;
    }
  return e;
}
function mt() {
  if (D.getShared) {
    let e = ar(() => (O = null, D.getShared())) || {}, t = e.structures || [];
    D.sharedVersion = e.version, Q = D.sharedValues = e.packedValues, K === !0 ? D.structures = K = t : K.splice.apply(K, [0, t.length].concat(t));
  }
}
function ar(e) {
  let t = be, r = w, n = Ve, s = Ie, o = Pe, i = ne, c = G, a = new Uint8Array(O.slice(0, be)), p = K, d = D, h = Ue, g = e();
  return be = t, w = r, Ve = n, Ie = s, Pe = o, ne = i, G = c, O = a, Ue = h, K = p, D = d, Y = new DataView(O.buffer, O.byteOffset, O.byteLength), g;
}
function lt() {
  O = null, ne = null, K = null;
}
const vt = new Array(147);
for (let e = 0; e < 256; e++)
  vt[e] = +("1e" + Math.floor(45.15 - e * 0.30103));
let St = new Fe({ useRecords: !1 });
St.decode;
St.decodeMultiple;
let Me;
try {
  Me = new TextEncoder();
} catch {
}
let ut, cr;
const Je = typeof globalThis == "object" && globalThis.Buffer, je = typeof Je < "u", Qe = je ? Je.allocUnsafeSlow : Uint8Array, Rt = je ? Je : Uint8Array, Mt = 256, Bt = je ? 4294967296 : 2144337920;
let et, y, z, f = 0, ue, J = null;
const wn = 61440, mn = /[\u0080-\uFFFF]/, ee = Symbol("record-id");
class vn extends Fe {
  constructor(t) {
    super(t), this.offset = 0;
    let r, n, s, o, i;
    t = t || {};
    let c = Rt.prototype.utf8Write ? function(l, _, m) {
      return y.utf8Write(l, _, m);
    } : Me && Me.encodeInto ? function(l, _) {
      return Me.encodeInto(l, y.subarray(_)).written;
    } : !1, a = this, p = t.structures || t.saveStructures, d = t.maxSharedStructures;
    if (d == null && (d = p ? 128 : 0), d > 8190)
      throw new Error("Maximum maxSharedStructure is 8190");
    let h = t.sequential;
    h && (d = 0), this.structures || (this.structures = []), this.saveStructures && (this.saveShared = this.saveStructures);
    let g, u, b = t.sharedValues, x;
    if (b) {
      x = /* @__PURE__ */ Object.create(null);
      for (let l = 0, _ = b.length; l < _; l++)
        x[b[l]] = l;
    }
    let A = [], I = 0, U = 0;
    this.mapEncode = function(l, _) {
      if (this._keyMap && !this._mapped)
        switch (l.constructor.name) {
          case "Array":
            l = l.map((m) => this.encodeKeys(m));
            break;
        }
      return this.encode(l, _);
    }, this.encode = function(l, _) {
      if (y || (y = new Qe(8192), z = new DataView(y.buffer, 0, 8192), f = 0), ue = y.length - 10, ue - f < 2048 ? (y = new Qe(y.length), z = new DataView(y.buffer, 0, y.length), ue = y.length - 10, f = 0) : _ === Pt && (f = f + 7 & 2147483640), r = f, a.useSelfDescribedHeader && (z.setUint32(f, 3654940416), f += 3), i = a.structuredClone ? /* @__PURE__ */ new Map() : null, a.bundleStrings && typeof l != "string" ? (J = [], J.size = 1 / 0) : J = null, n = a.structures, n) {
        if (n.uninitialized) {
          let C = a.getShared() || {};
          a.structures = n = C.structures || [], a.sharedVersion = C.version;
          let v = a.sharedValues = C.packedValues;
          if (v) {
            x = {};
            for (let j = 0, k = v.length; j < k; j++)
              x[v[j]] = j;
          }
        }
        let m = n.length;
        if (m > d && !h && (m = d), !n.transitions) {
          n.transitions = /* @__PURE__ */ Object.create(null);
          for (let C = 0; C < m; C++) {
            let v = n[C];
            if (!v)
              continue;
            let j, k = n.transitions;
            for (let M = 0, T = v.length; M < T; M++) {
              k[ee] === void 0 && (k[ee] = C);
              let V = v[M];
              j = k[V], j || (j = k[V] = /* @__PURE__ */ Object.create(null)), k = j;
            }
            k[ee] = C | 1048576;
          }
        }
        h || (n.nextId = m);
      }
      if (s && (s = !1), o = n || [], u = x, t.pack) {
        let m = /* @__PURE__ */ new Map();
        if (m.values = [], m.encoder = a, m.maxValues = t.maxPrivatePackedValues || (x ? 16 : 1 / 0), m.objectMap = x || !1, m.samplingPackedValues = g, Be(l, m), m.values.length > 0) {
          y[f++] = 216, y[f++] = 51, fe(4);
          let C = m.values;
          S(C), fe(0), fe(0), u = Object.create(x || null);
          for (let v = 0, j = C.length; v < j; v++)
            u[C[v]] = v;
        }
      }
      et = _ & rt;
      try {
        if (et)
          return;
        if (S(l), J && Lt(r, S), a.offset = f, i && i.idsToInsert) {
          f += i.idsToInsert.length * 2, f > ue && R(f), a.offset = f;
          let m = Cn(y.subarray(r, f), i.idsToInsert);
          return i = null, m;
        }
        return _ & Pt ? (y.start = r, y.end = f, y) : y.subarray(r, f);
      } finally {
        if (n) {
          if (U < 10 && U++, n.length > d && (n.length = d), I > 1e4)
            n.transitions = null, U = 0, I = 0, A.length > 0 && (A = []);
          else if (A.length > 0 && !h) {
            for (let m = 0, C = A.length; m < C; m++)
              A[m][ee] = void 0;
            A = [];
          }
        }
        if (s && a.saveShared) {
          a.structures.length > d && (a.structures = a.structures.slice(0, d));
          let m = y.subarray(r, f);
          return a.updateSharedData() === !1 ? a.encode(l) : m;
        }
        _ & En && (f = r);
      }
    }, this.findCommonStringsToPack = () => (g = /* @__PURE__ */ new Map(), x || (x = /* @__PURE__ */ Object.create(null)), (l) => {
      let _ = l && l.threshold || 4, m = this.pack ? l.maxPrivatePackedValues || 16 : 0;
      b || (b = this.sharedValues = []);
      for (let [C, v] of g)
        v.count > _ && (x[C] = m++, b.push(C), s = !0);
      for (; this.saveShared && this.updateSharedData() === !1; )
        ;
      g = null;
    });
    const S = (l) => {
      f > ue && (y = R(f));
      var _ = typeof l, m;
      if (_ === "string") {
        if (u) {
          let k = u[l];
          if (k >= 0) {
            k < 16 ? y[f++] = k + 224 : (y[f++] = 198, k & 1 ? S(15 - k >> 1) : S(k - 16 >> 1));
            return;
          } else if (g && !t.pack) {
            let M = g.get(l);
            M ? M.count++ : g.set(l, {
              count: 1
            });
          }
        }
        let C = l.length;
        if (J && C >= 4 && C < 1024) {
          if ((J.size += C) > wn) {
            let M, T = (J[0] ? J[0].length * 3 + J[1].length : 0) + 10;
            f + T > ue && (y = R(f + T)), y[f++] = 217, y[f++] = 223, y[f++] = 249, y[f++] = J.position ? 132 : 130, y[f++] = 26, M = f - r, f += 4, J.position && Lt(r, S), J = ["", ""], J.size = 0, J.position = M;
          }
          let k = mn.test(l);
          J[k ? 0 : 1] += l, y[f++] = k ? 206 : 207, S(C);
          return;
        }
        let v;
        C < 32 ? v = 1 : C < 256 ? v = 2 : C < 65536 ? v = 3 : v = 5;
        let j = C * 3;
        if (f + j > ue && (y = R(f + j)), C < 64 || !c) {
          let k, M, T, V = f + v;
          for (k = 0; k < C; k++)
            M = l.charCodeAt(k), M < 128 ? y[V++] = M : M < 2048 ? (y[V++] = M >> 6 | 192, y[V++] = M & 63 | 128) : (M & 64512) === 55296 && ((T = l.charCodeAt(k + 1)) & 64512) === 56320 ? (M = 65536 + ((M & 1023) << 10) + (T & 1023), k++, y[V++] = M >> 18 | 240, y[V++] = M >> 12 & 63 | 128, y[V++] = M >> 6 & 63 | 128, y[V++] = M & 63 | 128) : (y[V++] = M >> 12 | 224, y[V++] = M >> 6 & 63 | 128, y[V++] = M & 63 | 128);
          m = V - f - v;
        } else
          m = c(l, f + v, j);
        m < 24 ? y[f++] = 96 | m : m < 256 ? (v < 2 && y.copyWithin(f + 2, f + 1, f + 1 + m), y[f++] = 120, y[f++] = m) : m < 65536 ? (v < 3 && y.copyWithin(f + 3, f + 2, f + 2 + m), y[f++] = 121, y[f++] = m >> 8, y[f++] = m & 255) : (v < 5 && y.copyWithin(f + 5, f + 3, f + 3 + m), y[f++] = 122, z.setUint32(f, m), f += 4), f += m;
      } else if (_ === "number")
        if (!this.alwaysUseFloat && l >>> 0 === l)
          l < 24 ? y[f++] = l : l < 256 ? (y[f++] = 24, y[f++] = l) : l < 65536 ? (y[f++] = 25, y[f++] = l >> 8, y[f++] = l & 255) : (y[f++] = 26, z.setUint32(f, l), f += 4);
        else if (!this.alwaysUseFloat && l >> 0 === l)
          l >= -24 ? y[f++] = 31 - l : l >= -256 ? (y[f++] = 56, y[f++] = ~l) : l >= -65536 ? (y[f++] = 57, z.setUint16(f, ~l), f += 2) : (y[f++] = 58, z.setUint32(f, ~l), f += 4);
        else {
          let C;
          if ((C = this.useFloat32) > 0 && l < 4294967296 && l >= -2147483648) {
            y[f++] = 250, z.setFloat32(f, l);
            let v;
            if (C < 4 || // this checks for rounding of numbers that were encoded in 32-bit float to nearest significant decimal digit that could be preserved
            (v = l * vt[(y[f] & 127) << 1 | y[f + 1] >> 7]) >> 0 === v) {
              f += 4;
              return;
            } else
              f--;
          }
          y[f++] = 251, z.setFloat64(f, l), f += 8;
        }
      else if (_ === "object")
        if (!l)
          y[f++] = 246;
        else {
          if (i) {
            let v = i.get(l);
            if (v) {
              if (y[f++] = 216, y[f++] = 29, y[f++] = 25, !v.references) {
                let j = i.idsToInsert || (i.idsToInsert = []);
                v.references = [], j.push(v);
              }
              v.references.push(f - r), f += 2;
              return;
            } else
              i.set(l, { offset: f - r });
          }
          let C = l.constructor;
          if (C === Object)
            B(l);
          else if (C === Array) {
            m = l.length, m < 24 ? y[f++] = 128 | m : fe(m);
            for (let v = 0; v < m; v++)
              S(l[v]);
          } else if (C === Map)
            if ((this.mapsAsObjects ? this.useTag259ForMaps !== !1 : this.useTag259ForMaps) && (y[f++] = 217, y[f++] = 1, y[f++] = 3), m = l.size, m < 24 ? y[f++] = 160 | m : m < 256 ? (y[f++] = 184, y[f++] = m) : m < 65536 ? (y[f++] = 185, y[f++] = m >> 8, y[f++] = m & 255) : (y[f++] = 186, z.setUint32(f, m), f += 4), a.keyMap)
              for (let [v, j] of l)
                S(a.encodeKey(v)), S(j);
            else
              for (let [v, j] of l)
                S(v), S(j);
          else {
            for (let v = 0, j = ut.length; v < j; v++) {
              let k = cr[v];
              if (l instanceof k) {
                let M = ut[v], T = M.tag;
                T == null && (T = M.getTag && M.getTag.call(this, l)), T < 24 ? y[f++] = 192 | T : T < 256 ? (y[f++] = 216, y[f++] = T) : T < 65536 ? (y[f++] = 217, y[f++] = T >> 8, y[f++] = T & 255) : T > -1 && (y[f++] = 218, z.setUint32(f, T), f += 4), M.encode.call(this, l, S, R);
                return;
              }
            }
            if (l[Symbol.iterator]) {
              if (et) {
                let v = new Error("Iterable should be serialized as iterator");
                throw v.iteratorNotHandled = !0, v;
              }
              y[f++] = 159;
              for (let v of l)
                S(v);
              y[f++] = 255;
              return;
            }
            if (l[Symbol.asyncIterator] || tt(l)) {
              let v = new Error("Iterable/blob should be serialized as iterator");
              throw v.iteratorNotHandled = !0, v;
            }
            if (this.useToJSON && l.toJSON) {
              const v = l.toJSON();
              if (v !== l)
                return S(v);
            }
            B(l);
          }
        }
      else if (_ === "boolean")
        y[f++] = l ? 245 : 244;
      else if (_ === "bigint") {
        if (l < BigInt(1) << BigInt(64) && l >= 0)
          y[f++] = 27, z.setBigUint64(f, l);
        else if (l > -(BigInt(1) << BigInt(64)) && l < 0)
          y[f++] = 59, z.setBigUint64(f, -l - BigInt(1));
        else if (this.largeBigIntToFloat)
          y[f++] = 251, z.setFloat64(f, Number(l));
        else
          throw new RangeError(l + " was too large to fit in CBOR 64-bit integer format, set largeBigIntToFloat to convert to float-64");
        f += 8;
      } else if (_ === "undefined")
        y[f++] = 247;
      else
        throw new Error("Unknown type: " + _);
    }, B = this.useRecords === !1 ? this.variableMapSize ? (l) => {
      let _ = Object.keys(l), m = Object.values(l), C = _.length;
      if (C < 24 ? y[f++] = 160 | C : C < 256 ? (y[f++] = 184, y[f++] = C) : C < 65536 ? (y[f++] = 185, y[f++] = C >> 8, y[f++] = C & 255) : (y[f++] = 186, z.setUint32(f, C), f += 4), a.keyMap)
        for (let v = 0; v < C; v++)
          S(a.encodeKey(_[v])), S(m[v]);
      else
        for (let v = 0; v < C; v++)
          S(_[v]), S(m[v]);
    } : (l) => {
      y[f++] = 185;
      let _ = f - r;
      f += 2;
      let m = 0;
      if (a.keyMap)
        for (let C in l) (typeof l.hasOwnProperty != "function" || l.hasOwnProperty(C)) && (S(a.encodeKey(C)), S(l[C]), m++);
      else
        for (let C in l) (typeof l.hasOwnProperty != "function" || l.hasOwnProperty(C)) && (S(C), S(l[C]), m++);
      y[_++ + r] = m >> 8, y[_ + r] = m & 255;
    } : (l, _) => {
      let m, C = o.transitions || (o.transitions = /* @__PURE__ */ Object.create(null)), v = 0, j = 0, k, M;
      if (this.keyMap) {
        M = Object.keys(l).map((V) => this.encodeKey(V)), j = M.length;
        for (let V = 0; V < j; V++) {
          let Ct = M[V];
          m = C[Ct], m || (m = C[Ct] = /* @__PURE__ */ Object.create(null), v++), C = m;
        }
      } else
        for (let V in l) (typeof l.hasOwnProperty != "function" || l.hasOwnProperty(V)) && (m = C[V], m || (C[ee] & 1048576 && (k = C[ee] & 65535), m = C[V] = /* @__PURE__ */ Object.create(null), v++), C = m, j++);
      let T = C[ee];
      if (T !== void 0)
        T &= 65535, y[f++] = 217, y[f++] = T >> 8 | 224, y[f++] = T & 255;
      else if (M || (M = C.__keys__ || (C.__keys__ = Object.keys(l))), k === void 0 ? (T = o.nextId++, T || (T = 0, o.nextId = 1), T >= Mt && (o.nextId = (T = d) + 1)) : T = k, o[T] = M, T < d) {
        y[f++] = 217, y[f++] = T >> 8 | 224, y[f++] = T & 255, C = o.transitions;
        for (let V = 0; V < j; V++)
          (C[ee] === void 0 || C[ee] & 1048576) && (C[ee] = T), C = C[M[V]];
        C[ee] = T | 1048576, s = !0;
      } else {
        if (C[ee] = T, z.setUint32(f, 3655335680), f += 3, v && (I += U * v), A.length >= Mt - d && (A.shift()[ee] = void 0), A.push(C), fe(j + 2), S(57344 + T), S(M), _) return;
        for (let V in l)
          (typeof l.hasOwnProperty != "function" || l.hasOwnProperty(V)) && S(l[V]);
        return;
      }
      if (j < 24 ? y[f++] = 128 | j : fe(j), !_)
        for (let V in l)
          (typeof l.hasOwnProperty != "function" || l.hasOwnProperty(V)) && S(l[V]);
    }, R = (l) => {
      let _;
      if (l > 16777216) {
        if (l - r > Bt)
          throw new Error("Encoded buffer would be larger than maximum buffer size");
        _ = Math.min(
          Bt,
          Math.round(Math.max((l - r) * (l > 67108864 ? 1.25 : 2), 4194304) / 4096) * 4096
        );
      } else
        _ = (Math.max(l - r << 2, y.length - 1) >> 12) + 1 << 12;
      let m = new Qe(_);
      return z = new DataView(m.buffer, 0, _), y.copy ? y.copy(m, 0, r, l) : m.set(y.slice(r, l)), f -= r, r = 0, ue = m.length - 10, y = m;
    };
    let F = 100, N = 1e3;
    this.encodeAsIterable = function(l, _) {
      return ie(l, _, L);
    }, this.encodeAsAsyncIterable = function(l, _) {
      return ie(l, _, E);
    };
    function* L(l, _, m) {
      let C = l.constructor;
      if (C === Object) {
        let v = a.useRecords !== !1;
        v ? B(l, !0) : Tt(Object.keys(l).length, 160);
        for (let j in l) {
          let k = l[j];
          v || S(j), k && typeof k == "object" ? _[j] ? yield* L(k, _[j]) : yield* $(k, _, j) : S(k);
        }
      } else if (C === Array) {
        let v = l.length;
        fe(v);
        for (let j = 0; j < v; j++) {
          let k = l[j];
          k && (typeof k == "object" || f - r > F) ? _.element ? yield* L(k, _.element) : yield* $(k, _, "element") : S(k);
        }
      } else if (l[Symbol.iterator]) {
        y[f++] = 159;
        for (let v of l)
          v && (typeof v == "object" || f - r > F) ? _.element ? yield* L(v, _.element) : yield* $(v, _, "element") : S(v);
        y[f++] = 255;
      } else tt(l) ? (Tt(l.size, 64), yield y.subarray(r, f), yield l, H()) : l[Symbol.asyncIterator] ? (y[f++] = 159, yield y.subarray(r, f), yield l, H(), y[f++] = 255) : S(l);
      m && f > r ? yield y.subarray(r, f) : f - r > F && (yield y.subarray(r, f), H());
    }
    function* $(l, _, m) {
      let C = f - r;
      try {
        S(l), f - r > F && (yield y.subarray(r, f), H());
      } catch (v) {
        if (v.iteratorNotHandled)
          _[m] = {}, f = r + C, yield* L.call(this, l, _[m]);
        else throw v;
      }
    }
    function H() {
      F = N, a.encode(null, rt);
    }
    function ie(l, _, m) {
      return _ && _.chunkThreshold ? F = N = _.chunkThreshold : F = 100, l && typeof l == "object" ? (a.encode(null, rt), m(l, a.iterateProperties || (a.iterateProperties = {}), !0)) : [a.encode(l)];
    }
    async function* E(l, _) {
      for (let m of L(l, _, !0)) {
        let C = m.constructor;
        if (C === Rt || C === Uint8Array)
          yield m;
        else if (tt(m)) {
          let v = m.stream().getReader(), j;
          for (; !(j = await v.read()).done; )
            yield j.value;
        } else if (m[Symbol.asyncIterator])
          for await (let v of m)
            H(), v ? yield* E(v, _.async || (_.async = {})) : yield a.encode(v);
        else
          yield m;
      }
    }
  }
  useBuffer(t) {
    y = t, z = new DataView(y.buffer, y.byteOffset, y.byteLength), f = 0;
  }
  clearSharedData() {
    this.structures && (this.structures = []), this.sharedValues && (this.sharedValues = void 0);
  }
  updateSharedData() {
    let t = this.sharedVersion || 0;
    this.sharedVersion = t + 1;
    let r = this.structures.slice(0), n = new lr(r, this.sharedValues, this.sharedVersion), s = this.saveShared(
      n,
      (o) => (o && o.version || 0) == t
    );
    return s === !1 ? (n = this.getShared() || {}, this.structures = n.structures || [], this.sharedValues = n.packedValues, this.sharedVersion = n.version, this.structures.nextId = this.structures.length) : r.forEach((o, i) => this.structures[i] = o), s;
  }
}
function Tt(e, t) {
  e < 24 ? y[f++] = t | e : e < 256 ? (y[f++] = t | 24, y[f++] = e) : e < 65536 ? (y[f++] = t | 25, y[f++] = e >> 8, y[f++] = e & 255) : (y[f++] = t | 26, z.setUint32(f, e), f += 4);
}
class lr {
  constructor(t, r, n) {
    this.structures = t, this.packedValues = r, this.version = n;
  }
}
function fe(e) {
  e < 24 ? y[f++] = 128 | e : e < 256 ? (y[f++] = 152, y[f++] = e) : e < 65536 ? (y[f++] = 153, y[f++] = e >> 8, y[f++] = e & 255) : (y[f++] = 154, z.setUint32(f, e), f += 4);
}
const Sn = typeof Blob > "u" ? function() {
} : Blob;
function tt(e) {
  if (e instanceof Sn)
    return !0;
  let t = e[Symbol.toStringTag];
  return t === "Blob" || t === "File";
}
function Be(e, t) {
  switch (typeof e) {
    case "string":
      if (e.length > 3) {
        if (t.objectMap[e] > -1 || t.values.length >= t.maxValues)
          return;
        let n = t.get(e);
        if (n)
          ++n.count == 2 && t.values.push(e);
        else if (t.set(e, {
          count: 1
        }), t.samplingPackedValues) {
          let s = t.samplingPackedValues.get(e);
          s ? s.count++ : t.samplingPackedValues.set(e, {
            count: 1
          });
        }
      }
      break;
    case "object":
      if (e)
        if (e instanceof Array)
          for (let n = 0, s = e.length; n < s; n++)
            Be(e[n], t);
        else {
          let n = !t.encoder.useRecords;
          for (var r in e)
            e.hasOwnProperty(r) && (n && Be(r, t), Be(e[r], t));
        }
      break;
    case "function":
      console.log(e);
  }
}
const An = new Uint8Array(new Uint16Array([1]).buffer)[0] == 1;
cr = [
  Date,
  Set,
  Error,
  RegExp,
  xe,
  ArrayBuffer,
  Uint8Array,
  Uint8ClampedArray,
  Uint16Array,
  Uint32Array,
  typeof BigUint64Array > "u" ? function() {
  } : BigUint64Array,
  Int8Array,
  Int16Array,
  Int32Array,
  typeof BigInt64Array > "u" ? function() {
  } : BigInt64Array,
  Float32Array,
  Float64Array,
  lr
];
ut = [
  {
    // Date
    tag: 1,
    encode(e, t) {
      let r = e.getTime() / 1e3;
      (this.useTimestamp32 || e.getMilliseconds() === 0) && r >= 0 && r < 4294967296 ? (y[f++] = 26, z.setUint32(f, r), f += 4) : (y[f++] = 251, z.setFloat64(f, r), f += 8);
    }
  },
  {
    // Set
    tag: 258,
    // https://github.com/input-output-hk/cbor-sets-spec/blob/master/CBOR_SETS.md
    encode(e, t) {
      let r = Array.from(e);
      t(r);
    }
  },
  {
    // Error
    tag: 27,
    // http://cbor.schmorp.de/generic-object
    encode(e, t) {
      t([e.name, e.message]);
    }
  },
  {
    // RegExp
    tag: 27,
    // http://cbor.schmorp.de/generic-object
    encode(e, t) {
      t(["RegExp", e.source, e.flags]);
    }
  },
  {
    // Tag
    getTag(e) {
      return e.tag;
    },
    encode(e, t) {
      t(e.value);
    }
  },
  {
    // ArrayBuffer
    encode(e, t, r) {
      Dt(e, r);
    }
  },
  {
    // Uint8Array
    getTag(e) {
      if (e.constructor === Uint8Array && (this.tagUint8Array || je && this.tagUint8Array !== !1))
        return 64;
    },
    encode(e, t, r) {
      Dt(e, r);
    }
  },
  oe(68, 1),
  oe(69, 2),
  oe(70, 4),
  oe(71, 8),
  oe(72, 1),
  oe(77, 2),
  oe(78, 4),
  oe(79, 8),
  oe(85, 4),
  oe(86, 8),
  {
    encode(e, t) {
      let r = e.packedValues || [], n = e.structures || [];
      if (r.values.length > 0) {
        y[f++] = 216, y[f++] = 51, fe(4);
        let s = r.values;
        t(s), fe(0), fe(0), packedObjectMap = Object.create(sharedPackedObjectMap || null);
        for (let o = 0, i = s.length; o < i; o++)
          packedObjectMap[s[o]] = o;
      }
      if (n) {
        z.setUint32(f, 3655335424), f += 3;
        let s = n.slice(0);
        s.unshift(57344), s.push(new xe(e.version, 1399353956)), t(s);
      } else
        t(new xe(e.version, 1399353956));
    }
  }
];
function oe(e, t) {
  return !An && t > 1 && (e -= 4), {
    tag: e,
    encode: function(n, s) {
      let o = n.byteLength, i = n.byteOffset || 0, c = n.buffer || n;
      s(je ? Je.from(c, i, o) : new Uint8Array(c, i, o));
    }
  };
}
function Dt(e, t) {
  let r = e.byteLength;
  r < 24 ? y[f++] = 64 + r : r < 256 ? (y[f++] = 88, y[f++] = r) : r < 65536 ? (y[f++] = 89, y[f++] = r >> 8, y[f++] = r & 255) : (y[f++] = 90, z.setUint32(f, r), f += 4), f + r >= y.length && t(f + r), y.set(e.buffer ? e : new Uint8Array(e), f), f += r;
}
function Cn(e, t) {
  let r, n = t.length * 2, s = e.length - n;
  t.sort((o, i) => o.offset > i.offset ? 1 : -1);
  for (let o = 0; o < t.length; o++) {
    let i = t[o];
    i.id = o;
    for (let c of i.references)
      e[c++] = o >> 8, e[c] = o & 255;
  }
  for (; r = t.pop(); ) {
    let o = r.offset;
    e.copyWithin(o + n, o, s), n -= 2;
    let i = o + n;
    e[i++] = 216, e[i++] = 28, s = o;
  }
  return e;
}
function Lt(e, t) {
  z.setUint32(J.position + e, f - J.position - e + 1);
  let r = J;
  J = null, t(r[0]), t(r[1]);
}
let At = new vn({ useRecords: !1 });
At.encode;
At.encodeAsIterable;
At.encodeAsAsyncIterable;
const Pt = 512, En = 1024, rt = 2048;
var _n = { exports: {} };
(function(e) {
  (function(t, r) {
    var n = {};
    r(n);
    var s = n.default;
    for (var o in n)
      s[o] = n[o];
    e.exports = s;
  })(kr, function(t) {
    t.__esModule = !0, t.digestLength = 32, t.blockSize = 64;
    var r = new Uint32Array([
      1116352408,
      1899447441,
      3049323471,
      3921009573,
      961987163,
      1508970993,
      2453635748,
      2870763221,
      3624381080,
      310598401,
      607225278,
      1426881987,
      1925078388,
      2162078206,
      2614888103,
      3248222580,
      3835390401,
      4022224774,
      264347078,
      604807628,
      770255983,
      1249150122,
      1555081692,
      1996064986,
      2554220882,
      2821834349,
      2952996808,
      3210313671,
      3336571891,
      3584528711,
      113926993,
      338241895,
      666307205,
      773529912,
      1294757372,
      1396182291,
      1695183700,
      1986661051,
      2177026350,
      2456956037,
      2730485921,
      2820302411,
      3259730800,
      3345764771,
      3516065817,
      3600352804,
      4094571909,
      275423344,
      430227734,
      506948616,
      659060556,
      883997877,
      958139571,
      1322822218,
      1537002063,
      1747873779,
      1955562222,
      2024104815,
      2227730452,
      2361852424,
      2428436474,
      2756734187,
      3204031479,
      3329325298
    ]);
    function n(g, u, b, x, A) {
      for (var I, U, S, B, R, F, N, L, $, H, ie, E, l; A >= 64; ) {
        for (I = u[0], U = u[1], S = u[2], B = u[3], R = u[4], F = u[5], N = u[6], L = u[7], H = 0; H < 16; H++)
          ie = x + H * 4, g[H] = (b[ie] & 255) << 24 | (b[ie + 1] & 255) << 16 | (b[ie + 2] & 255) << 8 | b[ie + 3] & 255;
        for (H = 16; H < 64; H++)
          $ = g[H - 2], E = ($ >>> 17 | $ << 15) ^ ($ >>> 19 | $ << 13) ^ $ >>> 10, $ = g[H - 15], l = ($ >>> 7 | $ << 25) ^ ($ >>> 18 | $ << 14) ^ $ >>> 3, g[H] = (E + g[H - 7] | 0) + (l + g[H - 16] | 0);
        for (H = 0; H < 64; H++)
          E = (((R >>> 6 | R << 26) ^ (R >>> 11 | R << 21) ^ (R >>> 25 | R << 7)) + (R & F ^ ~R & N) | 0) + (L + (r[H] + g[H] | 0) | 0) | 0, l = ((I >>> 2 | I << 30) ^ (I >>> 13 | I << 19) ^ (I >>> 22 | I << 10)) + (I & U ^ I & S ^ U & S) | 0, L = N, N = F, F = R, R = B + E | 0, B = S, S = U, U = I, I = E + l | 0;
        u[0] += I, u[1] += U, u[2] += S, u[3] += B, u[4] += R, u[5] += F, u[6] += N, u[7] += L, x += 64, A -= 64;
      }
      return x;
    }
    var s = (
      /** @class */
      function() {
        function g() {
          this.digestLength = t.digestLength, this.blockSize = t.blockSize, this.state = new Int32Array(8), this.temp = new Int32Array(64), this.buffer = new Uint8Array(128), this.bufferLength = 0, this.bytesHashed = 0, this.finished = !1, this.reset();
        }
        return g.prototype.reset = function() {
          return this.state[0] = 1779033703, this.state[1] = 3144134277, this.state[2] = 1013904242, this.state[3] = 2773480762, this.state[4] = 1359893119, this.state[5] = 2600822924, this.state[6] = 528734635, this.state[7] = 1541459225, this.bufferLength = 0, this.bytesHashed = 0, this.finished = !1, this;
        }, g.prototype.clean = function() {
          for (var u = 0; u < this.buffer.length; u++)
            this.buffer[u] = 0;
          for (var u = 0; u < this.temp.length; u++)
            this.temp[u] = 0;
          this.reset();
        }, g.prototype.update = function(u, b) {
          if (b === void 0 && (b = u.length), this.finished)
            throw new Error("SHA256: can't update because hash was finished.");
          var x = 0;
          if (this.bytesHashed += b, this.bufferLength > 0) {
            for (; this.bufferLength < 64 && b > 0; )
              this.buffer[this.bufferLength++] = u[x++], b--;
            this.bufferLength === 64 && (n(this.temp, this.state, this.buffer, 0, 64), this.bufferLength = 0);
          }
          for (b >= 64 && (x = n(this.temp, this.state, u, x, b), b %= 64); b > 0; )
            this.buffer[this.bufferLength++] = u[x++], b--;
          return this;
        }, g.prototype.finish = function(u) {
          if (!this.finished) {
            var b = this.bytesHashed, x = this.bufferLength, A = b / 536870912 | 0, I = b << 3, U = b % 64 < 56 ? 64 : 128;
            this.buffer[x] = 128;
            for (var S = x + 1; S < U - 8; S++)
              this.buffer[S] = 0;
            this.buffer[U - 8] = A >>> 24 & 255, this.buffer[U - 7] = A >>> 16 & 255, this.buffer[U - 6] = A >>> 8 & 255, this.buffer[U - 5] = A >>> 0 & 255, this.buffer[U - 4] = I >>> 24 & 255, this.buffer[U - 3] = I >>> 16 & 255, this.buffer[U - 2] = I >>> 8 & 255, this.buffer[U - 1] = I >>> 0 & 255, n(this.temp, this.state, this.buffer, 0, U), this.finished = !0;
          }
          for (var S = 0; S < 8; S++)
            u[S * 4 + 0] = this.state[S] >>> 24 & 255, u[S * 4 + 1] = this.state[S] >>> 16 & 255, u[S * 4 + 2] = this.state[S] >>> 8 & 255, u[S * 4 + 3] = this.state[S] >>> 0 & 255;
          return this;
        }, g.prototype.digest = function() {
          var u = new Uint8Array(this.digestLength);
          return this.finish(u), u;
        }, g.prototype._saveState = function(u) {
          for (var b = 0; b < this.state.length; b++)
            u[b] = this.state[b];
        }, g.prototype._restoreState = function(u, b) {
          for (var x = 0; x < this.state.length; x++)
            this.state[x] = u[x];
          this.bytesHashed = b, this.finished = !1, this.bufferLength = 0;
        }, g;
      }()
    );
    t.Hash = s;
    var o = (
      /** @class */
      function() {
        function g(u) {
          this.inner = new s(), this.outer = new s(), this.blockSize = this.inner.blockSize, this.digestLength = this.inner.digestLength;
          var b = new Uint8Array(this.blockSize);
          if (u.length > this.blockSize)
            new s().update(u).finish(b).clean();
          else
            for (var x = 0; x < u.length; x++)
              b[x] = u[x];
          for (var x = 0; x < b.length; x++)
            b[x] ^= 54;
          this.inner.update(b);
          for (var x = 0; x < b.length; x++)
            b[x] ^= 106;
          this.outer.update(b), this.istate = new Uint32Array(8), this.ostate = new Uint32Array(8), this.inner._saveState(this.istate), this.outer._saveState(this.ostate);
          for (var x = 0; x < b.length; x++)
            b[x] = 0;
        }
        return g.prototype.reset = function() {
          return this.inner._restoreState(this.istate, this.inner.blockSize), this.outer._restoreState(this.ostate, this.outer.blockSize), this;
        }, g.prototype.clean = function() {
          for (var u = 0; u < this.istate.length; u++)
            this.ostate[u] = this.istate[u] = 0;
          this.inner.clean(), this.outer.clean();
        }, g.prototype.update = function(u) {
          return this.inner.update(u), this;
        }, g.prototype.finish = function(u) {
          return this.outer.finished ? this.outer.finish(u) : (this.inner.finish(u), this.outer.update(u, this.digestLength).finish(u)), this;
        }, g.prototype.digest = function() {
          var u = new Uint8Array(this.digestLength);
          return this.finish(u), u;
        }, g;
      }()
    );
    t.HMAC = o;
    function i(g) {
      var u = new s().update(g), b = u.digest();
      return u.clean(), b;
    }
    t.hash = i, t.default = i;
    function c(g, u) {
      var b = new o(g).update(u), x = b.digest();
      return b.clean(), x;
    }
    t.hmac = c;
    function a(g, u, b, x) {
      var A = x[0];
      if (A === 0)
        throw new Error("hkdf: cannot expand more");
      u.reset(), A > 1 && u.update(g), b && u.update(b), u.update(x), u.finish(g), x[0]++;
    }
    var p = new Uint8Array(t.digestLength);
    function d(g, u, b, x) {
      u === void 0 && (u = p), x === void 0 && (x = 32);
      for (var A = new Uint8Array([1]), I = c(u, g), U = new o(I), S = new Uint8Array(U.digestLength), B = S.length, R = new Uint8Array(x), F = 0; F < x; F++)
        B === S.length && (a(S, U, b, A), B = 0), R[F] = S[B++];
      return U.clean(), S.fill(0), A.fill(0), R;
    }
    t.hkdf = d;
    function h(g, u, b, x) {
      for (var A = new o(g), I = A.digestLength, U = new Uint8Array(4), S = new Uint8Array(I), B = new Uint8Array(I), R = new Uint8Array(x), F = 0; F * I < x; F++) {
        var N = F + 1;
        U[0] = N >>> 24 & 255, U[1] = N >>> 16 & 255, U[2] = N >>> 8 & 255, U[3] = N >>> 0 & 255, A.reset(), A.update(u), A.update(U), A.finish(B);
        for (var L = 0; L < I; L++)
          S[L] = B[L];
        for (var L = 2; L <= b; L++) {
          A.reset(), A.update(B).finish(B);
          for (var $ = 0; $ < I; $++)
            S[$] ^= B[$];
        }
        for (var L = 0; L < I && F * I + L < x; L++)
          R[F * I + L] = S[L];
      }
      for (var F = 0; F < I; F++)
        S[F] = B[F] = 0;
      for (var F = 0; F < 4; F++)
        U[F] = 0;
      return A.clean(), R;
    }
    t.pbkdf2 = h;
  });
})(_n);
Dr("automerge-repo:collectionsync");
const Dn = (e) => {
  const [t, r] = yt({}), n = Ne(), s = Nt(
    () => e?.map((i) => {
      if (nn(i)) {
        const { documentId: c } = rr(i);
        return c;
      } else
        return i;
    }) ?? [],
    [e]
  ), o = Vt([]);
  return ge(() => {
    const i = {}, c = (u, b) => {
      b && r((x) => ({ ...x, [u]: b }));
    }, a = (u) => {
      const b = u.documentId, x = {
        change: ({ doc: A }) => c(b, A),
        delete: () => p(b)
      };
      u.on("change", x.change), u.on("delete", x.delete), i[b] = x;
    }, p = (u) => {
      r((b) => {
        const { [u]: x, ...A } = b;
        return A;
      });
    }, d = (u) => {
      const b = n.find(u);
      b.docSync() ? (c(u, b.docSync()), a(b)) : b.doc().then((x) => {
        c(u, x), a(b);
      }).catch((x) => {
        console.error(`Error loading document ${u} in useDocuments: `, x);
      });
    }, h = () => {
      Object.entries(i).forEach(([u, b]) => {
        const x = n.find(u);
        x.off("change", b.change), x.off("delete", b.delete);
      });
    };
    if (!s)
      return h;
    for (const u of s) {
      const b = n.find(u);
      o.current.includes(u) ? a(b) : d(u);
    }
    return o.current.filter((u) => !s.includes(u)).forEach(p), o.current = s, h;
  }, [s, n]), t;
}, On = (e, t = !1) => {
  history[t ? "pushState" : "replaceState"]("", "", "#" + e), window.dispatchEvent(
    new HashChangeEvent("hashchange", {
      newURL: window.location.origin + window.location.pathname + e,
      oldURL: window.location.href
    })
  );
}, In = () => {
  const [e, t] = yt(window.location.hash);
  return ge(() => {
    const r = () => void t(window.location.hash);
    return window.addEventListener("hashchange", r), () => void window.removeEventListener("hashchange", r);
  }, []), e;
}, ur = (e, t) => new URLSearchParams(t.slice(1)).get(e), Un = (e, t, r) => {
  const n = new URLSearchParams(r.slice(1));
  return n.set(e, t), n.toString();
}, Fn = (e, t) => e && (ur(e, t) || localStorage.getItem(e)), jn = (e, t) => {
  e && t !== ur(e, window.location.hash) && On(Un(e, t, window.location.hash)), e && localStorage.setItem(e, t);
}, Ln = ({
  key: e = "automergeUrl",
  onNoDocument: t = (n) => n.create(),
  onInvalidAutomergeUrl: r
} = {}) => {
  const n = Ne(), s = In(), o = Nt(() => {
    const i = Fn(e, s);
    try {
      return i ? n.find(i) : t(n);
    } catch (c) {
      if (i && r)
        return r(n, c);
      throw c;
    }
  }, [s, n, t, r]);
  return ge(() => {
    o && jn(e, o.url);
  }, [s, o]), o;
};
function Pn(e) {
  const t = Ne();
  return e ? t.find(e) : void 0;
}
var nt = hr, kn = function(e) {
  return typeof e == "function";
}, Rn = function(e) {
  var t = nt.useState(e), r = t[0], n = t[1], s = nt.useRef(r), o = nt.useCallback(function(i) {
    s.current = kn(i) ? i(s.current) : i, n(s.current);
  }, []);
  return [r, o, s];
}, Mn = Rn;
const ht = /* @__PURE__ */ Ke(Mn), dt = new Pr(), Vn = ({
  handle: e,
  localUserId: t,
  offlineTimeout: r = 3e4,
  getTime: n = () => (/* @__PURE__ */ new Date()).getTime()
}) => {
  const [s, o, i] = ht({}), [c, a, p] = ht({});
  return ge(() => {
    const d = (u) => {
      const [b, x] = u.message;
      b !== t && (p.current[b] || dt.emit("new_peer", u), o({
        ...i.current,
        [b]: x
      }), a({
        ...p.current,
        [b]: n()
      }));
    }, h = () => {
      const u = i.current, b = p.current, x = n();
      for (const A in b)
        x - b[A] > r && (delete u[A], delete b[A]);
      o(u), a(b);
    };
    e.on("ephemeral-message", d);
    const g = setInterval(
      h,
      r
    );
    return () => {
      e.removeListener("ephemeral-message", d), clearInterval(g);
    };
  }, [e, t, r, n]), [s, c];
}, Nn = ({
  handle: e,
  userId: t,
  initialState: r,
  heartbeatTime: n = 15e3
}) => {
  const [s, o, i] = ht(r), c = (a) => {
    const p = typeof a == "function" ? a(i.current) : a;
    o(p), e.broadcast([t, p]);
  };
  return ge(() => {
    if (!t)
      return;
    const a = () => void e.broadcast([t, i.current]);
    a();
    const p = setInterval(a, n);
    return () => void clearInterval(p);
  }, [e, t, n]), ge(() => {
    let a;
    const p = dt.on("new_peer", () => {
      a = setTimeout(
        () => e.broadcast([t, i.current]),
        500
        // Wait for the peer to be ready
      );
    });
    return () => {
      p.off("new_peer"), a && clearTimeout(a);
    };
  }, [e, t, dt]), [s, c];
};
export {
  br as RepoContext,
  Ln as useBootstrap,
  Tn as useDocument,
  Dn as useDocuments,
  Pn as useHandle,
  Nn as useLocalAwareness,
  Vn as useRemoteAwareness,
  Ne as useRepo
};
