import { DocHandle } from '@automerge/automerge-repo/slim';

export interface UseLocalAwarenessProps {
    /** The document handle to send ephemeral state on */
    handle: DocHandle<unknown>;
    /** Our user ID **/
    userId: string;
    /** The initial state object/primitive we should advertise */
    initialState: any;
    /** How frequently to send heartbeats */
    heartbeatTime?: number;
}
/**
 * This hook maintains state for the local client.
 * Like React.useState, it returns a [state, setState] array.
 * It is intended to be used alongside useRemoteAwareness.
 *
 * When state is changed it is broadcast to all clients.
 * It also broadcasts a heartbeat to let other clients know it is online.
 *
 * Note that userIds aren't secure (yet). Any client can lie about theirs.
 *
 * @param {string} props.userId Unique user ID. Clients can lie about this.
 * @param {any} props.initialState Initial state object/primitive
 * @param {number?1500} props.heartbeatTime How often to send a heartbeat (in ms)
 * @returns [state, setState]
 */
export declare const useLocalAwareness: ({ handle, userId, initialState, heartbeatTime, }: UseLocalAwarenessProps) => any[];
//# sourceMappingURL=useLocalAwareness.d.ts.map