import { DocHandle } from '@automerge/automerge-repo/slim';
import { EventEmitter } from 'eventemitter3';

export declare const peerEvents: EventEmitter<string | symbol, any>;
export interface UseRemoteAwarenessProps<T> {
    /** The handle to receive ephemeral state on */
    handle: DocHandle<T>;
    /** Our user ID */
    localUserId?: string;
    /** How long to wait (in ms) before marking a peer as offline */
    offlineTimeout?: number;
    /** Function to provide current epoch time */
    getTime?: () => number;
}
/** A map from peer ID to their state */
export type PeerStates = Record<string, any>;
/** A map from peer ID to their last heartbeat timestamp */
export type Heartbeats = Record<string, number>;
/**
 *
 * This hook returns read-only state for remote clients.
 * It also returns their heartbeat status.
 * It is intended to be used alongside useLocalAwareness.
 *
 * @param {string} props.handle A document handle to associate with
 * @param {string?} props.localUserId Automerge BroadcastChannel sometimes sends us our own messages; optionally filters them
 * @param {number?30000} props.offlineTimeout How long to wait (in ms) before marking a peer as offline
 * @param {function?} props.getTime Function to provide current epoch time (used for testing)
 * @returns [ peerStates: { [userId]: state, ... }, { [userId]: heartbeatEpochTime, ...} ]
 */
export declare const useRemoteAwareness: <T>({ handle, localUserId, offlineTimeout, getTime, }: UseRemoteAwarenessProps<T>) => [PeerStates, Heartbeats];
//# sourceMappingURL=useRemoteAwareness.d.ts.map