import { AutomergeUrl, DocumentId } from '@automerge/automerge-repo/slim';

/**
 * Maintains a map of document states, keyed by DocumentId. Useful for collections of related
 * documents.
 * Accepts either URLs or document IDs in the input array, but all get converted to IDs
 * for the output map.
 */
export declare const useDocuments: <T>(idsOrUrls?: DocId[]) => Record<DocumentId, T>;
type DocId = DocumentId | AutomergeUrl;
export {};
//# sourceMappingURL=useDocuments.d.ts.map