"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from3, except, desc) => {
  if (from3 && typeof from3 === "object" || typeof from3 === "function") {
    for (let key of __getOwnPropNames(from3))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from3[key], enumerable: !(desc = __getOwnPropDesc(from3, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// mjs/wasm_bindgen_output/nodejs/automerge_wasm.cjs
var require_automerge_wasm = __commonJS({
  "mjs/wasm_bindgen_output/nodejs/automerge_wasm.cjs"(exports2, module2) {
    "use strict";
    var imports = {};
    imports["__wbindgen_placeholder__"] = module2.exports;
    var wasm2;
    var { TextEncoder: TextEncoder2, TextDecoder: TextDecoder2 } = require("util");
    var heap2 = new Array(128).fill(void 0);
    heap2.push(void 0, null, true, false);
    function getObject2(idx) {
      return heap2[idx];
    }
    var WASM_VECTOR_LEN2 = 0;
    var cachedUint8ArrayMemory02 = null;
    function getUint8ArrayMemory02() {
      if (cachedUint8ArrayMemory02 === null || cachedUint8ArrayMemory02.byteLength === 0) {
        cachedUint8ArrayMemory02 = new Uint8Array(wasm2.memory.buffer);
      }
      return cachedUint8ArrayMemory02;
    }
    var cachedTextEncoder2 = new TextEncoder2("utf-8");
    var encodeString2 = typeof cachedTextEncoder2.encodeInto === "function" ? function(arg, view2) {
      return cachedTextEncoder2.encodeInto(arg, view2);
    } : function(arg, view2) {
      const buf = cachedTextEncoder2.encode(arg);
      view2.set(buf);
      return {
        read: arg.length,
        written: buf.length
      };
    };
    function passStringToWasm02(arg, malloc, realloc) {
      if (realloc === void 0) {
        const buf = cachedTextEncoder2.encode(arg);
        const ptr2 = malloc(buf.length, 1) >>> 0;
        getUint8ArrayMemory02().subarray(ptr2, ptr2 + buf.length).set(buf);
        WASM_VECTOR_LEN2 = buf.length;
        return ptr2;
      }
      let len = arg.length;
      let ptr = malloc(len, 1) >>> 0;
      const mem = getUint8ArrayMemory02();
      let offset = 0;
      for (; offset < len; offset++) {
        const code = arg.charCodeAt(offset);
        if (code > 127)
          break;
        mem[ptr + offset] = code;
      }
      if (offset !== len) {
        if (offset !== 0) {
          arg = arg.slice(offset);
        }
        ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
        const view2 = getUint8ArrayMemory02().subarray(ptr + offset, ptr + len);
        const ret = encodeString2(arg, view2);
        offset += ret.written;
        ptr = realloc(ptr, len, offset, 1) >>> 0;
      }
      WASM_VECTOR_LEN2 = offset;
      return ptr;
    }
    var cachedDataViewMemory02 = null;
    function getDataViewMemory02() {
      if (cachedDataViewMemory02 === null || cachedDataViewMemory02.buffer.detached === true || cachedDataViewMemory02.buffer.detached === void 0 && cachedDataViewMemory02.buffer !== wasm2.memory.buffer) {
        cachedDataViewMemory02 = new DataView(wasm2.memory.buffer);
      }
      return cachedDataViewMemory02;
    }
    var heap_next2 = heap2.length;
    function addHeapObject2(obj) {
      if (heap_next2 === heap2.length)
        heap2.push(heap2.length + 1);
      const idx = heap_next2;
      heap_next2 = heap2[idx];
      heap2[idx] = obj;
      return idx;
    }
    function handleError2(f, args) {
      try {
        return f.apply(this, args);
      } catch (e) {
        wasm2.__wbindgen_exn_store(addHeapObject2(e));
      }
    }
    var cachedTextDecoder2 = new TextDecoder2("utf-8", { ignoreBOM: true, fatal: true });
    cachedTextDecoder2.decode();
    function getStringFromWasm02(ptr, len) {
      ptr = ptr >>> 0;
      return cachedTextDecoder2.decode(getUint8ArrayMemory02().subarray(ptr, ptr + len));
    }
    function getArrayU8FromWasm02(ptr, len) {
      ptr = ptr >>> 0;
      return getUint8ArrayMemory02().subarray(ptr / 1, ptr / 1 + len);
    }
    function dropObject2(idx) {
      if (idx < 132)
        return;
      heap2[idx] = heap_next2;
      heap_next2 = idx;
    }
    function takeObject2(idx) {
      const ret = getObject2(idx);
      dropObject2(idx);
      return ret;
    }
    function debugString2(val) {
      const type = typeof val;
      if (type == "number" || type == "boolean" || val == null) {
        return `${val}`;
      }
      if (type == "string") {
        return `"${val}"`;
      }
      if (type == "symbol") {
        const description = val.description;
        if (description == null) {
          return "Symbol";
        } else {
          return `Symbol(${description})`;
        }
      }
      if (type == "function") {
        const name = val.name;
        if (typeof name == "string" && name.length > 0) {
          return `Function(${name})`;
        } else {
          return "Function";
        }
      }
      if (Array.isArray(val)) {
        const length = val.length;
        let debug = "[";
        if (length > 0) {
          debug += debugString2(val[0]);
        }
        for (let i = 1; i < length; i++) {
          debug += ", " + debugString2(val[i]);
        }
        debug += "]";
        return debug;
      }
      const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
      let className;
      if (builtInMatches && builtInMatches.length > 1) {
        className = builtInMatches[1];
      } else {
        return toString.call(val);
      }
      if (className == "Object") {
        try {
          return "Object(" + JSON.stringify(val) + ")";
        } catch (_) {
          return "Object";
        }
      }
      if (val instanceof Error) {
        return `${val.name}: ${val.message}
${val.stack}`;
      }
      return className;
    }
    function isLikeNone2(x) {
      return x === void 0 || x === null;
    }
    function _assertClass2(instance, klass) {
      if (!(instance instanceof klass)) {
        throw new Error(`expected instance of ${klass.name}`);
      }
    }
    module2.exports.create = function(options) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.create(retptr, addHeapObject2(options));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return Automerge2.__wrap(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.load = function(data, options) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.load(retptr, addHeapObject2(data), addHeapObject2(options));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return Automerge2.__wrap(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.encodeChange = function(change2) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.encodeChange(retptr, addHeapObject2(change2));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return takeObject2(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.decodeChange = function(change2) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.decodeChange(retptr, addHeapObject2(change2));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return takeObject2(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.initSyncState = function() {
      const ret = wasm2.initSyncState();
      return SyncState2.__wrap(ret);
    };
    module2.exports.importSyncState = function(state) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.importSyncState(retptr, addHeapObject2(state));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return SyncState2.__wrap(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.exportSyncState = function(state) {
      _assertClass2(state, SyncState2);
      const ret = wasm2.exportSyncState(state.__wbg_ptr);
      return takeObject2(ret);
    };
    module2.exports.encodeSyncMessage = function(message) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.encodeSyncMessage(retptr, addHeapObject2(message));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return takeObject2(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.decodeSyncMessage = function(msg) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.decodeSyncMessage(retptr, addHeapObject2(msg));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return takeObject2(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.encodeSyncState = function(state) {
      _assertClass2(state, SyncState2);
      const ret = wasm2.encodeSyncState(state.__wbg_ptr);
      return takeObject2(ret);
    };
    module2.exports.decodeSyncState = function(data) {
      try {
        const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
        wasm2.decodeSyncState(retptr, addHeapObject2(data));
        var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
        var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
        var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
        if (r2) {
          throw takeObject2(r1);
        }
        return SyncState2.__wrap(r0);
      } finally {
        wasm2.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.TextRepresentation = Object.freeze({
      /**
       * As an array of characters and objects
       */
      Array: 0,
      "0": "Array",
      /**
       * As a single JS string
       */
      String: 1,
      "1": "String"
    });
    var AutomergeFinalization2 = typeof FinalizationRegistry === "undefined" ? { register: () => {
    }, unregister: () => {
    } } : new FinalizationRegistry((ptr) => wasm2.__wbg_automerge_free(ptr >>> 0, 1));
    var Automerge2 = class _Automerge {
      static __wrap(ptr) {
        ptr = ptr >>> 0;
        const obj = Object.create(_Automerge.prototype);
        obj.__wbg_ptr = ptr;
        AutomergeFinalization2.register(obj, obj.__wbg_ptr, obj);
        return obj;
      }
      __destroy_into_raw() {
        const ptr = this.__wbg_ptr;
        this.__wbg_ptr = 0;
        AutomergeFinalization2.unregister(this);
        return ptr;
      }
      free() {
        const ptr = this.__destroy_into_raw();
        wasm2.__wbg_automerge_free(ptr, 0);
      }
      /**
       * @param {string | null | undefined} actor
       * @param {TextRepresentation} text_rep
       * @returns {Automerge}
       */
      static new(actor, text_rep) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          var ptr0 = isLikeNone2(actor) ? 0 : passStringToWasm02(actor, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
          var len0 = WASM_VECTOR_LEN2;
          wasm2.automerge_new(retptr, ptr0, len0, text_rep);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return _Automerge.__wrap(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {string | null} [actor]
       * @returns {Automerge}
       */
      clone(actor) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          var ptr0 = isLikeNone2(actor) ? 0 : passStringToWasm02(actor, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
          var len0 = WASM_VECTOR_LEN2;
          wasm2.automerge_clone(retptr, this.__wbg_ptr, ptr0, len0);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return _Automerge.__wrap(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {string | null | undefined} actor
       * @param {any} heads
       * @returns {Automerge}
       */
      fork(actor, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          var ptr0 = isLikeNone2(actor) ? 0 : passStringToWasm02(actor, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
          var len0 = WASM_VECTOR_LEN2;
          wasm2.automerge_fork(retptr, this.__wbg_ptr, ptr0, len0, addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return _Automerge.__wrap(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @returns {any}
       */
      pendingOps() {
        const ret = wasm2.automerge_pendingOps(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @param {string | null} [message]
       * @param {number | null} [time]
       * @returns {any}
       */
      commit(message, time) {
        var ptr0 = isLikeNone2(message) ? 0 : passStringToWasm02(message, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
        var len0 = WASM_VECTOR_LEN2;
        const ret = wasm2.automerge_commit(this.__wbg_ptr, ptr0, len0, !isLikeNone2(time), isLikeNone2(time) ? 0 : time);
        return takeObject2(ret);
      }
      /**
       * @param {Automerge} other
       * @returns {Array<any>}
       */
      merge(other) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          _assertClass2(other, _Automerge);
          wasm2.automerge_merge(retptr, this.__wbg_ptr, other.__wbg_ptr);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @returns {number}
       */
      rollback() {
        const ret = wasm2.automerge_rollback(this.__wbg_ptr);
        return ret;
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null} [heads]
       * @returns {Array<any>}
       */
      keys(obj, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_keys(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null} [heads]
       * @returns {string}
       */
      text(obj, heads) {
        let deferred2_0;
        let deferred2_1;
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_text(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          var ptr1 = r0;
          var len1 = r1;
          if (r3) {
            ptr1 = 0;
            len1 = 0;
            throw takeObject2(r2);
          }
          deferred2_0 = ptr1;
          deferred2_1 = len1;
          return getStringFromWasm02(ptr1, len1);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
          wasm2.__wbindgen_free(deferred2_0, deferred2_1, 1);
        }
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null} [heads]
       * @returns {Array<any>}
       */
      spans(obj, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_spans(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {number} start
       * @param {number} delete_count
       * @param {any} text
       */
      splice(obj, start, delete_count, text) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_splice(retptr, this.__wbg_ptr, addHeapObject2(obj), start, delete_count, addHeapObject2(text));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} new_text
       */
      updateText(obj, new_text) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_updateText(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(new_text));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} args
       */
      updateSpans(obj, args) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_updateSpans(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(args));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} value
       * @param {any} datatype
       */
      push(obj, value, datatype) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_push(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(value), addHeapObject2(datatype));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} value
       * @returns {string | undefined}
       */
      pushObject(obj, value) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_pushObject(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(value));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          if (r3) {
            throw takeObject2(r2);
          }
          let v1;
          if (r0 !== 0) {
            v1 = getStringFromWasm02(r0, r1).slice();
            wasm2.__wbindgen_free(r0, r1 * 1, 1);
          }
          return v1;
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {number} index
       * @param {any} value
       * @param {any} datatype
       */
      insert(obj, index, value, datatype) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_insert(retptr, this.__wbg_ptr, addHeapObject2(obj), index, addHeapObject2(value), addHeapObject2(datatype));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {number} index
       * @param {any} args
       */
      splitBlock(obj, index, args) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_splitBlock(retptr, this.__wbg_ptr, addHeapObject2(obj), index, addHeapObject2(args));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} text
       * @param {number} index
       */
      joinBlock(text, index) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_joinBlock(retptr, this.__wbg_ptr, addHeapObject2(text), index);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} text
       * @param {number} index
       * @param {any} args
       */
      updateBlock(text, index, args) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_updateBlock(retptr, this.__wbg_ptr, addHeapObject2(text), index, addHeapObject2(args));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} text
       * @param {number} index
       * @param {Array<any> | null} [heads]
       * @returns {any}
       */
      getBlock(text, index, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getBlock(retptr, this.__wbg_ptr, addHeapObject2(text), index, isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {number} index
       * @param {any} value
       * @returns {string | undefined}
       */
      insertObject(obj, index, value) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_insertObject(retptr, this.__wbg_ptr, addHeapObject2(obj), index, addHeapObject2(value));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          if (r3) {
            throw takeObject2(r2);
          }
          let v1;
          if (r0 !== 0) {
            v1 = getStringFromWasm02(r0, r1).slice();
            wasm2.__wbindgen_free(r0, r1 * 1, 1);
          }
          return v1;
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} prop
       * @param {any} value
       * @param {any} datatype
       */
      put(obj, prop, value, datatype) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_put(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(prop), addHeapObject2(value), addHeapObject2(datatype));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} prop
       * @param {any} value
       * @returns {any}
       */
      putObject(obj, prop, value) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_putObject(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(prop), addHeapObject2(value));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} prop
       * @param {any} value
       */
      increment(obj, prop, value) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_increment(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(prop), addHeapObject2(value));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} prop
       * @param {Array<any> | null} [heads]
       * @returns {any}
       */
      get(obj, prop, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_get(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(prop), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} prop
       * @param {Array<any> | null} [heads]
       * @returns {any}
       */
      getWithType(obj, prop, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getWithType(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(prop), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null} [heads]
       * @returns {object}
       */
      objInfo(obj, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_objInfo(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} arg
       * @param {Array<any> | null} [heads]
       * @returns {Array<any>}
       */
      getAll(obj, arg, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getAll(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(arg), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} enable
       * @returns {any}
       */
      enableFreeze(enable) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_enableFreeze(retptr, this.__wbg_ptr, addHeapObject2(enable));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} datatype
       * @param {any} export_function
       * @param {any} import_function
       */
      registerDatatype(datatype, export_function, import_function) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_registerDatatype(retptr, this.__wbg_ptr, addHeapObject2(datatype), addHeapObject2(export_function), addHeapObject2(import_function));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} object
       * @param {any} meta
       * @returns {any}
       */
      applyPatches(object, meta) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_applyPatches(retptr, this.__wbg_ptr, addHeapObject2(object), addHeapObject2(meta));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} object
       * @param {any} meta
       * @returns {any}
       */
      applyAndReturnPatches(object, meta) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_applyAndReturnPatches(retptr, this.__wbg_ptr, addHeapObject2(object), addHeapObject2(meta));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @returns {Array<any>}
       */
      diffIncremental() {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_diffIncremental(retptr, this.__wbg_ptr);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      updateDiffCursor() {
        wasm2.automerge_updateDiffCursor(this.__wbg_ptr);
      }
      resetDiffCursor() {
        wasm2.automerge_resetDiffCursor(this.__wbg_ptr);
      }
      /**
       * @param {Array<any>} before
       * @param {Array<any>} after
       * @returns {Array<any>}
       */
      diff(before, after) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_diff(retptr, this.__wbg_ptr, addHeapObject2(before), addHeapObject2(after));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {Array<any>} heads
       */
      isolate(heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_isolate(retptr, this.__wbg_ptr, addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      integrate() {
        wasm2.automerge_integrate(this.__wbg_ptr);
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null} [heads]
       * @returns {number}
       */
      length(obj, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_length(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getFloat64(retptr + 8 * 0, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          if (r3) {
            throw takeObject2(r2);
          }
          return r0;
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} prop
       */
      delete(obj, prop) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_delete(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(prop));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @returns {Uint8Array}
       */
      save() {
        const ret = wasm2.automerge_save(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {Uint8Array}
       */
      saveIncremental() {
        const ret = wasm2.automerge_saveIncremental(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @param {Array<any>} heads
       * @returns {Uint8Array}
       */
      saveSince(heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_saveSince(retptr, this.__wbg_ptr, addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @returns {Uint8Array}
       */
      saveNoCompress() {
        const ret = wasm2.automerge_saveNoCompress(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {Uint8Array}
       */
      saveAndVerify() {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_saveAndVerify(retptr, this.__wbg_ptr);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {Uint8Array} data
       * @returns {number}
       */
      loadIncremental(data) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_loadIncremental(retptr, this.__wbg_ptr, addHeapObject2(data));
          var r0 = getDataViewMemory02().getFloat64(retptr + 8 * 0, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          if (r3) {
            throw takeObject2(r2);
          }
          return r0;
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} changes
       */
      applyChanges(changes) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_applyChanges(retptr, this.__wbg_ptr, addHeapObject2(changes));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} have_deps
       * @returns {Array<any>}
       */
      getChanges(have_deps) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getChanges(retptr, this.__wbg_ptr, addHeapObject2(have_deps));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} hash
       * @returns {any}
       */
      getChangeByHash(hash) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getChangeByHash(retptr, this.__wbg_ptr, addHeapObject2(hash));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} hash
       * @returns {any}
       */
      getDecodedChangeByHash(hash) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getDecodedChangeByHash(retptr, this.__wbg_ptr, addHeapObject2(hash));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {Automerge} other
       * @returns {Array<any>}
       */
      getChangesAdded(other) {
        _assertClass2(other, _Automerge);
        const ret = wasm2.automerge_getChangesAdded(this.__wbg_ptr, other.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {Array<any>}
       */
      getHeads() {
        const ret = wasm2.automerge_getHeads(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {string}
       */
      getActorId() {
        let deferred1_0;
        let deferred1_1;
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getActorId(retptr, this.__wbg_ptr);
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          deferred1_0 = r0;
          deferred1_1 = r1;
          return getStringFromWasm02(r0, r1);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
          wasm2.__wbindgen_free(deferred1_0, deferred1_1, 1);
        }
      }
      /**
       * @returns {any}
       */
      getLastLocalChange() {
        const ret = wasm2.automerge_getLastLocalChange(this.__wbg_ptr);
        return takeObject2(ret);
      }
      dump() {
        wasm2.automerge_dump(this.__wbg_ptr);
      }
      /**
       * @param {Array<any> | null} [heads]
       * @returns {Array<any>}
       */
      getMissingDeps(heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getMissingDeps(retptr, this.__wbg_ptr, isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {SyncState} state
       * @param {Uint8Array} message
       */
      receiveSyncMessage(state, message) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          _assertClass2(state, SyncState2);
          wasm2.automerge_receiveSyncMessage(retptr, this.__wbg_ptr, state.__wbg_ptr, addHeapObject2(message));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {SyncState} state
       * @returns {any}
       */
      generateSyncMessage(state) {
        _assertClass2(state, SyncState2);
        const ret = wasm2.automerge_generateSyncMessage(this.__wbg_ptr, state.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @param {any} meta
       * @returns {any}
       */
      toJS(meta) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_toJS(retptr, this.__wbg_ptr, addHeapObject2(meta));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null | undefined} heads
       * @param {any} meta
       * @returns {any}
       */
      materialize(obj, heads, meta) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_materialize(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads), addHeapObject2(meta));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} position
       * @param {Array<any> | null | undefined} heads
       * @param {any} move_cursor
       * @returns {string}
       */
      getCursor(obj, position, heads, move_cursor) {
        let deferred2_0;
        let deferred2_1;
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getCursor(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(position), isLikeNone2(heads) ? 0 : addHeapObject2(heads), addHeapObject2(move_cursor));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          var ptr1 = r0;
          var len1 = r1;
          if (r3) {
            ptr1 = 0;
            len1 = 0;
            throw takeObject2(r2);
          }
          deferred2_0 = ptr1;
          deferred2_1 = len1;
          return getStringFromWasm02(ptr1, len1);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
          wasm2.__wbindgen_free(deferred2_0, deferred2_1, 1);
        }
      }
      /**
       * @param {any} obj
       * @param {any} cursor
       * @param {Array<any> | null} [heads]
       * @returns {number}
       */
      getCursorPosition(obj, cursor, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_getCursorPosition(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(cursor), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getFloat64(retptr + 8 * 0, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          var r3 = getDataViewMemory02().getInt32(retptr + 4 * 3, true);
          if (r3) {
            throw takeObject2(r2);
          }
          return r0;
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {string | null} [message]
       * @param {number | null} [time]
       * @returns {any}
       */
      emptyChange(message, time) {
        var ptr0 = isLikeNone2(message) ? 0 : passStringToWasm02(message, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
        var len0 = WASM_VECTOR_LEN2;
        const ret = wasm2.automerge_emptyChange(this.__wbg_ptr, ptr0, len0, !isLikeNone2(time), isLikeNone2(time) ? 0 : time);
        return takeObject2(ret);
      }
      /**
       * @param {any} obj
       * @param {any} range
       * @param {any} name
       * @param {any} value
       * @param {any} datatype
       */
      mark(obj, range, name, value, datatype) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_mark(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(range), addHeapObject2(name), addHeapObject2(value), addHeapObject2(datatype));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {any} range
       * @param {any} name
       */
      unmark(obj, range, name) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_unmark(retptr, this.__wbg_ptr, addHeapObject2(obj), addHeapObject2(range), addHeapObject2(name));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {Array<any> | null} [heads]
       * @returns {any}
       */
      marks(obj, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_marks(retptr, this.__wbg_ptr, addHeapObject2(obj), isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} obj
       * @param {number} index
       * @param {Array<any> | null} [heads]
       * @returns {object}
       */
      marksAt(obj, index, heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.automerge_marksAt(retptr, this.__wbg_ptr, addHeapObject2(obj), index, isLikeNone2(heads) ? 0 : addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          var r2 = getDataViewMemory02().getInt32(retptr + 4 * 2, true);
          if (r2) {
            throw takeObject2(r1);
          }
          return takeObject2(r0);
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {SyncState} state
       * @returns {any}
       */
      hasOurChanges(state) {
        _assertClass2(state, SyncState2);
        const ret = wasm2.automerge_hasOurChanges(this.__wbg_ptr, state.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {any}
       */
      topoHistoryTraversal() {
        const ret = wasm2.automerge_topoHistoryTraversal(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {any}
       */
      stats() {
        const ret = wasm2.automerge_stats(this.__wbg_ptr);
        return takeObject2(ret);
      }
    };
    module2.exports.Automerge = Automerge2;
    var SyncStateFinalization2 = typeof FinalizationRegistry === "undefined" ? { register: () => {
    }, unregister: () => {
    } } : new FinalizationRegistry((ptr) => wasm2.__wbg_syncstate_free(ptr >>> 0, 1));
    var SyncState2 = class _SyncState {
      static __wrap(ptr) {
        ptr = ptr >>> 0;
        const obj = Object.create(_SyncState.prototype);
        obj.__wbg_ptr = ptr;
        SyncStateFinalization2.register(obj, obj.__wbg_ptr, obj);
        return obj;
      }
      __destroy_into_raw() {
        const ptr = this.__wbg_ptr;
        this.__wbg_ptr = 0;
        SyncStateFinalization2.unregister(this);
        return ptr;
      }
      free() {
        const ptr = this.__destroy_into_raw();
        wasm2.__wbg_syncstate_free(ptr, 0);
      }
      /**
       * @returns {any}
       */
      get sharedHeads() {
        const ret = wasm2.syncstate_sharedHeads(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @returns {any}
       */
      get lastSentHeads() {
        const ret = wasm2.syncstate_lastSentHeads(this.__wbg_ptr);
        return takeObject2(ret);
      }
      /**
       * @param {any} heads
       */
      set lastSentHeads(heads) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.syncstate_set_lastSentHeads(retptr, this.__wbg_ptr, addHeapObject2(heads));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @param {any} hashes
       */
      set sentHashes(hashes) {
        try {
          const retptr = wasm2.__wbindgen_add_to_stack_pointer(-16);
          wasm2.syncstate_set_sentHashes(retptr, this.__wbg_ptr, addHeapObject2(hashes));
          var r0 = getDataViewMemory02().getInt32(retptr + 4 * 0, true);
          var r1 = getDataViewMemory02().getInt32(retptr + 4 * 1, true);
          if (r1) {
            throw takeObject2(r0);
          }
        } finally {
          wasm2.__wbindgen_add_to_stack_pointer(16);
        }
      }
      /**
       * @returns {SyncState}
       */
      clone() {
        const ret = wasm2.syncstate_clone(this.__wbg_ptr);
        return _SyncState.__wrap(ret);
      }
    };
    module2.exports.SyncState = SyncState2;
    module2.exports.__wbg_String_fed4d24b68977888 = function(arg0, arg1) {
      const ret = String(getObject2(arg1));
      const ptr1 = passStringToWasm02(ret, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN2;
      getDataViewMemory02().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory02().setInt32(arg0 + 4 * 0, ptr1, true);
    };
    module2.exports.__wbg_apply_eb9e9b97497f91e4 = function() {
      return handleError2(function(arg0, arg1, arg2) {
        const ret = Reflect.apply(getObject2(arg0), getObject2(arg1), getObject2(arg2));
        return addHeapObject2(ret);
      }, arguments);
    };
    module2.exports.__wbg_assign_3627b8559449930a = function(arg0, arg1) {
      const ret = Object.assign(getObject2(arg0), getObject2(arg1));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_buffer_609cc3eee51ed158 = function(arg0) {
      const ret = getObject2(arg0).buffer;
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_call_672a4d21634d4a24 = function() {
      return handleError2(function(arg0, arg1) {
        const ret = getObject2(arg0).call(getObject2(arg1));
        return addHeapObject2(ret);
      }, arguments);
    };
    module2.exports.__wbg_call_7cccdd69e0791ae2 = function() {
      return handleError2(function(arg0, arg1, arg2) {
        const ret = getObject2(arg0).call(getObject2(arg1), getObject2(arg2));
        return addHeapObject2(ret);
      }, arguments);
    };
    module2.exports.__wbg_concat_9de968491c4340cf = function(arg0, arg1) {
      const ret = getObject2(arg0).concat(getObject2(arg1));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_defineProperty_a3ddad9901e2d29e = function(arg0, arg1, arg2) {
      const ret = Object.defineProperty(getObject2(arg0), getObject2(arg1), getObject2(arg2));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_deleteProperty_96363d4a1d977c97 = function() {
      return handleError2(function(arg0, arg1) {
        const ret = Reflect.deleteProperty(getObject2(arg0), getObject2(arg1));
        return ret;
      }, arguments);
    };
    module2.exports.__wbg_done_769e5ede4b31c67b = function(arg0) {
      const ret = getObject2(arg0).done;
      return ret;
    };
    module2.exports.__wbg_entries_3265d4158b33e5dc = function(arg0) {
      const ret = Object.entries(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_error_7534b8e9a36f1ab4 = function(arg0, arg1) {
      let deferred0_0;
      let deferred0_1;
      try {
        deferred0_0 = arg0;
        deferred0_1 = arg1;
        console.error(getStringFromWasm02(arg0, arg1));
      } finally {
        wasm2.__wbindgen_free(deferred0_0, deferred0_1, 1);
      }
    };
    module2.exports.__wbg_for_4ff07bddd743c5e7 = function(arg0, arg1) {
      const ret = Symbol.for(getStringFromWasm02(arg0, arg1));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_freeze_ef6d70cf38e8d948 = function(arg0) {
      const ret = Object.freeze(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_from_2a5d3e218e67aa85 = function(arg0) {
      const ret = Array.from(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_getRandomValues_3d90134a348e46b3 = function() {
      return handleError2(function(arg0, arg1) {
        globalThis.crypto.getRandomValues(getArrayU8FromWasm02(arg0, arg1));
      }, arguments);
    };
    module2.exports.__wbg_getTime_46267b1c24877e30 = function(arg0) {
      const ret = getObject2(arg0).getTime();
      return ret;
    };
    module2.exports.__wbg_get_67b2ba62fc30de12 = function() {
      return handleError2(function(arg0, arg1) {
        const ret = Reflect.get(getObject2(arg0), getObject2(arg1));
        return addHeapObject2(ret);
      }, arguments);
    };
    module2.exports.__wbg_get_b9b93047fe3cf45b = function(arg0, arg1) {
      const ret = getObject2(arg0)[arg1 >>> 0];
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_instanceof_ArrayBuffer_e14585432e3737fc = function(arg0) {
      let result;
      try {
        result = getObject2(arg0) instanceof ArrayBuffer;
      } catch (_) {
        result = false;
      }
      const ret = result;
      return ret;
    };
    module2.exports.__wbg_instanceof_Date_e9a9be8b9cea7890 = function(arg0) {
      let result;
      try {
        result = getObject2(arg0) instanceof Date;
      } catch (_) {
        result = false;
      }
      const ret = result;
      return ret;
    };
    module2.exports.__wbg_instanceof_Object_7f2dcef8f78644a4 = function(arg0) {
      let result;
      try {
        result = getObject2(arg0) instanceof Object;
      } catch (_) {
        result = false;
      }
      const ret = result;
      return ret;
    };
    module2.exports.__wbg_instanceof_Uint8Array_17156bcf118086a9 = function(arg0) {
      let result;
      try {
        result = getObject2(arg0) instanceof Uint8Array;
      } catch (_) {
        result = false;
      }
      const ret = result;
      return ret;
    };
    module2.exports.__wbg_isArray_a1eab7e0d067391b = function(arg0) {
      const ret = Array.isArray(getObject2(arg0));
      return ret;
    };
    module2.exports.__wbg_iterator_9a24c88df860dc65 = function() {
      const ret = Symbol.iterator;
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_keys_5c77a08ddc2fb8a6 = function(arg0) {
      const ret = Object.keys(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_length_a446193dc22c12f8 = function(arg0) {
      const ret = getObject2(arg0).length;
      return ret;
    };
    module2.exports.__wbg_length_d56737991078581b = function(arg0) {
      const ret = getObject2(arg0).length;
      return ret;
    };
    module2.exports.__wbg_length_e2d2a49132c1b256 = function(arg0) {
      const ret = getObject2(arg0).length;
      return ret;
    };
    module2.exports.__wbg_log_1ae1e9f741096e91 = function(arg0, arg1) {
      console.log(getObject2(arg0), getObject2(arg1));
    };
    module2.exports.__wbg_log_c222819a41e063d3 = function(arg0) {
      console.log(getObject2(arg0));
    };
    module2.exports.__wbg_new_1ab78df5e132f715 = function(arg0, arg1) {
      const ret = new RangeError(getStringFromWasm02(arg0, arg1));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_new_31a97dac4f10fab7 = function(arg0) {
      const ret = new Date(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_new_405e22f390576ce2 = function() {
      const ret = new Object();
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_new_78feb108b6472713 = function() {
      const ret = new Array();
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_new_8a6f238a6ece86ea = function() {
      const ret = new Error();
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_new_a12002a7f91c75be = function(arg0) {
      const ret = new Uint8Array(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_new_c68d7209be747379 = function(arg0, arg1) {
      const ret = new Error(getStringFromWasm02(arg0, arg1));
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_newwithbyteoffsetandlength_d97e637ebe145a9a = function(arg0, arg1, arg2) {
      const ret = new Uint8Array(getObject2(arg0), arg1 >>> 0, arg2 >>> 0);
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_next_25feadfc0913fea9 = function(arg0) {
      const ret = getObject2(arg0).next;
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_next_6574e1a8a62d1055 = function() {
      return handleError2(function(arg0) {
        const ret = getObject2(arg0).next();
        return addHeapObject2(ret);
      }, arguments);
    };
    module2.exports.__wbg_ownKeys_3930041068756f1f = function() {
      return handleError2(function(arg0) {
        const ret = Reflect.ownKeys(getObject2(arg0));
        return addHeapObject2(ret);
      }, arguments);
    };
    module2.exports.__wbg_push_737cfc8c1432c2c6 = function(arg0, arg1) {
      const ret = getObject2(arg0).push(getObject2(arg1));
      return ret;
    };
    module2.exports.__wbg_set_37837023f3d740e8 = function(arg0, arg1, arg2) {
      getObject2(arg0)[arg1 >>> 0] = takeObject2(arg2);
    };
    module2.exports.__wbg_set_3fda3bac07393de4 = function(arg0, arg1, arg2) {
      getObject2(arg0)[takeObject2(arg1)] = takeObject2(arg2);
    };
    module2.exports.__wbg_set_65595bdd868b3009 = function(arg0, arg1, arg2) {
      getObject2(arg0).set(getObject2(arg1), arg2 >>> 0);
    };
    module2.exports.__wbg_set_bb8cecf6a62b9f46 = function() {
      return handleError2(function(arg0, arg1, arg2) {
        const ret = Reflect.set(getObject2(arg0), getObject2(arg1), getObject2(arg2));
        return ret;
      }, arguments);
    };
    module2.exports.__wbg_slice_972c243648c9fd2e = function(arg0, arg1, arg2) {
      const ret = getObject2(arg0).slice(arg1 >>> 0, arg2 >>> 0);
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_stack_0ed75d68575b0f3c = function(arg0, arg1) {
      const ret = getObject2(arg1).stack;
      const ptr1 = passStringToWasm02(ret, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN2;
      getDataViewMemory02().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory02().setInt32(arg0 + 4 * 0, ptr1, true);
    };
    module2.exports.__wbg_toString_66ab719c2a98bdf1 = function(arg0) {
      const ret = getObject2(arg0).toString();
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_unshift_c290010f73f04fb1 = function(arg0, arg1) {
      const ret = getObject2(arg0).unshift(getObject2(arg1));
      return ret;
    };
    module2.exports.__wbg_value_cd1ffa7b1ab794f1 = function(arg0) {
      const ret = getObject2(arg0).value;
      return addHeapObject2(ret);
    };
    module2.exports.__wbg_values_fcb8ba8c0aad8b58 = function(arg0) {
      const ret = Object.values(getObject2(arg0));
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_bigint_from_i64 = function(arg0) {
      const ret = arg0;
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_bigint_from_u64 = function(arg0) {
      const ret = BigInt.asUintN(64, arg0);
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_boolean_get = function(arg0) {
      const v = getObject2(arg0);
      const ret = typeof v === "boolean" ? v ? 1 : 0 : 2;
      return ret;
    };
    module2.exports.__wbindgen_debug_string = function(arg0, arg1) {
      const ret = debugString2(getObject2(arg1));
      const ptr1 = passStringToWasm02(ret, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN2;
      getDataViewMemory02().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory02().setInt32(arg0 + 4 * 0, ptr1, true);
    };
    module2.exports.__wbindgen_error_new = function(arg0, arg1) {
      const ret = new Error(getStringFromWasm02(arg0, arg1));
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_is_array = function(arg0) {
      const ret = Array.isArray(getObject2(arg0));
      return ret;
    };
    module2.exports.__wbindgen_is_function = function(arg0) {
      const ret = typeof getObject2(arg0) === "function";
      return ret;
    };
    module2.exports.__wbindgen_is_null = function(arg0) {
      const ret = getObject2(arg0) === null;
      return ret;
    };
    module2.exports.__wbindgen_is_object = function(arg0) {
      const val = getObject2(arg0);
      const ret = typeof val === "object" && val !== null;
      return ret;
    };
    module2.exports.__wbindgen_is_string = function(arg0) {
      const ret = typeof getObject2(arg0) === "string";
      return ret;
    };
    module2.exports.__wbindgen_is_undefined = function(arg0) {
      const ret = getObject2(arg0) === void 0;
      return ret;
    };
    module2.exports.__wbindgen_json_serialize = function(arg0, arg1) {
      const obj = getObject2(arg1);
      const ret = JSON.stringify(obj === void 0 ? null : obj);
      const ptr1 = passStringToWasm02(ret, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN2;
      getDataViewMemory02().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory02().setInt32(arg0 + 4 * 0, ptr1, true);
    };
    module2.exports.__wbindgen_jsval_loose_eq = function(arg0, arg1) {
      const ret = getObject2(arg0) == getObject2(arg1);
      return ret;
    };
    module2.exports.__wbindgen_memory = function() {
      const ret = wasm2.memory;
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_number_get = function(arg0, arg1) {
      const obj = getObject2(arg1);
      const ret = typeof obj === "number" ? obj : void 0;
      getDataViewMemory02().setFloat64(arg0 + 8 * 1, isLikeNone2(ret) ? 0 : ret, true);
      getDataViewMemory02().setInt32(arg0 + 4 * 0, !isLikeNone2(ret), true);
    };
    module2.exports.__wbindgen_number_new = function(arg0) {
      const ret = arg0;
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_object_clone_ref = function(arg0) {
      const ret = getObject2(arg0);
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_object_drop_ref = function(arg0) {
      takeObject2(arg0);
    };
    module2.exports.__wbindgen_string_get = function(arg0, arg1) {
      const obj = getObject2(arg1);
      const ret = typeof obj === "string" ? obj : void 0;
      var ptr1 = isLikeNone2(ret) ? 0 : passStringToWasm02(ret, wasm2.__wbindgen_malloc, wasm2.__wbindgen_realloc);
      var len1 = WASM_VECTOR_LEN2;
      getDataViewMemory02().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory02().setInt32(arg0 + 4 * 0, ptr1, true);
    };
    module2.exports.__wbindgen_string_new = function(arg0, arg1) {
      const ret = getStringFromWasm02(arg0, arg1);
      return addHeapObject2(ret);
    };
    module2.exports.__wbindgen_throw = function(arg0, arg1) {
      throw new Error(getStringFromWasm02(arg0, arg1));
    };
    var path = require("path").join(__dirname, "automerge_wasm_bg.wasm");
    var bytes = require("fs").readFileSync(path);
    var wasmModule = new WebAssembly.Module(bytes);
    var wasmInstance = new WebAssembly.Instance(wasmModule, imports);
    wasm2 = wasmInstance.exports;
    module2.exports.__wasm = wasm2;
  }
});

// mjs/entrypoints/fullfat_node.js
var fullfat_node_exports = {};
__export(fullfat_node_exports, {
  Counter: () => Counter,
  Float64: () => Float64,
  Int: () => Int,
  Text: () => Text,
  Uint: () => Uint,
  applyChanges: () => applyChanges,
  change: () => change,
  changeAt: () => changeAt,
  clone: () => clone,
  decodeChange: () => decodeChange2,
  decodeSyncMessage: () => decodeSyncMessage2,
  decodeSyncState: () => decodeSyncState2,
  deleteAt: () => deleteAt,
  diff: () => diff,
  dump: () => dump,
  emptyChange: () => emptyChange,
  encodeChange: () => encodeChange2,
  encodeSyncMessage: () => encodeSyncMessage2,
  encodeSyncState: () => encodeSyncState2,
  equals: () => equals,
  free: () => free,
  from: () => from,
  generateSyncMessage: () => generateSyncMessage,
  getActorId: () => getActorId,
  getAllChanges: () => getAllChanges,
  getBackend: () => getBackend,
  getChanges: () => getChanges,
  getConflicts: () => getConflicts,
  getHeads: () => getHeads,
  getHistory: () => getHistory,
  getLastLocalChange: () => getLastLocalChange,
  getMissingDeps: () => getMissingDeps,
  getObjectId: () => getObjectId,
  hasHeads: () => hasHeads,
  hasOurChanges: () => hasOurChanges,
  init: () => init,
  initSyncState: () => initSyncState2,
  initializeBase64Wasm: () => initializeBase64Wasm,
  initializeWasm: () => initializeWasm,
  insertAt: () => insertAt,
  inspectChange: () => inspectChange,
  isAutomerge: () => isAutomerge,
  isText: () => isText,
  isWasmInitialized: () => isWasmInitialized,
  load: () => load2,
  loadIncremental: () => loadIncremental,
  merge: () => merge,
  next: () => next_slim_exports,
  receiveSyncMessage: () => receiveSyncMessage,
  save: () => save,
  saveIncremental: () => saveIncremental,
  saveSince: () => saveSince,
  stats: () => stats,
  toJS: () => toJS,
  topoHistoryTraversal: () => topoHistoryTraversal,
  use: () => use,
  uuid: () => uuid,
  view: () => view,
  wasmInitialized: () => wasmInitialized
});
module.exports = __toCommonJS(fullfat_node_exports);

// mjs/wasm_bindgen_output/web/automerge_wasm.js
var automerge_wasm_exports = {};
__export(automerge_wasm_exports, {
  Automerge: () => Automerge,
  SyncState: () => SyncState,
  TextRepresentation: () => TextRepresentation,
  create: () => create,
  decodeChange: () => decodeChange,
  decodeSyncMessage: () => decodeSyncMessage,
  decodeSyncState: () => decodeSyncState,
  default: () => automerge_wasm_default,
  encodeChange: () => encodeChange,
  encodeSyncMessage: () => encodeSyncMessage,
  encodeSyncState: () => encodeSyncState,
  exportSyncState: () => exportSyncState,
  importSyncState: () => importSyncState,
  initSync: () => initSync,
  initSyncState: () => initSyncState,
  load: () => load
});
var import_meta = {};
var wasm;
var heap = new Array(128).fill(void 0);
heap.push(void 0, null, true, false);
function getObject(idx) {
  return heap[idx];
}
var WASM_VECTOR_LEN = 0;
var cachedUint8ArrayMemory0 = null;
function getUint8ArrayMemory0() {
  if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
    cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8ArrayMemory0;
}
var cachedTextEncoder = typeof TextEncoder !== "undefined" ? new TextEncoder("utf-8") : { encode: () => {
  throw Error("TextEncoder not available");
} };
var encodeString = typeof cachedTextEncoder.encodeInto === "function" ? function(arg, view2) {
  return cachedTextEncoder.encodeInto(arg, view2);
} : function(arg, view2) {
  const buf = cachedTextEncoder.encode(arg);
  view2.set(buf);
  return {
    read: arg.length,
    written: buf.length
  };
};
function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === void 0) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr2 = malloc(buf.length, 1) >>> 0;
    getUint8ArrayMemory0().subarray(ptr2, ptr2 + buf.length).set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr2;
  }
  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;
  const mem = getUint8ArrayMemory0();
  let offset = 0;
  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 127)
      break;
    mem[ptr + offset] = code;
  }
  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
    const view2 = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view2);
    offset += ret.written;
    ptr = realloc(ptr, len, offset, 1) >>> 0;
  }
  WASM_VECTOR_LEN = offset;
  return ptr;
}
var cachedDataViewMemory0 = null;
function getDataViewMemory0() {
  if (cachedDataViewMemory0 === null || cachedDataViewMemory0.buffer.detached === true || cachedDataViewMemory0.buffer.detached === void 0 && cachedDataViewMemory0.buffer !== wasm.memory.buffer) {
    cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
  }
  return cachedDataViewMemory0;
}
var heap_next = heap.length;
function addHeapObject(obj) {
  if (heap_next === heap.length)
    heap.push(heap.length + 1);
  const idx = heap_next;
  heap_next = heap[idx];
  heap[idx] = obj;
  return idx;
}
function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    wasm.__wbindgen_exn_store(addHeapObject(e));
  }
}
var cachedTextDecoder = typeof TextDecoder !== "undefined" ? new TextDecoder("utf-8", { ignoreBOM: true, fatal: true }) : { decode: () => {
  throw Error("TextDecoder not available");
} };
if (typeof TextDecoder !== "undefined") {
  cachedTextDecoder.decode();
}
function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}
function getArrayU8FromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return getUint8ArrayMemory0().subarray(ptr / 1, ptr / 1 + len);
}
function dropObject(idx) {
  if (idx < 132)
    return;
  heap[idx] = heap_next;
  heap_next = idx;
}
function takeObject(idx) {
  const ret = getObject(idx);
  dropObject(idx);
  return ret;
}
function debugString(val) {
  const type = typeof val;
  if (type == "number" || type == "boolean" || val == null) {
    return `${val}`;
  }
  if (type == "string") {
    return `"${val}"`;
  }
  if (type == "symbol") {
    const description = val.description;
    if (description == null) {
      return "Symbol";
    } else {
      return `Symbol(${description})`;
    }
  }
  if (type == "function") {
    const name = val.name;
    if (typeof name == "string" && name.length > 0) {
      return `Function(${name})`;
    } else {
      return "Function";
    }
  }
  if (Array.isArray(val)) {
    const length = val.length;
    let debug = "[";
    if (length > 0) {
      debug += debugString(val[0]);
    }
    for (let i = 1; i < length; i++) {
      debug += ", " + debugString(val[i]);
    }
    debug += "]";
    return debug;
  }
  const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
  let className;
  if (builtInMatches && builtInMatches.length > 1) {
    className = builtInMatches[1];
  } else {
    return toString.call(val);
  }
  if (className == "Object") {
    try {
      return "Object(" + JSON.stringify(val) + ")";
    } catch (_) {
      return "Object";
    }
  }
  if (val instanceof Error) {
    return `${val.name}: ${val.message}
${val.stack}`;
  }
  return className;
}
function isLikeNone(x) {
  return x === void 0 || x === null;
}
function _assertClass(instance, klass) {
  if (!(instance instanceof klass)) {
    throw new Error(`expected instance of ${klass.name}`);
  }
}
function create(options) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.create(retptr, addHeapObject(options));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return Automerge.__wrap(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function load(data, options) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.load(retptr, addHeapObject(data), addHeapObject(options));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return Automerge.__wrap(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function encodeChange(change2) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.encodeChange(retptr, addHeapObject(change2));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function decodeChange(change2) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.decodeChange(retptr, addHeapObject(change2));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function initSyncState() {
  const ret = wasm.initSyncState();
  return SyncState.__wrap(ret);
}
function importSyncState(state) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.importSyncState(retptr, addHeapObject(state));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return SyncState.__wrap(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function exportSyncState(state) {
  _assertClass(state, SyncState);
  const ret = wasm.exportSyncState(state.__wbg_ptr);
  return takeObject(ret);
}
function encodeSyncMessage(message) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.encodeSyncMessage(retptr, addHeapObject(message));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function decodeSyncMessage(msg) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.decodeSyncMessage(retptr, addHeapObject(msg));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return takeObject(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
function encodeSyncState(state) {
  _assertClass(state, SyncState);
  const ret = wasm.encodeSyncState(state.__wbg_ptr);
  return takeObject(ret);
}
function decodeSyncState(data) {
  try {
    const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
    wasm.decodeSyncState(retptr, addHeapObject(data));
    var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
    var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
    var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
    if (r2) {
      throw takeObject(r1);
    }
    return SyncState.__wrap(r0);
  } finally {
    wasm.__wbindgen_add_to_stack_pointer(16);
  }
}
var TextRepresentation = Object.freeze({
  /**
   * As an array of characters and objects
   */
  Array: 0,
  "0": "Array",
  /**
   * As a single JS string
   */
  String: 1,
  "1": "String"
});
var AutomergeFinalization = typeof FinalizationRegistry === "undefined" ? { register: () => {
}, unregister: () => {
} } : new FinalizationRegistry((ptr) => wasm.__wbg_automerge_free(ptr >>> 0, 1));
var Automerge = class _Automerge {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(_Automerge.prototype);
    obj.__wbg_ptr = ptr;
    AutomergeFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    AutomergeFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_automerge_free(ptr, 0);
  }
  /**
   * @param {string | null | undefined} actor
   * @param {TextRepresentation} text_rep
   * @returns {Automerge}
   */
  static new(actor, text_rep) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      var ptr0 = isLikeNone(actor) ? 0 : passStringToWasm0(actor, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len0 = WASM_VECTOR_LEN;
      wasm.automerge_new(retptr, ptr0, len0, text_rep);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return _Automerge.__wrap(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null} [actor]
   * @returns {Automerge}
   */
  clone(actor) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      var ptr0 = isLikeNone(actor) ? 0 : passStringToWasm0(actor, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len0 = WASM_VECTOR_LEN;
      wasm.automerge_clone(retptr, this.__wbg_ptr, ptr0, len0);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return _Automerge.__wrap(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null | undefined} actor
   * @param {any} heads
   * @returns {Automerge}
   */
  fork(actor, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      var ptr0 = isLikeNone(actor) ? 0 : passStringToWasm0(actor, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len0 = WASM_VECTOR_LEN;
      wasm.automerge_fork(retptr, this.__wbg_ptr, ptr0, len0, addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return _Automerge.__wrap(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {any}
   */
  pendingOps() {
    const ret = wasm.automerge_pendingOps(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {string | null} [message]
   * @param {number | null} [time]
   * @returns {any}
   */
  commit(message, time) {
    var ptr0 = isLikeNone(message) ? 0 : passStringToWasm0(message, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    const ret = wasm.automerge_commit(this.__wbg_ptr, ptr0, len0, !isLikeNone(time), isLikeNone(time) ? 0 : time);
    return takeObject(ret);
  }
  /**
   * @param {Automerge} other
   * @returns {Array<any>}
   */
  merge(other) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      _assertClass(other, _Automerge);
      wasm.automerge_merge(retptr, this.__wbg_ptr, other.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {number}
   */
  rollback() {
    const ret = wasm.automerge_rollback(this.__wbg_ptr);
    return ret;
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null} [heads]
   * @returns {Array<any>}
   */
  keys(obj, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_keys(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null} [heads]
   * @returns {string}
   */
  text(obj, heads) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_text(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null} [heads]
   * @returns {Array<any>}
   */
  spans(obj, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_spans(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {number} start
   * @param {number} delete_count
   * @param {any} text
   */
  splice(obj, start, delete_count, text) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_splice(retptr, this.__wbg_ptr, addHeapObject(obj), start, delete_count, addHeapObject(text));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} new_text
   */
  updateText(obj, new_text) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_updateText(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(new_text));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} args
   */
  updateSpans(obj, args) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_updateSpans(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(args));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} value
   * @param {any} datatype
   */
  push(obj, value, datatype) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_push(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(value), addHeapObject(datatype));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} value
   * @returns {string | undefined}
   */
  pushObject(obj, value) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_pushObject(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(value));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      let v1;
      if (r0 !== 0) {
        v1 = getStringFromWasm0(r0, r1).slice();
        wasm.__wbindgen_free(r0, r1 * 1, 1);
      }
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {number} index
   * @param {any} value
   * @param {any} datatype
   */
  insert(obj, index, value, datatype) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_insert(retptr, this.__wbg_ptr, addHeapObject(obj), index, addHeapObject(value), addHeapObject(datatype));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {number} index
   * @param {any} args
   */
  splitBlock(obj, index, args) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_splitBlock(retptr, this.__wbg_ptr, addHeapObject(obj), index, addHeapObject(args));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} text
   * @param {number} index
   */
  joinBlock(text, index) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_joinBlock(retptr, this.__wbg_ptr, addHeapObject(text), index);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} text
   * @param {number} index
   * @param {any} args
   */
  updateBlock(text, index, args) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_updateBlock(retptr, this.__wbg_ptr, addHeapObject(text), index, addHeapObject(args));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} text
   * @param {number} index
   * @param {Array<any> | null} [heads]
   * @returns {any}
   */
  getBlock(text, index, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getBlock(retptr, this.__wbg_ptr, addHeapObject(text), index, isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {number} index
   * @param {any} value
   * @returns {string | undefined}
   */
  insertObject(obj, index, value) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_insertObject(retptr, this.__wbg_ptr, addHeapObject(obj), index, addHeapObject(value));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      let v1;
      if (r0 !== 0) {
        v1 = getStringFromWasm0(r0, r1).slice();
        wasm.__wbindgen_free(r0, r1 * 1, 1);
      }
      return v1;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} prop
   * @param {any} value
   * @param {any} datatype
   */
  put(obj, prop, value, datatype) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_put(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(prop), addHeapObject(value), addHeapObject(datatype));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} prop
   * @param {any} value
   * @returns {any}
   */
  putObject(obj, prop, value) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_putObject(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(prop), addHeapObject(value));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} prop
   * @param {any} value
   */
  increment(obj, prop, value) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_increment(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(prop), addHeapObject(value));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} prop
   * @param {Array<any> | null} [heads]
   * @returns {any}
   */
  get(obj, prop, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_get(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(prop), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} prop
   * @param {Array<any> | null} [heads]
   * @returns {any}
   */
  getWithType(obj, prop, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getWithType(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(prop), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null} [heads]
   * @returns {object}
   */
  objInfo(obj, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_objInfo(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} arg
   * @param {Array<any> | null} [heads]
   * @returns {Array<any>}
   */
  getAll(obj, arg, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getAll(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(arg), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} enable
   * @returns {any}
   */
  enableFreeze(enable) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_enableFreeze(retptr, this.__wbg_ptr, addHeapObject(enable));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} datatype
   * @param {any} export_function
   * @param {any} import_function
   */
  registerDatatype(datatype, export_function, import_function) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_registerDatatype(retptr, this.__wbg_ptr, addHeapObject(datatype), addHeapObject(export_function), addHeapObject(import_function));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} object
   * @param {any} meta
   * @returns {any}
   */
  applyPatches(object, meta) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_applyPatches(retptr, this.__wbg_ptr, addHeapObject(object), addHeapObject(meta));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} object
   * @param {any} meta
   * @returns {any}
   */
  applyAndReturnPatches(object, meta) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_applyAndReturnPatches(retptr, this.__wbg_ptr, addHeapObject(object), addHeapObject(meta));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {Array<any>}
   */
  diffIncremental() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_diffIncremental(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  updateDiffCursor() {
    wasm.automerge_updateDiffCursor(this.__wbg_ptr);
  }
  resetDiffCursor() {
    wasm.automerge_resetDiffCursor(this.__wbg_ptr);
  }
  /**
   * @param {Array<any>} before
   * @param {Array<any>} after
   * @returns {Array<any>}
   */
  diff(before, after) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_diff(retptr, this.__wbg_ptr, addHeapObject(before), addHeapObject(after));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Array<any>} heads
   */
  isolate(heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_isolate(retptr, this.__wbg_ptr, addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  integrate() {
    wasm.automerge_integrate(this.__wbg_ptr);
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null} [heads]
   * @returns {number}
   */
  length(obj, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_length(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getFloat64(retptr + 8 * 0, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      return r0;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} prop
   */
  delete(obj, prop) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_delete(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(prop));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {Uint8Array}
   */
  save() {
    const ret = wasm.automerge_save(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {Uint8Array}
   */
  saveIncremental() {
    const ret = wasm.automerge_saveIncremental(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {Array<any>} heads
   * @returns {Uint8Array}
   */
  saveSince(heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_saveSince(retptr, this.__wbg_ptr, addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {Uint8Array}
   */
  saveNoCompress() {
    const ret = wasm.automerge_saveNoCompress(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {Uint8Array}
   */
  saveAndVerify() {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_saveAndVerify(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Uint8Array} data
   * @returns {number}
   */
  loadIncremental(data) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_loadIncremental(retptr, this.__wbg_ptr, addHeapObject(data));
      var r0 = getDataViewMemory0().getFloat64(retptr + 8 * 0, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      return r0;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} changes
   */
  applyChanges(changes) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_applyChanges(retptr, this.__wbg_ptr, addHeapObject(changes));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} have_deps
   * @returns {Array<any>}
   */
  getChanges(have_deps) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getChanges(retptr, this.__wbg_ptr, addHeapObject(have_deps));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} hash
   * @returns {any}
   */
  getChangeByHash(hash) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getChangeByHash(retptr, this.__wbg_ptr, addHeapObject(hash));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} hash
   * @returns {any}
   */
  getDecodedChangeByHash(hash) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getDecodedChangeByHash(retptr, this.__wbg_ptr, addHeapObject(hash));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {Automerge} other
   * @returns {Array<any>}
   */
  getChangesAdded(other) {
    _assertClass(other, _Automerge);
    const ret = wasm.automerge_getChangesAdded(this.__wbg_ptr, other.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {Array<any>}
   */
  getHeads() {
    const ret = wasm.automerge_getHeads(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {string}
   */
  getActorId() {
    let deferred1_0;
    let deferred1_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getActorId(retptr, this.__wbg_ptr);
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      deferred1_0 = r0;
      deferred1_1 = r1;
      return getStringFromWasm0(r0, r1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
  }
  /**
   * @returns {any}
   */
  getLastLocalChange() {
    const ret = wasm.automerge_getLastLocalChange(this.__wbg_ptr);
    return takeObject(ret);
  }
  dump() {
    wasm.automerge_dump(this.__wbg_ptr);
  }
  /**
   * @param {Array<any> | null} [heads]
   * @returns {Array<any>}
   */
  getMissingDeps(heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getMissingDeps(retptr, this.__wbg_ptr, isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {SyncState} state
   * @param {Uint8Array} message
   */
  receiveSyncMessage(state, message) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      _assertClass(state, SyncState);
      wasm.automerge_receiveSyncMessage(retptr, this.__wbg_ptr, state.__wbg_ptr, addHeapObject(message));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {SyncState} state
   * @returns {any}
   */
  generateSyncMessage(state) {
    _assertClass(state, SyncState);
    const ret = wasm.automerge_generateSyncMessage(this.__wbg_ptr, state.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {any} meta
   * @returns {any}
   */
  toJS(meta) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_toJS(retptr, this.__wbg_ptr, addHeapObject(meta));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null | undefined} heads
   * @param {any} meta
   * @returns {any}
   */
  materialize(obj, heads, meta) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_materialize(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads), addHeapObject(meta));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} position
   * @param {Array<any> | null | undefined} heads
   * @param {any} move_cursor
   * @returns {string}
   */
  getCursor(obj, position, heads, move_cursor) {
    let deferred2_0;
    let deferred2_1;
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getCursor(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(position), isLikeNone(heads) ? 0 : addHeapObject(heads), addHeapObject(move_cursor));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      var ptr1 = r0;
      var len1 = r1;
      if (r3) {
        ptr1 = 0;
        len1 = 0;
        throw takeObject(r2);
      }
      deferred2_0 = ptr1;
      deferred2_1 = len1;
      return getStringFromWasm0(ptr1, len1);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
      wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
  }
  /**
   * @param {any} obj
   * @param {any} cursor
   * @param {Array<any> | null} [heads]
   * @returns {number}
   */
  getCursorPosition(obj, cursor, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_getCursorPosition(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(cursor), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getFloat64(retptr + 8 * 0, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      var r3 = getDataViewMemory0().getInt32(retptr + 4 * 3, true);
      if (r3) {
        throw takeObject(r2);
      }
      return r0;
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {string | null} [message]
   * @param {number | null} [time]
   * @returns {any}
   */
  emptyChange(message, time) {
    var ptr0 = isLikeNone(message) ? 0 : passStringToWasm0(message, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len0 = WASM_VECTOR_LEN;
    const ret = wasm.automerge_emptyChange(this.__wbg_ptr, ptr0, len0, !isLikeNone(time), isLikeNone(time) ? 0 : time);
    return takeObject(ret);
  }
  /**
   * @param {any} obj
   * @param {any} range
   * @param {any} name
   * @param {any} value
   * @param {any} datatype
   */
  mark(obj, range, name, value, datatype) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_mark(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(range), addHeapObject(name), addHeapObject(value), addHeapObject(datatype));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {any} range
   * @param {any} name
   */
  unmark(obj, range, name) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_unmark(retptr, this.__wbg_ptr, addHeapObject(obj), addHeapObject(range), addHeapObject(name));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {Array<any> | null} [heads]
   * @returns {any}
   */
  marks(obj, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_marks(retptr, this.__wbg_ptr, addHeapObject(obj), isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} obj
   * @param {number} index
   * @param {Array<any> | null} [heads]
   * @returns {object}
   */
  marksAt(obj, index, heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.automerge_marksAt(retptr, this.__wbg_ptr, addHeapObject(obj), index, isLikeNone(heads) ? 0 : addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      var r2 = getDataViewMemory0().getInt32(retptr + 4 * 2, true);
      if (r2) {
        throw takeObject(r1);
      }
      return takeObject(r0);
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {SyncState} state
   * @returns {any}
   */
  hasOurChanges(state) {
    _assertClass(state, SyncState);
    const ret = wasm.automerge_hasOurChanges(this.__wbg_ptr, state.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {any}
   */
  topoHistoryTraversal() {
    const ret = wasm.automerge_topoHistoryTraversal(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {any}
   */
  stats() {
    const ret = wasm.automerge_stats(this.__wbg_ptr);
    return takeObject(ret);
  }
};
var SyncStateFinalization = typeof FinalizationRegistry === "undefined" ? { register: () => {
}, unregister: () => {
} } : new FinalizationRegistry((ptr) => wasm.__wbg_syncstate_free(ptr >>> 0, 1));
var SyncState = class _SyncState {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(_SyncState.prototype);
    obj.__wbg_ptr = ptr;
    SyncStateFinalization.register(obj, obj.__wbg_ptr, obj);
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    SyncStateFinalization.unregister(this);
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_syncstate_free(ptr, 0);
  }
  /**
   * @returns {any}
   */
  get sharedHeads() {
    const ret = wasm.syncstate_sharedHeads(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @returns {any}
   */
  get lastSentHeads() {
    const ret = wasm.syncstate_lastSentHeads(this.__wbg_ptr);
    return takeObject(ret);
  }
  /**
   * @param {any} heads
   */
  set lastSentHeads(heads) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.syncstate_set_lastSentHeads(retptr, this.__wbg_ptr, addHeapObject(heads));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @param {any} hashes
   */
  set sentHashes(hashes) {
    try {
      const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
      wasm.syncstate_set_sentHashes(retptr, this.__wbg_ptr, addHeapObject(hashes));
      var r0 = getDataViewMemory0().getInt32(retptr + 4 * 0, true);
      var r1 = getDataViewMemory0().getInt32(retptr + 4 * 1, true);
      if (r1) {
        throw takeObject(r0);
      }
    } finally {
      wasm.__wbindgen_add_to_stack_pointer(16);
    }
  }
  /**
   * @returns {SyncState}
   */
  clone() {
    const ret = wasm.syncstate_clone(this.__wbg_ptr);
    return _SyncState.__wrap(ret);
  }
};
async function __wbg_load(module2, imports) {
  if (typeof Response === "function" && module2 instanceof Response) {
    if (typeof WebAssembly.instantiateStreaming === "function") {
      try {
        return await WebAssembly.instantiateStreaming(module2, imports);
      } catch (e) {
        if (module2.headers.get("Content-Type") != "application/wasm") {
          console.warn("`WebAssembly.instantiateStreaming` failed because your server does not serve Wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", e);
        } else {
          throw e;
        }
      }
    }
    const bytes = await module2.arrayBuffer();
    return await WebAssembly.instantiate(bytes, imports);
  } else {
    const instance = await WebAssembly.instantiate(module2, imports);
    if (instance instanceof WebAssembly.Instance) {
      return { instance, module: module2 };
    } else {
      return instance;
    }
  }
}
function __wbg_get_imports() {
  const imports = {};
  imports.wbg = {};
  imports.wbg.__wbg_String_fed4d24b68977888 = function(arg0, arg1) {
    const ret = String(getObject(arg1));
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_apply_eb9e9b97497f91e4 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = Reflect.apply(getObject(arg0), getObject(arg1), getObject(arg2));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_assign_3627b8559449930a = function(arg0, arg1) {
    const ret = Object.assign(getObject(arg0), getObject(arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_buffer_609cc3eee51ed158 = function(arg0) {
    const ret = getObject(arg0).buffer;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_call_672a4d21634d4a24 = function() {
    return handleError(function(arg0, arg1) {
      const ret = getObject(arg0).call(getObject(arg1));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_call_7cccdd69e0791ae2 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = getObject(arg0).call(getObject(arg1), getObject(arg2));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_concat_9de968491c4340cf = function(arg0, arg1) {
    const ret = getObject(arg0).concat(getObject(arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_defineProperty_a3ddad9901e2d29e = function(arg0, arg1, arg2) {
    const ret = Object.defineProperty(getObject(arg0), getObject(arg1), getObject(arg2));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_deleteProperty_96363d4a1d977c97 = function() {
    return handleError(function(arg0, arg1) {
      const ret = Reflect.deleteProperty(getObject(arg0), getObject(arg1));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_done_769e5ede4b31c67b = function(arg0) {
    const ret = getObject(arg0).done;
    return ret;
  };
  imports.wbg.__wbg_entries_3265d4158b33e5dc = function(arg0) {
    const ret = Object.entries(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_error_7534b8e9a36f1ab4 = function(arg0, arg1) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg0;
      deferred0_1 = arg1;
      console.error(getStringFromWasm0(arg0, arg1));
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  };
  imports.wbg.__wbg_for_4ff07bddd743c5e7 = function(arg0, arg1) {
    const ret = Symbol.for(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_freeze_ef6d70cf38e8d948 = function(arg0) {
    const ret = Object.freeze(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_from_2a5d3e218e67aa85 = function(arg0) {
    const ret = Array.from(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_getRandomValues_3d90134a348e46b3 = function() {
    return handleError(function(arg0, arg1) {
      globalThis.crypto.getRandomValues(getArrayU8FromWasm0(arg0, arg1));
    }, arguments);
  };
  imports.wbg.__wbg_getTime_46267b1c24877e30 = function(arg0) {
    const ret = getObject(arg0).getTime();
    return ret;
  };
  imports.wbg.__wbg_get_67b2ba62fc30de12 = function() {
    return handleError(function(arg0, arg1) {
      const ret = Reflect.get(getObject(arg0), getObject(arg1));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_get_b9b93047fe3cf45b = function(arg0, arg1) {
    const ret = getObject(arg0)[arg1 >>> 0];
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_instanceof_ArrayBuffer_e14585432e3737fc = function(arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof ArrayBuffer;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Date_e9a9be8b9cea7890 = function(arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof Date;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Object_7f2dcef8f78644a4 = function(arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof Object;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Uint8Array_17156bcf118086a9 = function(arg0) {
    let result;
    try {
      result = getObject(arg0) instanceof Uint8Array;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_isArray_a1eab7e0d067391b = function(arg0) {
    const ret = Array.isArray(getObject(arg0));
    return ret;
  };
  imports.wbg.__wbg_iterator_9a24c88df860dc65 = function() {
    const ret = Symbol.iterator;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_keys_5c77a08ddc2fb8a6 = function(arg0) {
    const ret = Object.keys(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_length_a446193dc22c12f8 = function(arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_length_d56737991078581b = function(arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_length_e2d2a49132c1b256 = function(arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_log_1ae1e9f741096e91 = function(arg0, arg1) {
    console.log(getObject(arg0), getObject(arg1));
  };
  imports.wbg.__wbg_log_c222819a41e063d3 = function(arg0) {
    console.log(getObject(arg0));
  };
  imports.wbg.__wbg_new_1ab78df5e132f715 = function(arg0, arg1) {
    const ret = new RangeError(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_31a97dac4f10fab7 = function(arg0) {
    const ret = new Date(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_405e22f390576ce2 = function() {
    const ret = new Object();
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_78feb108b6472713 = function() {
    const ret = new Array();
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_8a6f238a6ece86ea = function() {
    const ret = new Error();
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_a12002a7f91c75be = function(arg0) {
    const ret = new Uint8Array(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_new_c68d7209be747379 = function(arg0, arg1) {
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_newwithbyteoffsetandlength_d97e637ebe145a9a = function(arg0, arg1, arg2) {
    const ret = new Uint8Array(getObject(arg0), arg1 >>> 0, arg2 >>> 0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_next_25feadfc0913fea9 = function(arg0) {
    const ret = getObject(arg0).next;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_next_6574e1a8a62d1055 = function() {
    return handleError(function(arg0) {
      const ret = getObject(arg0).next();
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_ownKeys_3930041068756f1f = function() {
    return handleError(function(arg0) {
      const ret = Reflect.ownKeys(getObject(arg0));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_push_737cfc8c1432c2c6 = function(arg0, arg1) {
    const ret = getObject(arg0).push(getObject(arg1));
    return ret;
  };
  imports.wbg.__wbg_set_37837023f3d740e8 = function(arg0, arg1, arg2) {
    getObject(arg0)[arg1 >>> 0] = takeObject(arg2);
  };
  imports.wbg.__wbg_set_3fda3bac07393de4 = function(arg0, arg1, arg2) {
    getObject(arg0)[takeObject(arg1)] = takeObject(arg2);
  };
  imports.wbg.__wbg_set_65595bdd868b3009 = function(arg0, arg1, arg2) {
    getObject(arg0).set(getObject(arg1), arg2 >>> 0);
  };
  imports.wbg.__wbg_set_bb8cecf6a62b9f46 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = Reflect.set(getObject(arg0), getObject(arg1), getObject(arg2));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_slice_972c243648c9fd2e = function(arg0, arg1, arg2) {
    const ret = getObject(arg0).slice(arg1 >>> 0, arg2 >>> 0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_stack_0ed75d68575b0f3c = function(arg0, arg1) {
    const ret = getObject(arg1).stack;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_toString_66ab719c2a98bdf1 = function(arg0) {
    const ret = getObject(arg0).toString();
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_unshift_c290010f73f04fb1 = function(arg0, arg1) {
    const ret = getObject(arg0).unshift(getObject(arg1));
    return ret;
  };
  imports.wbg.__wbg_value_cd1ffa7b1ab794f1 = function(arg0) {
    const ret = getObject(arg0).value;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_values_fcb8ba8c0aad8b58 = function(arg0) {
    const ret = Object.values(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_bigint_from_i64 = function(arg0) {
    const ret = arg0;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_bigint_from_u64 = function(arg0) {
    const ret = BigInt.asUintN(64, arg0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_boolean_get = function(arg0) {
    const v = getObject(arg0);
    const ret = typeof v === "boolean" ? v ? 1 : 0 : 2;
    return ret;
  };
  imports.wbg.__wbindgen_debug_string = function(arg0, arg1) {
    const ret = debugString(getObject(arg1));
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbindgen_error_new = function(arg0, arg1) {
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_is_array = function(arg0) {
    const ret = Array.isArray(getObject(arg0));
    return ret;
  };
  imports.wbg.__wbindgen_is_function = function(arg0) {
    const ret = typeof getObject(arg0) === "function";
    return ret;
  };
  imports.wbg.__wbindgen_is_null = function(arg0) {
    const ret = getObject(arg0) === null;
    return ret;
  };
  imports.wbg.__wbindgen_is_object = function(arg0) {
    const val = getObject(arg0);
    const ret = typeof val === "object" && val !== null;
    return ret;
  };
  imports.wbg.__wbindgen_is_string = function(arg0) {
    const ret = typeof getObject(arg0) === "string";
    return ret;
  };
  imports.wbg.__wbindgen_is_undefined = function(arg0) {
    const ret = getObject(arg0) === void 0;
    return ret;
  };
  imports.wbg.__wbindgen_json_serialize = function(arg0, arg1) {
    const obj = getObject(arg1);
    const ret = JSON.stringify(obj === void 0 ? null : obj);
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbindgen_jsval_loose_eq = function(arg0, arg1) {
    const ret = getObject(arg0) == getObject(arg1);
    return ret;
  };
  imports.wbg.__wbindgen_memory = function() {
    const ret = wasm.memory;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_number_get = function(arg0, arg1) {
    const obj = getObject(arg1);
    const ret = typeof obj === "number" ? obj : void 0;
    getDataViewMemory0().setFloat64(arg0 + 8 * 1, isLikeNone(ret) ? 0 : ret, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
  };
  imports.wbg.__wbindgen_number_new = function(arg0) {
    const ret = arg0;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_object_clone_ref = function(arg0) {
    const ret = getObject(arg0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_object_drop_ref = function(arg0) {
    takeObject(arg0);
  };
  imports.wbg.__wbindgen_string_get = function(arg0, arg1) {
    const obj = getObject(arg1);
    const ret = typeof obj === "string" ? obj : void 0;
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbindgen_string_new = function(arg0, arg1) {
    const ret = getStringFromWasm0(arg0, arg1);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_throw = function(arg0, arg1) {
    throw new Error(getStringFromWasm0(arg0, arg1));
  };
  return imports;
}
function __wbg_init_memory(imports, memory) {
}
function __wbg_finalize_init(instance, module2) {
  wasm = instance.exports;
  __wbg_init.__wbindgen_wasm_module = module2;
  cachedDataViewMemory0 = null;
  cachedUint8ArrayMemory0 = null;
  return wasm;
}
function initSync(module2) {
  if (wasm !== void 0)
    return wasm;
  if (typeof module2 !== "undefined") {
    if (Object.getPrototypeOf(module2) === Object.prototype) {
      ({ module: module2 } = module2);
    } else {
      console.warn("using deprecated parameters for `initSync()`; pass a single object instead");
    }
  }
  const imports = __wbg_get_imports();
  __wbg_init_memory(imports);
  if (!(module2 instanceof WebAssembly.Module)) {
    module2 = new WebAssembly.Module(module2);
  }
  const instance = new WebAssembly.Instance(module2, imports);
  return __wbg_finalize_init(instance, module2);
}
async function __wbg_init(module_or_path) {
  if (wasm !== void 0)
    return wasm;
  if (typeof module_or_path !== "undefined") {
    if (Object.getPrototypeOf(module_or_path) === Object.prototype) {
      ({ module_or_path } = module_or_path);
    } else {
      console.warn("using deprecated parameters for the initialization function; pass a single object instead");
    }
  }
  if (typeof module_or_path === "undefined") {
    module_or_path = new URL("automerge_wasm_bg.wasm", import_meta.url);
  }
  const imports = __wbg_get_imports();
  if (typeof module_or_path === "string" || typeof Request === "function" && module_or_path instanceof Request || typeof URL === "function" && module_or_path instanceof URL) {
    module_or_path = fetch(module_or_path);
  }
  __wbg_init_memory(imports);
  const { instance, module: module2 } = await __wbg_load(await module_or_path, imports);
  return __wbg_finalize_init(instance, module2);
}
var automerge_wasm_default = __wbg_init;

// mjs/low_level.js
var _initialized = false;
var _initializeListeners = [];
function UseApi(api2) {
  for (const k in api2) {
    ;
    ApiHandler[k] = api2[k];
  }
  _initialized = true;
  for (const listener of _initializeListeners) {
    listener();
  }
}
var ApiHandler = {
  create(options) {
    throw new RangeError("Automerge.use() not called");
  },
  load(data, options) {
    throw new RangeError("Automerge.use() not called (load)");
  },
  encodeChange(change2) {
    throw new RangeError("Automerge.use() not called (encodeChange)");
  },
  decodeChange(change2) {
    throw new RangeError("Automerge.use() not called (decodeChange)");
  },
  initSyncState() {
    throw new RangeError("Automerge.use() not called (initSyncState)");
  },
  encodeSyncMessage(message) {
    throw new RangeError("Automerge.use() not called (encodeSyncMessage)");
  },
  decodeSyncMessage(msg) {
    throw new RangeError("Automerge.use() not called (decodeSyncMessage)");
  },
  encodeSyncState(state) {
    throw new RangeError("Automerge.use() not called (encodeSyncState)");
  },
  decodeSyncState(data) {
    throw new RangeError("Automerge.use() not called (decodeSyncState)");
  },
  exportSyncState(state) {
    throw new RangeError("Automerge.use() not called (exportSyncState)");
  },
  importSyncState(state) {
    throw new RangeError("Automerge.use() not called (importSyncState)");
  }
};
function initializeWasm(wasmBlob) {
  return automerge_wasm_default({ module_or_path: wasmBlob }).then((_) => {
    UseApi(automerge_wasm_exports);
  });
}
function initializeBase64Wasm(wasmBase64) {
  return initializeWasm(Uint8Array.from(atob(wasmBase64), (c) => c.charCodeAt(0)));
}
function wasmInitialized() {
  if (_initialized)
    return Promise.resolve();
  return new Promise((resolve) => {
    _initializeListeners.push(resolve);
  });
}
function isWasmInitialized() {
  return _initialized;
}

// mjs/entrypoints/fullfat_node.js
var api = __toESM(require_automerge_wasm(), 1);

// mjs/uuid.js
var import_uuid = require("uuid");
function defaultFactory() {
  return (0, import_uuid.v4)().replace(/-/g, "");
}
var factory = defaultFactory;
var uuid = () => {
  return factory();
};
uuid.setFactory = (newFactory) => {
  factory = newFactory;
};
uuid.reset = () => {
  factory = defaultFactory;
};

// mjs/constants.js
var STATE = Symbol.for("_am_meta");
var TRACE = Symbol.for("_am_trace");
var OBJECT_ID = Symbol.for("_am_objectId");
var IS_PROXY = Symbol.for("_am_isProxy");
var CLEAR_CACHE = Symbol.for("_am_clearCache");
var UINT = Symbol.for("_am_uint");
var INT = Symbol.for("_am_int");
var F64 = Symbol.for("_am_f64");
var COUNTER = Symbol.for("_am_counter");
var TEXT = Symbol.for("_am_text");
var RAW_STRING = Symbol.for("_am_rawString");

// mjs/text.js
var _a;
var Text = class _Text {
  constructor(text) {
    this[_a] = true;
    if (typeof text === "string") {
      this.elems = [...text];
    } else if (Array.isArray(text)) {
      this.elems = text;
    } else if (text === void 0) {
      this.elems = [];
    } else {
      throw new TypeError(`Unsupported initial value for Text: ${text}`);
    }
    Reflect.defineProperty(this, TEXT, { value: true });
  }
  get length() {
    return this.elems.length;
  }
  //eslint-disable-next-line @typescript-eslint/no-explicit-any
  get(index) {
    return this.elems[index];
  }
  /**
   * Iterates over the text elements character by character, including any
   * inline objects.
   */
  [(_a = TEXT, Symbol.iterator)]() {
    const elems = this.elems;
    let index = -1;
    return {
      next() {
        index += 1;
        if (index < elems.length) {
          return { done: false, value: elems[index] };
        } else {
          return { done: true };
        }
      }
    };
  }
  /**
   * Returns the content of the Text object as a simple string, ignoring any
   * non-character elements.
   */
  toString() {
    if (!this.str) {
      this.str = "";
      for (const elem of this.elems) {
        if (typeof elem === "string")
          this.str += elem;
        else
          this.str += "\uFFFC";
      }
    }
    return this.str;
  }
  /**
   * Returns the content of the Text object as a sequence of strings,
   * interleaved with non-character elements.
   *
   * For example, the value `['a', 'b', {x: 3}, 'c', 'd']` has spans:
   * `=> ['ab', {x: 3}, 'cd']`
   */
  toSpans() {
    if (!this.spans) {
      this.spans = [];
      let chars = "";
      for (const elem of this.elems) {
        if (typeof elem === "string") {
          chars += elem;
        } else {
          if (chars.length > 0) {
            this.spans.push(chars);
            chars = "";
          }
          this.spans.push(elem);
        }
      }
      if (chars.length > 0) {
        this.spans.push(chars);
      }
    }
    return this.spans;
  }
  /**
   * Returns the content of the Text object as a simple string, so that the
   * JSON serialization of an Automerge document represents text nicely.
   */
  toJSON() {
    return this.toString();
  }
  /**
   * Updates the list item at position `index` to a new value `value`.
   */
  set(index, value) {
    if (this[STATE]) {
      throw new RangeError("object cannot be modified outside of a change block");
    }
    this.elems[index] = value;
  }
  /**
   * Inserts new list items `values` starting at position `index`.
   */
  insertAt(index, ...values) {
    if (this[STATE]) {
      throw new RangeError("object cannot be modified outside of a change block");
    }
    if (values.every((v) => typeof v === "string")) {
      this.elems.splice(index, 0, ...values.join(""));
    } else {
      this.elems.splice(index, 0, ...values);
    }
  }
  /**
   * Deletes `numDelete` list items starting at position `index`.
   * if `numDelete` is not given, one item is deleted.
   */
  deleteAt(index, numDelete = 1) {
    if (this[STATE]) {
      throw new RangeError("object cannot be modified outside of a change block");
    }
    this.elems.splice(index, numDelete);
  }
  map(callback) {
    this.elems.map(callback);
  }
  lastIndexOf(searchElement, fromIndex) {
    this.elems.lastIndexOf(searchElement, fromIndex);
  }
  concat(other) {
    return new _Text(this.elems.concat(other.elems));
  }
  every(test) {
    return this.elems.every(test);
  }
  filter(test) {
    return new _Text(this.elems.filter(test));
  }
  find(test) {
    return this.elems.find(test);
  }
  findIndex(test) {
    return this.elems.findIndex(test);
  }
  forEach(f) {
    this.elems.forEach(f);
  }
  includes(elem) {
    return this.elems.includes(elem);
  }
  indexOf(elem) {
    return this.elems.indexOf(elem);
  }
  join(sep) {
    return this.elems.join(sep);
  }
  reduce(f) {
    this.elems.reduce(f);
  }
  reduceRight(f) {
    this.elems.reduceRight(f);
  }
  slice(start, end) {
    return new _Text(this.elems.slice(start, end));
  }
  some(test) {
    return this.elems.some(test);
  }
  toLocaleString() {
    this.toString();
  }
};

// mjs/counter.js
var Counter = class {
  constructor(value) {
    this.value = value || 0;
    Reflect.defineProperty(this, COUNTER, { value: true });
  }
  /**
   * A peculiar JavaScript language feature from its early days: if the object
   * `x` has a `valueOf()` method that returns a number, you can use numerical
   * operators on the object `x` directly, such as `x + 1` or `x < 4`.
   * This method is also called when coercing a value to a string by
   * concatenating it with another string, as in `x + ''`.
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/valueOf
   */
  valueOf() {
    return this.value;
  }
  /**
   * Returns the counter value as a decimal string. If `x` is a counter object,
   * this method is called e.g. when you do `['value: ', x].join('')` or when
   * you use string interpolation: `value: ${x}`.
   */
  toString() {
    return this.valueOf().toString();
  }
  /**
   * Returns the counter value, so that a JSON serialization of an Automerge
   * document represents the counter simply as an integer.
   */
  toJSON() {
    return this.value;
  }
  /**
   * Increases the value of the counter by `delta`. If `delta` is not given,
   * increases the value of the counter by 1.
   *
   * Will throw an error if used outside of a change callback.
   */
  increment(_delta) {
    throw new Error("Counters should not be incremented outside of a change callback");
  }
  /**
   * Decreases the value of the counter by `delta`. If `delta` is not given,
   * decreases the value of the counter by 1.
   *
   * Will throw an error if used outside of a change callback.
   */
  decrement(_delta) {
    throw new Error("Counters should not be decremented outside of a change callback");
  }
};
var WriteableCounter = class extends Counter {
  constructor(value, context, path, objectId, key) {
    super(value);
    this.context = context;
    this.path = path;
    this.objectId = objectId;
    this.key = key;
  }
  /**
   * Increases the value of the counter by `delta`. If `delta` is not given,
   * increases the value of the counter by 1.
   */
  increment(delta) {
    delta = typeof delta === "number" ? delta : 1;
    this.context.increment(this.objectId, this.key, delta);
    this.value += delta;
    return this.value;
  }
  /**
   * Decreases the value of the counter by `delta`. If `delta` is not given,
   * decreases the value of the counter by 1.
   */
  decrement(delta) {
    return this.increment(typeof delta === "number" ? -delta : -1);
  }
};
function getWriteableCounter(value, context, path, objectId, key) {
  return new WriteableCounter(value, context, path, objectId, key);
}

// mjs/raw_string.js
var _a2;
var RawString = class {
  constructor(val) {
    this[_a2] = true;
    this.val = val;
  }
  /**
   * Returns the content of the RawString object as a simple string
   */
  toString() {
    return this.val;
  }
  toJSON() {
    return this.val;
  }
};
_a2 = RAW_STRING;

// mjs/proxies.js
function parseListIndex(key) {
  if (typeof key === "string" && /^[0-9]+$/.test(key))
    key = parseInt(key, 10);
  if (typeof key !== "number") {
    return key;
  }
  if (key < 0 || isNaN(key) || key === Infinity || key === -Infinity) {
    throw new RangeError("A list index must be positive, but you passed " + key);
  }
  return key;
}
function valueAt(target, prop) {
  const { context, objectId, path, textV2 } = target;
  const value = context.getWithType(objectId, prop);
  if (value === null) {
    return;
  }
  const datatype = value[0];
  const val = value[1];
  switch (datatype) {
    case void 0:
      return;
    case "map":
      return mapProxy(context, val, textV2, [...path, prop]);
    case "list":
      return listProxy(context, val, textV2, [...path, prop]);
    case "text":
      if (textV2) {
        return context.text(val);
      } else {
        return textProxy(context, val, [
          ...path,
          prop
        ]);
      }
    case "str":
      if (textV2) {
        return new RawString(val);
      } else {
        return val;
      }
    case "uint":
      return val;
    case "int":
      return val;
    case "f64":
      return val;
    case "boolean":
      return val;
    case "null":
      return null;
    case "bytes":
      return val;
    case "timestamp":
      return val;
    case "counter": {
      const counter = getWriteableCounter(val, context, path, objectId, prop);
      return counter;
    }
    default:
      throw RangeError(`datatype ${datatype} unimplemented`);
  }
}
function import_value(value, textV2, path, context) {
  const type = typeof value;
  switch (type) {
    case "object":
      if (value == null) {
        return [null, "null"];
      } else if (value[UINT]) {
        return [value.value, "uint"];
      } else if (value[INT]) {
        return [value.value, "int"];
      } else if (value[F64]) {
        return [value.value, "f64"];
      } else if (value[COUNTER]) {
        return [value.value, "counter"];
      } else if (value instanceof Date) {
        return [value.getTime(), "timestamp"];
      } else if (isRawString(value)) {
        return [value.toString(), "str"];
      } else if (isText(value)) {
        return [value, "text"];
      } else if (value instanceof Uint8Array) {
        return [value, "bytes"];
      } else if (value instanceof Array) {
        return [value, "list"];
      } else if (Object.prototype.toString.call(value) === "[object Object]") {
        return [value, "map"];
      } else if (isSameDocument(value, context)) {
        throw new RangeError("Cannot create a reference to an existing document object");
      } else {
        throw new RangeError(`Cannot assign unknown object: ${value}`);
      }
    case "boolean":
      return [value, "boolean"];
    case "number":
      if (Number.isInteger(value)) {
        return [value, "int"];
      } else {
        return [value, "f64"];
      }
    case "string":
      if (textV2) {
        return [value, "text"];
      } else {
        return [value, "str"];
      }
    case "undefined":
      throw new RangeError([
        `Cannot assign undefined value at ${printPath(path)}, `,
        "because `undefined` is not a valid JSON data type. ",
        "You might consider setting the property's value to `null`, ",
        "or using `delete` to remove it altogether."
      ].join(""));
    default:
      throw new RangeError([
        `Cannot assign ${type} value at ${printPath(path)}. `,
        `All JSON primitive datatypes (object, array, string, number, boolean, null) `,
        `are supported in an Automerge document; ${type} values are not. `
      ].join(""));
  }
}
function isSameDocument(val, context) {
  var _b, _c;
  if (val instanceof Date) {
    return false;
  }
  if (val && ((_c = (_b = val[STATE]) === null || _b === void 0 ? void 0 : _b.handle) === null || _c === void 0 ? void 0 : _c.__wbg_ptr) === context.__wbg_ptr) {
    return true;
  }
  return false;
}
var MapHandler = {
  get(target, key) {
    const { context, objectId, cache } = target;
    if (key === Symbol.toStringTag) {
      return target[Symbol.toStringTag];
    }
    if (key === OBJECT_ID)
      return objectId;
    if (key === IS_PROXY)
      return true;
    if (key === TRACE)
      return target.trace;
    if (key === STATE)
      return { handle: context, textV2: target.textV2 };
    if (!cache[key]) {
      cache[key] = valueAt(target, key);
    }
    return cache[key];
  },
  set(target, key, val) {
    const { context, objectId, path, textV2 } = target;
    target.cache = {};
    if (isSameDocument(val, context)) {
      throw new RangeError("Cannot create a reference to an existing document object");
    }
    if (key === TRACE) {
      target.trace = val;
      return true;
    }
    if (key === CLEAR_CACHE) {
      return true;
    }
    const [value, datatype] = import_value(val, textV2, [...path, key], context);
    switch (datatype) {
      case "list": {
        const list = context.putObject(objectId, key, []);
        const proxyList = listProxy(context, list, textV2, [...path, key]);
        for (let i = 0; i < value.length; i++) {
          proxyList[i] = value[i];
        }
        break;
      }
      case "text": {
        if (textV2) {
          assertString(value);
          context.putObject(objectId, key, value);
        } else {
          assertText(value);
          const text = context.putObject(objectId, key, "");
          const proxyText = textProxy(context, text, [...path, key]);
          proxyText.splice(0, 0, ...value);
        }
        break;
      }
      case "map": {
        const map = context.putObject(objectId, key, {});
        const proxyMap = mapProxy(context, map, textV2, [...path, key]);
        for (const key2 in value) {
          proxyMap[key2] = value[key2];
        }
        break;
      }
      default:
        context.put(objectId, key, value, datatype);
    }
    return true;
  },
  deleteProperty(target, key) {
    const { context, objectId } = target;
    target.cache = {};
    context.delete(objectId, key);
    return true;
  },
  has(target, key) {
    const value = this.get(target, key);
    return value !== void 0;
  },
  getOwnPropertyDescriptor(target, key) {
    const value = this.get(target, key);
    if (typeof value !== "undefined") {
      return {
        configurable: true,
        enumerable: true,
        value
      };
    }
  },
  ownKeys(target) {
    const { context, objectId } = target;
    const keys = context.keys(objectId);
    return [...new Set(keys)];
  }
};
var ListHandler = {
  get(target, index) {
    const { context, objectId } = target;
    index = parseListIndex(index);
    if (index === Symbol.hasInstance) {
      return (instance) => {
        return Array.isArray(instance);
      };
    }
    if (index === Symbol.toStringTag) {
      return target[Symbol.toStringTag];
    }
    if (index === OBJECT_ID)
      return objectId;
    if (index === IS_PROXY)
      return true;
    if (index === TRACE)
      return target.trace;
    if (index === STATE)
      return { handle: context };
    if (index === "length")
      return context.length(objectId);
    if (typeof index === "number") {
      return valueAt(target, index);
    } else {
      return listMethods(target)[index];
    }
  },
  set(target, index, val) {
    const { context, objectId, path, textV2 } = target;
    index = parseListIndex(index);
    if (isSameDocument(val, context)) {
      throw new RangeError("Cannot create a reference to an existing document object");
    }
    if (index === CLEAR_CACHE) {
      return true;
    }
    if (index === TRACE) {
      target.trace = val;
      return true;
    }
    if (typeof index == "string") {
      throw new RangeError("list index must be a number");
    }
    const [value, datatype] = import_value(val, textV2, [...path, index], context);
    switch (datatype) {
      case "list": {
        let list;
        if (index >= context.length(objectId)) {
          list = context.insertObject(objectId, index, []);
        } else {
          list = context.putObject(objectId, index, []);
        }
        const proxyList = listProxy(context, list, textV2, [...path, index]);
        proxyList.splice(0, 0, ...value);
        break;
      }
      case "text": {
        if (textV2) {
          assertString(value);
          if (index >= context.length(objectId)) {
            context.insertObject(objectId, index, value);
          } else {
            context.putObject(objectId, index, value);
          }
        } else {
          let text;
          assertText(value);
          if (index >= context.length(objectId)) {
            text = context.insertObject(objectId, index, "");
          } else {
            text = context.putObject(objectId, index, "");
          }
          const proxyText = textProxy(context, text, [...path, index]);
          proxyText.splice(0, 0, ...value);
        }
        break;
      }
      case "map": {
        let map;
        if (index >= context.length(objectId)) {
          map = context.insertObject(objectId, index, {});
        } else {
          map = context.putObject(objectId, index, {});
        }
        const proxyMap = mapProxy(context, map, textV2, [...path, index]);
        for (const key in value) {
          proxyMap[key] = value[key];
        }
        break;
      }
      default:
        if (index >= context.length(objectId)) {
          context.insert(objectId, index, value, datatype);
        } else {
          context.put(objectId, index, value, datatype);
        }
    }
    return true;
  },
  deleteProperty(target, index) {
    const { context, objectId } = target;
    index = parseListIndex(index);
    const elem = context.get(objectId, index);
    if (elem != null && elem[0] == "counter") {
      throw new TypeError("Unsupported operation: deleting a counter from a list");
    }
    context.delete(objectId, index);
    return true;
  },
  has(target, index) {
    const { context, objectId } = target;
    index = parseListIndex(index);
    if (typeof index === "number") {
      return index < context.length(objectId);
    }
    return index === "length";
  },
  getOwnPropertyDescriptor(target, index) {
    const { context, objectId } = target;
    if (index === "length")
      return { writable: true, value: context.length(objectId) };
    if (index === OBJECT_ID)
      return { configurable: false, enumerable: false, value: objectId };
    index = parseListIndex(index);
    const value = valueAt(target, index);
    return { configurable: true, enumerable: true, value };
  },
  getPrototypeOf(target) {
    return Object.getPrototypeOf(target);
  },
  ownKeys() {
    const keys = [];
    keys.push("length");
    return keys;
  }
};
var TextHandler = Object.assign({}, ListHandler, {
  get(target, index) {
    const { context, objectId } = target;
    index = parseListIndex(index);
    if (index === Symbol.hasInstance) {
      return (instance) => {
        return Array.isArray(instance);
      };
    }
    if (index === Symbol.toStringTag) {
      return target[Symbol.toStringTag];
    }
    if (index === OBJECT_ID)
      return objectId;
    if (index === IS_PROXY)
      return true;
    if (index === TRACE)
      return target.trace;
    if (index === STATE)
      return { handle: context };
    if (index === "length")
      return context.length(objectId);
    if (typeof index === "number") {
      return valueAt(target, index);
    } else {
      return textMethods(target)[index] || listMethods(target)[index];
    }
  },
  getPrototypeOf() {
    return Object.getPrototypeOf(new Text());
  }
});
function mapProxy(context, objectId, textV2, path) {
  const target = {
    context,
    objectId,
    path: path || [],
    cache: {},
    textV2
  };
  const proxied = {};
  Object.assign(proxied, target);
  const result = new Proxy(proxied, MapHandler);
  return result;
}
function listProxy(context, objectId, textV2, path) {
  const target = {
    context,
    objectId,
    path: path || [],
    cache: {},
    textV2
  };
  const proxied = [];
  Object.assign(proxied, target);
  return new Proxy(proxied, ListHandler);
}
function textProxy(context, objectId, path) {
  const target = {
    context,
    objectId,
    path: path || [],
    cache: {},
    textV2: false
  };
  const proxied = {};
  Object.assign(proxied, target);
  return new Proxy(proxied, TextHandler);
}
function rootProxy(context, textV2) {
  return mapProxy(context, "_root", textV2, []);
}
function listMethods(target) {
  const { context, objectId, path, textV2 } = target;
  const methods = {
    at(index) {
      return valueAt(target, index);
    },
    deleteAt(index, numDelete) {
      if (typeof numDelete === "number") {
        context.splice(objectId, index, numDelete);
      } else {
        context.delete(objectId, index);
      }
      return this;
    },
    fill(val, start, end) {
      const [value, datatype] = import_value(val, textV2, [...path, start], context);
      const length = context.length(objectId);
      start = parseListIndex(start || 0);
      end = parseListIndex(end || length);
      for (let i = start; i < Math.min(end, length); i++) {
        if (datatype === "list" || datatype === "map") {
          context.putObject(objectId, i, value);
        } else if (datatype === "text") {
          if (textV2) {
            assertString(value);
            context.putObject(objectId, i, value);
          } else {
            assertText(value);
            const text = context.putObject(objectId, i, "");
            const proxyText = textProxy(context, text, [...path, i]);
            for (let i2 = 0; i2 < value.length; i2++) {
              proxyText[i2] = value.get(i2);
            }
          }
        } else {
          context.put(objectId, i, value, datatype);
        }
      }
      return this;
    },
    indexOf(o, start = 0) {
      const length = context.length(objectId);
      for (let i = start; i < length; i++) {
        const value = context.getWithType(objectId, i);
        if (value && (value[1] === o[OBJECT_ID] || value[1] === o)) {
          return i;
        }
      }
      return -1;
    },
    insertAt(index, ...values) {
      this.splice(index, 0, ...values);
      return this;
    },
    pop() {
      const length = context.length(objectId);
      if (length == 0) {
        return void 0;
      }
      const last = valueAt(target, length - 1);
      context.delete(objectId, length - 1);
      return last;
    },
    push(...values) {
      const len = context.length(objectId);
      this.splice(len, 0, ...values);
      return context.length(objectId);
    },
    shift() {
      if (context.length(objectId) == 0)
        return;
      const first = valueAt(target, 0);
      context.delete(objectId, 0);
      return first;
    },
    splice(index, del, ...vals) {
      index = parseListIndex(index);
      if (typeof del !== "number") {
        del = context.length(objectId) - index;
      }
      del = parseListIndex(del);
      for (const val of vals) {
        if (isSameDocument(val, context)) {
          throw new RangeError("Cannot create a reference to an existing document object");
        }
      }
      const result = [];
      for (let i = 0; i < del; i++) {
        const value = valueAt(target, index);
        if (value !== void 0) {
          result.push(value);
        }
        context.delete(objectId, index);
      }
      const values = vals.map((val, index2) => {
        try {
          return import_value(val, textV2, [...path], context);
        } catch (e) {
          if (e instanceof RangeError) {
            throw new RangeError(`${e.message} (at index ${index2} in the input)`);
          } else {
            throw e;
          }
        }
      });
      for (const [value, datatype] of values) {
        switch (datatype) {
          case "list": {
            const list = context.insertObject(objectId, index, []);
            const proxyList = listProxy(context, list, textV2, [...path, index]);
            proxyList.splice(0, 0, ...value);
            break;
          }
          case "text": {
            if (textV2) {
              assertString(value);
              context.insertObject(objectId, index, value);
            } else {
              const text = context.insertObject(objectId, index, "");
              const proxyText = textProxy(context, text, [...path, index]);
              proxyText.splice(0, 0, ...value);
            }
            break;
          }
          case "map": {
            const map = context.insertObject(objectId, index, {});
            const proxyMap = mapProxy(context, map, textV2, [...path, index]);
            for (const key in value) {
              proxyMap[key] = value[key];
            }
            break;
          }
          default:
            context.insert(objectId, index, value, datatype);
        }
        index += 1;
      }
      return result;
    },
    unshift(...values) {
      this.splice(0, 0, ...values);
      return context.length(objectId);
    },
    entries() {
      let i = 0;
      const iterator = {
        next: () => {
          const value = valueAt(target, i);
          if (value === void 0) {
            return { value: void 0, done: true };
          } else {
            return { value: [i++, value], done: false };
          }
        },
        [Symbol.iterator]() {
          return this;
        }
      };
      return iterator;
    },
    keys() {
      let i = 0;
      const len = context.length(objectId);
      const iterator = {
        next: () => {
          if (i < len) {
            return { value: i++, done: false };
          }
          return { value: void 0, done: true };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
      return iterator;
    },
    values() {
      let i = 0;
      const iterator = {
        next: () => {
          const value = valueAt(target, i++);
          if (value === void 0) {
            return { value: void 0, done: true };
          } else {
            return { value, done: false };
          }
        },
        [Symbol.iterator]() {
          return this;
        }
      };
      return iterator;
    },
    toArray() {
      const list = [];
      let value;
      do {
        value = valueAt(target, list.length);
        if (value !== void 0) {
          list.push(value);
        }
      } while (value !== void 0);
      return list;
    },
    map(f) {
      return this.toArray().map(f);
    },
    toString() {
      return this.toArray().toString();
    },
    toLocaleString() {
      return this.toArray().toLocaleString();
    },
    forEach(f) {
      return this.toArray().forEach(f);
    },
    // todo: real concat function is different
    concat(other) {
      return this.toArray().concat(other);
    },
    every(f) {
      return this.toArray().every(f);
    },
    filter(f) {
      return this.toArray().filter(f);
    },
    find(f) {
      let index = 0;
      for (const v of this) {
        if (f(v, index)) {
          return v;
        }
        index += 1;
      }
    },
    findIndex(f) {
      let index = 0;
      for (const v of this) {
        if (f(v, index)) {
          return index;
        }
        index += 1;
      }
      return -1;
    },
    includes(elem) {
      return this.find((e) => e === elem) !== void 0;
    },
    join(sep) {
      return this.toArray().join(sep);
    },
    reduce(f, initialValue) {
      return this.toArray().reduce(f, initialValue);
    },
    reduceRight(f, initialValue) {
      return this.toArray().reduceRight(f, initialValue);
    },
    lastIndexOf(search, fromIndex = Infinity) {
      return this.toArray().lastIndexOf(search, fromIndex);
    },
    slice(index, num) {
      return this.toArray().slice(index, num);
    },
    some(f) {
      let index = 0;
      for (const v of this) {
        if (f(v, index)) {
          return true;
        }
        index += 1;
      }
      return false;
    },
    [Symbol.iterator]: function* () {
      let i = 0;
      let value = valueAt(target, i);
      while (value !== void 0) {
        yield value;
        i += 1;
        value = valueAt(target, i);
      }
    }
  };
  return methods;
}
function textMethods(target) {
  const { context, objectId } = target;
  const methods = {
    set(index, value) {
      return this[index] = value;
    },
    get(index) {
      return this[index];
    },
    toString() {
      return context.text(objectId).replace(/￼/g, "");
    },
    toSpans() {
      const spans2 = [];
      let chars = "";
      const length = context.length(objectId);
      for (let i = 0; i < length; i++) {
        const value = this[i];
        if (typeof value === "string") {
          chars += value;
        } else {
          if (chars.length > 0) {
            spans2.push(chars);
            chars = "";
          }
          spans2.push(value);
        }
      }
      if (chars.length > 0) {
        spans2.push(chars);
      }
      return spans2;
    },
    toJSON() {
      return this.toString();
    },
    indexOf(o, start = 0) {
      const text = context.text(objectId);
      return text.indexOf(o, start);
    },
    insertAt(index, ...values) {
      if (values.every((v) => typeof v === "string")) {
        context.splice(objectId, index, 0, values.join(""));
      } else {
        listMethods(target).insertAt(index, ...values);
      }
    }
  };
  return methods;
}
function assertText(value) {
  if (!isText(value)) {
    throw new Error("value was not a Text instance");
  }
}
function assertString(value) {
  if (typeof value !== "string") {
    throw new Error("value was not a string");
  }
}
function printPath(path) {
  const jsonPointerComponents = path.map((component) => {
    if (typeof component === "number") {
      return component.toString();
    } else if (typeof component === "string") {
      return component.replace(/~/g, "~0").replace(/\//g, "~1");
    }
  });
  if (path.length === 0) {
    return "";
  } else {
    return "/" + jsonPointerComponents.join("/");
  }
}
function isRawString(obj) {
  return typeof obj === "object" && obj !== null && Object.prototype.hasOwnProperty.call(obj, RAW_STRING);
}
function isText(obj) {
  return typeof obj === "object" && obj !== null && Object.prototype.hasOwnProperty.call(obj, TEXT);
}

// mjs/numbers.js
var Int = class {
  constructor(value) {
    if (!(Number.isInteger(value) && value <= Number.MAX_SAFE_INTEGER && value >= Number.MIN_SAFE_INTEGER)) {
      throw new RangeError(`Value ${value} cannot be a uint`);
    }
    this.value = value;
    Reflect.defineProperty(this, INT, { value: true });
    Object.freeze(this);
  }
};
var Uint = class {
  constructor(value) {
    if (!(Number.isInteger(value) && value <= Number.MAX_SAFE_INTEGER && value >= 0)) {
      throw new RangeError(`Value ${value} cannot be a uint`);
    }
    this.value = value;
    Reflect.defineProperty(this, UINT, { value: true });
    Object.freeze(this);
  }
};
var Float64 = class {
  constructor(value) {
    if (typeof value !== "number") {
      throw new RangeError(`Value ${value} cannot be a float64`);
    }
    this.value = value || 0;
    Reflect.defineProperty(this, F64, { value: true });
    Object.freeze(this);
  }
};

// mjs/internal_state.js
function _state(doc, checkroot = true) {
  if (typeof doc !== "object") {
    throw new RangeError("must be the document root");
  }
  const state = Reflect.get(doc, STATE);
  if (state === void 0 || state == null || checkroot && _obj(doc) !== "_root") {
    throw new RangeError("must be the document root");
  }
  return state;
}
function _clear_cache(doc) {
  Reflect.set(doc, CLEAR_CACHE, true);
}
function _trace(doc) {
  return Reflect.get(doc, TRACE);
}
function _obj(doc) {
  if (!(typeof doc === "object") || doc === null) {
    return null;
  }
  return Reflect.get(doc, OBJECT_ID);
}
function _is_proxy(doc) {
  return !!Reflect.get(doc, IS_PROXY);
}

// mjs/conflicts.js
function stableConflictAt(context, objectId, prop) {
  return conflictAt(context, objectId, prop, true, (context2, conflictId) => {
    return new Text(context2.text(conflictId));
  });
}
function unstableConflictAt(context, objectId, prop) {
  return conflictAt(context, objectId, prop, true, (context2, conflictId) => {
    return context2.text(conflictId);
  });
}
function conflictAt(context, objectId, prop, textV2, handleText) {
  const values = context.getAll(objectId, prop);
  if (values.length <= 1) {
    return;
  }
  const result = {};
  for (const fullVal of values) {
    switch (fullVal[0]) {
      case "map":
        result[fullVal[1]] = mapProxy(context, fullVal[1], textV2, [prop]);
        break;
      case "list":
        result[fullVal[1]] = listProxy(context, fullVal[1], textV2, [prop]);
        break;
      case "text":
        result[fullVal[1]] = handleText(context, fullVal[1]);
        break;
      case "str":
      case "uint":
      case "int":
      case "f64":
      case "boolean":
      case "bytes":
      case "null":
        result[fullVal[2]] = fullVal[1];
        break;
      case "counter":
        result[fullVal[2]] = new Counter(fullVal[1]);
        break;
      case "timestamp":
        result[fullVal[2]] = new Date(fullVal[1]);
        break;
      default:
        throw RangeError(`datatype ${fullVal[0]} unimplemented`);
    }
  }
  return result;
}

// mjs/stable.js
var __rest = function(s, e) {
  var t = {};
  for (var p in s)
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
};
var SyncStateSymbol = Symbol("_syncstate");
function insertAt(list, index, ...values) {
  if (!_is_proxy(list)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  ;
  list.insertAt(index, ...values);
}
function deleteAt(list, index, numDelete) {
  if (!_is_proxy(list)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  ;
  list.deleteAt(index, numDelete);
}
function use(api2) {
  UseApi(api2);
}
function getBackend(doc) {
  return _state(doc).handle;
}
function importOpts(_actor) {
  if (typeof _actor === "object") {
    return _actor;
  } else {
    return { actor: _actor };
  }
}
function init(_opts) {
  const opts = importOpts(_opts);
  const freeze = !!opts.freeze;
  const patchCallback = opts.patchCallback;
  const text_v1 = !(opts.enableTextV2 || false);
  const actor = opts.actor;
  const handle = ApiHandler.create({ actor, text_v1 });
  handle.enableFreeze(!!opts.freeze);
  const textV2 = opts.enableTextV2 || false;
  registerDatatypes(handle, textV2);
  const doc = handle.materialize("/", void 0, {
    handle,
    heads: void 0,
    freeze,
    patchCallback,
    textV2
  });
  return doc;
}
function view(doc, heads) {
  const state = _state(doc);
  const handle = state.handle;
  return state.handle.materialize("/", heads, Object.assign(Object.assign({}, state), {
    handle,
    heads
  }));
}
function clone(doc, _opts) {
  const state = _state(doc);
  const heads = state.heads;
  const opts = importOpts(_opts);
  const handle = state.handle.fork(opts.actor, heads);
  handle.updateDiffCursor();
  const { heads: _oldHeads } = state, stateSansHeads = __rest(state, ["heads"]);
  stateSansHeads.patchCallback = opts.patchCallback;
  return handle.applyPatches(doc, Object.assign(Object.assign({}, stateSansHeads), { handle }));
}
function free(doc) {
  return _state(doc).handle.free();
}
function from(initialState, _opts) {
  return _change(init(_opts), "from", {}, (d) => Object.assign(d, initialState)).newDoc;
}
function change(doc, options, callback) {
  if (typeof options === "function") {
    return _change(doc, "change", {}, options).newDoc;
  } else if (typeof callback === "function") {
    if (typeof options === "string") {
      options = { message: options };
    }
    return _change(doc, "change", options, callback).newDoc;
  } else {
    throw RangeError("Invalid args for change");
  }
}
function changeAt(doc, scope, options, callback) {
  if (typeof options === "function") {
    return _change(doc, "changeAt", {}, options, scope);
  } else if (typeof callback === "function") {
    if (typeof options === "string") {
      options = { message: options };
    }
    return _change(doc, "changeAt", options, callback, scope);
  } else {
    throw RangeError("Invalid args for changeAt");
  }
}
function progressDocument(doc, source, heads, callback) {
  if (heads == null) {
    return doc;
  }
  const state = _state(doc);
  const nextState = Object.assign(Object.assign({}, state), { heads: void 0 });
  const { value: nextDoc, patches } = state.handle.applyAndReturnPatches(doc, nextState);
  if (patches.length > 0) {
    if (callback != null) {
      callback(patches, { before: doc, after: nextDoc, source });
    }
    const newState = _state(nextDoc);
    newState.mostRecentPatch = {
      before: _state(doc).heads,
      after: newState.handle.getHeads(),
      patches
    };
  }
  state.heads = heads;
  return nextDoc;
}
function _change(doc, source, options, callback, scope) {
  if (typeof callback !== "function") {
    throw new RangeError("invalid change function");
  }
  const state = _state(doc);
  if (doc === void 0 || state === void 0) {
    throw new RangeError("must be the document root");
  }
  if (state.heads) {
    throw new RangeError("Attempting to change an outdated document.  Use Automerge.clone() if you wish to make a writable copy.");
  }
  if (_is_proxy(doc)) {
    throw new RangeError("Calls to Automerge.change cannot be nested");
  }
  let heads = state.handle.getHeads();
  if (scope && headsEqual(scope, heads)) {
    scope = void 0;
  }
  if (scope) {
    state.handle.isolate(scope);
    heads = scope;
  }
  if (!("time" in options)) {
    options.time = Math.floor(Date.now() / 1e3);
  }
  try {
    state.heads = heads;
    const root = rootProxy(state.handle, state.textV2);
    callback(root);
    if (state.handle.pendingOps() === 0) {
      state.heads = void 0;
      if (scope) {
        state.handle.integrate();
      }
      return {
        newDoc: doc,
        newHeads: null
      };
    } else {
      const newHead = state.handle.commit(options.message, options.time);
      state.handle.integrate();
      return {
        newDoc: progressDocument(doc, source, heads, options.patchCallback || state.patchCallback),
        newHeads: newHead != null ? [newHead] : null
      };
    }
  } catch (e) {
    state.heads = void 0;
    state.handle.rollback();
    throw e;
  }
}
function emptyChange(doc, options) {
  if (options === void 0) {
    options = {};
  }
  if (typeof options === "string") {
    options = { message: options };
  }
  if (!("time" in options)) {
    options.time = Math.floor(Date.now() / 1e3);
  }
  const state = _state(doc);
  if (state.heads) {
    throw new RangeError("Attempting to change an outdated document.  Use Automerge.clone() if you wish to make a writable copy.");
  }
  if (_is_proxy(doc)) {
    throw new RangeError("Calls to Automerge.change cannot be nested");
  }
  const heads = state.handle.getHeads();
  state.handle.emptyChange(options.message, options.time);
  return progressDocument(doc, "emptyChange", heads);
}
function load2(data, _opts) {
  const opts = importOpts(_opts);
  const actor = opts.actor;
  const patchCallback = opts.patchCallback;
  const text_v1 = !(opts.enableTextV2 || false);
  const unchecked = opts.unchecked || false;
  const allowMissingDeps = opts.allowMissingChanges || false;
  const convertRawStringsToText = opts.convertRawStringsToText || false;
  const handle = ApiHandler.load(data, {
    text_v1,
    actor,
    unchecked,
    allowMissingDeps,
    convertRawStringsToText
  });
  handle.enableFreeze(!!opts.freeze);
  const textV2 = opts.enableTextV2 || false;
  registerDatatypes(handle, textV2);
  const doc = handle.materialize("/", void 0, {
    handle,
    heads: void 0,
    patchCallback,
    textV2
  });
  return doc;
}
function loadIncremental(doc, data, opts) {
  if (!opts) {
    opts = {};
  }
  const state = _state(doc);
  if (state.heads) {
    throw new RangeError("Attempting to change an out of date document - set at: " + _trace(doc));
  }
  if (_is_proxy(doc)) {
    throw new RangeError("Calls to Automerge.change cannot be nested");
  }
  const heads = state.handle.getHeads();
  state.handle.loadIncremental(data);
  return progressDocument(doc, "loadIncremental", heads, opts.patchCallback || state.patchCallback);
}
function saveIncremental(doc) {
  const state = _state(doc);
  if (state.heads) {
    throw new RangeError("Attempting to change an out of date document - set at: " + _trace(doc));
  }
  if (_is_proxy(doc)) {
    throw new RangeError("Calls to Automerge.change cannot be nested");
  }
  return state.handle.saveIncremental();
}
function save(doc) {
  return _state(doc).handle.save();
}
function merge(local, remote) {
  const localState = _state(local);
  if (localState.heads) {
    throw new RangeError("Attempting to change an out of date document - set at: " + _trace(local));
  }
  const heads = localState.handle.getHeads();
  const remoteState = _state(remote);
  const changes = localState.handle.getChangesAdded(remoteState.handle);
  localState.handle.applyChanges(changes);
  return progressDocument(local, "merge", heads, localState.patchCallback);
}
function getActorId(doc) {
  const state = _state(doc);
  return state.handle.getActorId();
}
function getConflicts(doc, prop) {
  const state = _state(doc, false);
  if (state.textV2) {
    throw new Error("use unstable.getConflicts for an unstable document");
  }
  const objectId = _obj(doc);
  if (objectId != null) {
    return stableConflictAt(state.handle, objectId, prop);
  } else {
    return void 0;
  }
}
function getLastLocalChange(doc) {
  const state = _state(doc);
  return state.handle.getLastLocalChange() || void 0;
}
function getObjectId(doc, prop) {
  if (prop) {
    const state = _state(doc, false);
    const objectId = _obj(doc);
    if (!state || !objectId) {
      return null;
    }
    return state.handle.get(objectId, prop);
  } else {
    return _obj(doc);
  }
}
function getChanges(oldState, newState) {
  const n = _state(newState);
  return n.handle.getChanges(getHeads(oldState));
}
function getAllChanges(doc) {
  const state = _state(doc);
  return state.handle.getChanges([]);
}
function applyChanges(doc, changes, opts) {
  const state = _state(doc);
  if (!opts) {
    opts = {};
  }
  if (state.heads) {
    throw new RangeError("Attempting to change an outdated document.  Use Automerge.clone() if you wish to make a writable copy.");
  }
  if (_is_proxy(doc)) {
    throw new RangeError("Calls to Automerge.change cannot be nested");
  }
  const heads = state.handle.getHeads();
  state.handle.applyChanges(changes);
  state.heads = heads;
  return [
    progressDocument(doc, "applyChanges", heads, opts.patchCallback || state.patchCallback)
  ];
}
function getHistory(doc) {
  const textV2 = _state(doc).textV2;
  const history = getAllChanges(doc);
  return history.map((change2, index) => ({
    get change() {
      return decodeChange2(change2);
    },
    get snapshot() {
      const [state] = applyChanges(init({ enableTextV2: textV2 }), history.slice(0, index + 1));
      return state;
    }
  }));
}
function diff(doc, before, after) {
  checkHeads(before, "before");
  checkHeads(after, "after");
  const state = _state(doc);
  if (state.mostRecentPatch && equals(state.mostRecentPatch.before, before) && equals(state.mostRecentPatch.after, after)) {
    return state.mostRecentPatch.patches;
  }
  return state.handle.diff(before, after);
}
function headsEqual(heads1, heads2) {
  if (heads1.length !== heads2.length) {
    return false;
  }
  for (let i = 0; i < heads1.length; i++) {
    if (heads1[i] !== heads2[i]) {
      return false;
    }
  }
  return true;
}
function checkHeads(heads, fieldname) {
  if (!Array.isArray(heads)) {
    throw new Error(`${fieldname} must be an array`);
  }
}
function equals(val1, val2) {
  if (!isObject(val1) || !isObject(val2))
    return val1 === val2;
  const keys1 = Object.keys(val1).sort(), keys2 = Object.keys(val2).sort();
  if (keys1.length !== keys2.length)
    return false;
  for (let i = 0; i < keys1.length; i++) {
    if (keys1[i] !== keys2[i])
      return false;
    if (!equals(val1[keys1[i]], val2[keys2[i]]))
      return false;
  }
  return true;
}
function encodeSyncState2(state) {
  const sync = ApiHandler.importSyncState(state);
  const result = ApiHandler.encodeSyncState(sync);
  sync.free();
  return result;
}
function decodeSyncState2(state) {
  const sync = ApiHandler.decodeSyncState(state);
  const result = ApiHandler.exportSyncState(sync);
  sync.free();
  return result;
}
function generateSyncMessage(doc, inState) {
  const state = _state(doc);
  const syncState = ApiHandler.importSyncState(inState);
  const message = state.handle.generateSyncMessage(syncState);
  const outState = ApiHandler.exportSyncState(syncState);
  return [outState, message];
}
function receiveSyncMessage(doc, inState, message, opts) {
  const syncState = ApiHandler.importSyncState(inState);
  if (!opts) {
    opts = {};
  }
  const state = _state(doc);
  if (state.heads) {
    throw new RangeError("Attempting to change an outdated document.  Use Automerge.clone() if you wish to make a writable copy.");
  }
  if (_is_proxy(doc)) {
    throw new RangeError("Calls to Automerge.change cannot be nested");
  }
  const heads = state.handle.getHeads();
  state.handle.receiveSyncMessage(syncState, message);
  const outSyncState = ApiHandler.exportSyncState(syncState);
  return [
    progressDocument(doc, "receiveSyncMessage", heads, opts.patchCallback || state.patchCallback),
    outSyncState,
    null
  ];
}
function hasOurChanges(doc, remoteState) {
  const state = _state(doc);
  const syncState = ApiHandler.importSyncState(remoteState);
  return state.handle.hasOurChanges(syncState);
}
function initSyncState2() {
  return ApiHandler.exportSyncState(ApiHandler.initSyncState());
}
function encodeChange2(change2) {
  return ApiHandler.encodeChange(change2);
}
function decodeChange2(data) {
  return ApiHandler.decodeChange(data);
}
function encodeSyncMessage2(message) {
  return ApiHandler.encodeSyncMessage(message);
}
function decodeSyncMessage2(message) {
  return ApiHandler.decodeSyncMessage(message);
}
function getMissingDeps(doc, heads) {
  const state = _state(doc);
  return state.handle.getMissingDeps(heads);
}
function getHeads(doc) {
  const state = _state(doc);
  return state.heads || state.handle.getHeads();
}
function dump(doc) {
  const state = _state(doc);
  state.handle.dump();
}
function toJS(doc) {
  const state = _state(doc);
  const enabled = state.handle.enableFreeze(false);
  const result = state.handle.materialize("/", state.heads);
  state.handle.enableFreeze(enabled);
  return result;
}
function isAutomerge(doc) {
  if (typeof doc == "object" && doc !== null) {
    return getObjectId(doc) === "_root" && !!Reflect.get(doc, STATE);
  } else {
    return false;
  }
}
function isObject(obj) {
  return typeof obj === "object" && obj !== null;
}
function saveSince(doc, heads) {
  const state = _state(doc);
  const result = state.handle.saveSince(heads);
  return result;
}
function hasHeads(doc, heads) {
  const state = _state(doc);
  for (const hash of heads) {
    if (!state.handle.getChangeByHash(hash)) {
      return false;
    }
  }
  return true;
}
function registerDatatypes(handle, textV2) {
  handle.registerDatatype("counter", (n) => new Counter(n), (n) => {
    if (n instanceof Counter) {
      return n.value;
    }
  });
  if (textV2) {
    handle.registerDatatype("str", (n) => {
      return new RawString(n);
    }, (s) => {
      if (isRawString(s)) {
        return s.val;
      }
    });
  } else {
    handle.registerDatatype("text", (n) => new Text(n), (t) => {
      if (t instanceof Text) {
        return t.join("");
      }
    });
  }
}
function topoHistoryTraversal(doc) {
  const state = _state(doc);
  return state.handle.topoHistoryTraversal();
}
function inspectChange(doc, changeHash) {
  const state = _state(doc);
  return state.handle.getDecodedChangeByHash(changeHash);
}
function stats(doc) {
  const state = _state(doc);
  return state.handle.stats();
}

// mjs/next_slim.js
var next_slim_exports = {};
__export(next_slim_exports, {
  Counter: () => Counter,
  Float64: () => Float64,
  Int: () => Int,
  RawString: () => RawString,
  Uint: () => Uint,
  applyChanges: () => applyChanges,
  block: () => block,
  change: () => change,
  changeAt: () => changeAt,
  clone: () => clone2,
  decodeChange: () => decodeChange2,
  decodeSyncMessage: () => decodeSyncMessage2,
  decodeSyncState: () => decodeSyncState2,
  deleteAt: () => deleteAt,
  diff: () => diff,
  dump: () => dump,
  emptyChange: () => emptyChange,
  encodeChange: () => encodeChange2,
  encodeSyncMessage: () => encodeSyncMessage2,
  encodeSyncState: () => encodeSyncState2,
  equals: () => equals,
  free: () => free,
  from: () => from2,
  generateSyncMessage: () => generateSyncMessage,
  getActorId: () => getActorId,
  getAllChanges: () => getAllChanges,
  getBackend: () => getBackend2,
  getChanges: () => getChanges,
  getConflicts: () => getConflicts2,
  getCursor: () => getCursor,
  getCursorPosition: () => getCursorPosition,
  getHeads: () => getHeads,
  getHistory: () => getHistory,
  getLastLocalChange: () => getLastLocalChange,
  getMissingDeps: () => getMissingDeps,
  getObjectId: () => getObjectId,
  hasHeads: () => hasHeads,
  hasOurChanges: () => hasOurChanges,
  init: () => init2,
  initSyncState: () => initSyncState2,
  initializeBase64Wasm: () => initializeBase64Wasm,
  initializeWasm: () => initializeWasm,
  insertAt: () => insertAt,
  inspectChange: () => inspectChange,
  isAutomerge: () => isAutomerge,
  isRawString: () => isRawString,
  isWasmInitialized: () => isWasmInitialized,
  joinBlock: () => joinBlock,
  load: () => load3,
  loadIncremental: () => loadIncremental,
  mark: () => mark,
  marks: () => marks,
  marksAt: () => marksAt,
  merge: () => merge,
  receiveSyncMessage: () => receiveSyncMessage,
  save: () => save,
  saveIncremental: () => saveIncremental,
  saveSince: () => saveSince,
  spans: () => spans,
  splice: () => splice,
  splitBlock: () => splitBlock,
  stats: () => stats,
  toJS: () => toJS,
  topoHistoryTraversal: () => topoHistoryTraversal,
  unmark: () => unmark,
  updateBlock: () => updateBlock,
  updateSpans: () => updateSpans,
  updateText: () => updateText,
  view: () => view,
  wasmInitialized: () => wasmInitialized
});
var getBackend2 = getBackend;
function init2(_opts) {
  const opts = importOpts2(_opts);
  opts.enableTextV2 = true;
  return init(opts);
}
function clone2(doc, _opts) {
  const opts = importOpts2(_opts);
  opts.enableTextV2 = true;
  return clone(doc, opts);
}
function from2(initialState, _opts) {
  const opts = importOpts2(_opts);
  opts.enableTextV2 = true;
  return from(initialState, opts);
}
function load3(data, _opts) {
  const opts = importOpts2(_opts);
  opts.enableTextV2 = true;
  if (opts.patchCallback) {
    return loadIncremental(init(opts), data);
  } else {
    return load2(data, opts);
  }
}
function importOpts2(_actor) {
  if (typeof _actor === "object") {
    return _actor;
  } else {
    return { actor: _actor };
  }
}
function cursorToIndex(state, value, index) {
  if (typeof index == "string") {
    if (/^-?[0-9]+@[0-9a-zA-Z]+$|^[se]$/.test(index)) {
      return state.handle.getCursorPosition(value, index);
    } else {
      throw new RangeError("index must be a number or cursor");
    }
  } else {
    return index;
  }
}
function splice(doc, path, index, del, newText) {
  const objPath = absoluteObjPath(doc, path, "splice");
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const state = _state(doc, false);
  _clear_cache(doc);
  index = cursorToIndex(state, objPath, index);
  try {
    return state.handle.splice(objPath, index, del, newText);
  } catch (e) {
    throw new RangeError(`Cannot splice: ${e}`);
  }
}
function updateText(doc, path, newText) {
  const objPath = absoluteObjPath(doc, path, "updateText");
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const state = _state(doc, false);
  _clear_cache(doc);
  try {
    return state.handle.updateText(objPath, newText);
  } catch (e) {
    throw new RangeError(`Cannot updateText: ${e}`);
  }
}
function spans(doc, path) {
  const state = _state(doc, false);
  const objPath = absoluteObjPath(doc, path, "spans");
  try {
    return state.handle.spans(objPath, state.heads);
  } catch (e) {
    throw new RangeError(`Cannot splice: ${e}`);
  }
}
function block(doc, path, index) {
  const objPath = absoluteObjPath(doc, path, "splitBlock");
  const state = _state(doc, false);
  index = cursorToIndex(state, objPath, index);
  try {
    return state.handle.getBlock(objPath, index);
  } catch (e) {
    throw new RangeError(`Cannot get block: ${e}`);
  }
}
function splitBlock(doc, path, index, block2) {
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const objPath = absoluteObjPath(doc, path, "splitBlock");
  const state = _state(doc, false);
  _clear_cache(doc);
  index = cursorToIndex(state, objPath, index);
  try {
    state.handle.splitBlock(objPath, index, block2);
  } catch (e) {
    throw new RangeError(`Cannot splice: ${e}`);
  }
}
function joinBlock(doc, path, index) {
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const objPath = absoluteObjPath(doc, path, "joinBlock");
  const state = _state(doc, false);
  _clear_cache(doc);
  index = cursorToIndex(state, objPath, index);
  try {
    state.handle.joinBlock(objPath, index);
  } catch (e) {
    throw new RangeError(`Cannot joinBlock: ${e}`);
  }
}
function updateBlock(doc, path, index, block2) {
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const objPath = absoluteObjPath(doc, path, "updateBlock");
  const state = _state(doc, false);
  _clear_cache(doc);
  index = cursorToIndex(state, objPath, index);
  try {
    state.handle.updateBlock(objPath, index, block2);
  } catch (e) {
    throw new RangeError(`Cannot updateBlock: ${e}`);
  }
}
function updateSpans(doc, path, newSpans) {
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const objPath = absoluteObjPath(doc, path, "updateSpans");
  const state = _state(doc, false);
  _clear_cache(doc);
  try {
    state.handle.updateSpans(objPath, newSpans);
  } catch (e) {
    throw new RangeError(`Cannot updateBlock: ${e}`);
  }
}
function getCursor(doc, path, position, move) {
  const objPath = absoluteObjPath(doc, path, "getCursor");
  const state = _state(doc, false);
  try {
    return state.handle.getCursor(objPath, position, state.heads, move);
  } catch (e) {
    throw new RangeError(`Cannot getCursor: ${e}`);
  }
}
function getCursorPosition(doc, path, cursor) {
  const objPath = absoluteObjPath(doc, path, "getCursorPosition");
  const state = _state(doc, false);
  try {
    return state.handle.getCursorPosition(objPath, cursor, state.heads);
  } catch (e) {
    throw new RangeError(`Cannot getCursorPosition: ${e}`);
  }
}
function mark(doc, path, range, name, value) {
  const objPath = absoluteObjPath(doc, path, "mark");
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const state = _state(doc, false);
  try {
    return state.handle.mark(objPath, range, name, value);
  } catch (e) {
    throw new RangeError(`Cannot mark: ${e}`);
  }
}
function unmark(doc, path, range, name) {
  const objPath = absoluteObjPath(doc, path, "unmark");
  if (!_is_proxy(doc)) {
    throw new RangeError("object cannot be modified outside of a change block");
  }
  const state = _state(doc, false);
  try {
    return state.handle.unmark(objPath, range, name);
  } catch (e) {
    throw new RangeError(`Cannot unmark: ${e}`);
  }
}
function marks(doc, path) {
  const objPath = absoluteObjPath(doc, path, "marks");
  const state = _state(doc, false);
  try {
    return state.handle.marks(objPath);
  } catch (e) {
    throw new RangeError(`Cannot call marks(): ${e}`);
  }
}
function marksAt(doc, path, index) {
  const objPath = absoluteObjPath(doc, path, "marksAt");
  const state = _state(doc, false);
  try {
    return state.handle.marksAt(objPath, index);
  } catch (e) {
    throw new RangeError(`Cannot call marksAt(): ${e}`);
  }
}
function getConflicts2(doc, prop) {
  const state = _state(doc, false);
  if (!state.textV2) {
    throw new Error("use getConflicts for a stable document");
  }
  const objectId = _obj(doc);
  if (objectId != null) {
    return unstableConflictAt(state.handle, objectId, prop);
  } else {
    return void 0;
  }
}
function absoluteObjPath(doc, path, functionName) {
  path = path.slice();
  const objectId = _obj(doc);
  if (!objectId) {
    throw new RangeError(`invalid object for ${functionName}`);
  }
  path.unshift(objectId);
  return path.join("/");
}

// mjs/entrypoints/fullfat_node.js
UseApi(api);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Counter,
  Float64,
  Int,
  Text,
  Uint,
  applyChanges,
  change,
  changeAt,
  clone,
  decodeChange,
  decodeSyncMessage,
  decodeSyncState,
  deleteAt,
  diff,
  dump,
  emptyChange,
  encodeChange,
  encodeSyncMessage,
  encodeSyncState,
  equals,
  free,
  from,
  generateSyncMessage,
  getActorId,
  getAllChanges,
  getBackend,
  getChanges,
  getConflicts,
  getHeads,
  getHistory,
  getLastLocalChange,
  getMissingDeps,
  getObjectId,
  hasHeads,
  hasOurChanges,
  init,
  initSyncState,
  initializeBase64Wasm,
  initializeWasm,
  insertAt,
  inspectChange,
  isAutomerge,
  isText,
  isWasmInitialized,
  load,
  loadIncremental,
  merge,
  next,
  receiveSyncMessage,
  save,
  saveIncremental,
  saveSince,
  stats,
  toJS,
  topoHistoryTraversal,
  use,
  uuid,
  view,
  wasmInitialized
});
