import { default as initWasm } from "./wasm_bindgen_output/web/automerge_wasm.js";
import * as WasmApi from "./wasm_bindgen_output/web/automerge_wasm.js";
let _initialized = false;
let _initializeListeners = [];
export function UseApi(api) {
    for (const k in api) {
        // eslint-disable-next-line @typescript-eslint/no-extra-semi,@typescript-eslint/no-explicit-any
        ;
        ApiHandler[k] = api[k];
    }
    _initialized = true;
    for (const listener of _initializeListeners) {
        listener();
    }
}
/* eslint-disable */
export const ApiHandler = {
    create(options) {
        throw new RangeError("Automerge.use() not called");
    },
    load(data, options) {
        throw new RangeError("Automerge.use() not called (load)");
    },
    encodeChange(change) {
        throw new RangeError("Automerge.use() not called (encodeChange)");
    },
    decodeChange(change) {
        throw new RangeError("Automerge.use() not called (decodeChange)");
    },
    initSyncState() {
        throw new RangeError("Automerge.use() not called (initSyncState)");
    },
    encodeSyncMessage(message) {
        throw new RangeError("Automerge.use() not called (encodeSyncMessage)");
    },
    decodeSyncMessage(msg) {
        throw new RangeError("Automerge.use() not called (decodeSyncMessage)");
    },
    encodeSyncState(state) {
        throw new RangeError("Automerge.use() not called (encodeSyncState)");
    },
    decodeSyncState(data) {
        throw new RangeError("Automerge.use() not called (decodeSyncState)");
    },
    exportSyncState(state) {
        throw new RangeError("Automerge.use() not called (exportSyncState)");
    },
    importSyncState(state) {
        throw new RangeError("Automerge.use() not called (importSyncState)");
    },
};
/* eslint-enable */
/**
 * Initialize the wasm module
 *
 * @param wasmBlob - The wasm module as a Uint8Array, Request, Promise<Uint8Array> or string. If this argument is a string then it is assumed to be a URL and the library will attempt to fetch the wasm module from that URL.
 *
 * @remarks
 * If you are using the `/slim` subpath export then this function must be
 * called before any other functions in the library. If you are using any of
 * the other subpath exports then it will have already been called for you.
 */
export function initializeWasm(wasmBlob) {
    return initWasm({ module_or_path: wasmBlob }).then(_ => {
        UseApi(WasmApi);
    });
}
/**
 * Initialize the wasm module from a base64 encoded string
 *
 * @param wasmBase64 - The bytes of the wasm file as a base64 encoded string
 */
export function initializeBase64Wasm(wasmBase64) {
    return initializeWasm(Uint8Array.from(atob(wasmBase64), c => c.charCodeAt(0)));
}
/**
 * A promise which resolves when the web assembly module has been initialized
 * (or immediately if it has already been initialized)
 */
export function wasmInitialized() {
    if (_initialized)
        return Promise.resolve();
    return new Promise(resolve => {
        _initializeListeners.push(resolve);
    });
}
/**
 * Check if the wasm module has been initialized
 *
 * @returns true if the wasm module has been initialized
 */
export function isWasmInitialized() {
    return _initialized;
}
