import type { Value } from "./wasm_types.js";
import { TEXT, STATE } from "./constants.js";
import type { InternalState } from "./internal_state.js";
export declare class Text {
    [TEXT]: boolean;
    elems: Array<any>;
    str: string | undefined;
    spans: Array<any> | undefined;
    /** @hidden */
    [STATE]?: InternalState<any>;
    constructor(text?: string | string[] | Value[]);
    get length(): number;
    get(index: number): any;
    /**
     * Iterates over the text elements character by character, including any
     * inline objects.
     */
    [Symbol.iterator](): {
        next(): {
            done: boolean;
            value: any;
        } | {
            done: boolean;
            value?: undefined;
        };
    };
    /**
     * Returns the content of the Text object as a simple string, ignoring any
     * non-character elements.
     */
    toString(): string;
    /**
     * Returns the content of the Text object as a sequence of strings,
     * interleaved with non-character elements.
     *
     * For example, the value `['a', 'b', {x: 3}, 'c', 'd']` has spans:
     * `=> ['ab', {x: 3}, 'cd']`
     */
    toSpans(): Array<Value | object>;
    /**
     * Returns the content of the Text object as a simple string, so that the
     * JSON serialization of an Automerge document represents text nicely.
     */
    toJSON(): string;
    /**
     * Updates the list item at position `index` to a new value `value`.
     */
    set(index: number, value: Value): void;
    /**
     * Inserts new list items `values` starting at position `index`.
     */
    insertAt(index: number, ...values: Array<Value | object>): void;
    /**
     * Deletes `numDelete` list items starting at position `index`.
     * if `numDelete` is not given, one item is deleted.
     */
    deleteAt(index: number, numDelete?: number): void;
    map<T>(callback: (e: Value | object) => T): void;
    lastIndexOf(searchElement: Value, fromIndex?: number): void;
    concat(other: Text): Text;
    every(test: (v: Value) => boolean): boolean;
    filter(test: (v: Value) => boolean): Text;
    find(test: (v: Value) => boolean): Value | undefined;
    findIndex(test: (v: Value) => boolean): number | undefined;
    forEach(f: (v: Value) => undefined): void;
    includes(elem: Value): boolean;
    indexOf(elem: Value): number;
    join(sep?: string): string;
    reduce(f: (previousValue: Value, currentValue: Value, currentIndex: number, array: Value[]) => Value): void;
    reduceRight(f: (previousValue: Value, currentValue: Value, currentIndex: number, array: Value[]) => Value): void;
    slice(start?: number, end?: number): Text;
    some(test: (arg: Value) => boolean): boolean;
    toLocaleString(): void;
}
